/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public abstract class TwofishCTR
implements Cipher {
    private static final int ivsize = 16;
    private SICBlockCipher cipher;

    @Override
    public int getIVSize() {
        return 16;
    }

    @Override
    public int getTagSize() {
        return 0;
    }

    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        int bsize;
        byte[] tmp;
        if (iv.length > 16) {
            tmp = new byte[16];
            System.arraycopy(iv, 0, tmp, 0, tmp.length);
            iv = tmp;
        }
        if (key.length > (bsize = this.getBlockSize())) {
            tmp = new byte[bsize];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        try {
            ParametersWithIV keyspec = new ParametersWithIV((CipherParameters)new KeyParameter(key, 0, key.length), iv, 0, iv.length);
            this.cipher = new SICBlockCipher((BlockCipher)new TwofishEngine());
            this.cipher.init(mode == 0, (CipherParameters)keyspec);
        }
        catch (Exception e2) {
            this.cipher = null;
            throw e2;
        }
    }

    @Override
    public void update(int foo) throws Exception {
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.cipher.processBytes(foo, s1, len, bar, s2);
    }

    @Override
    public void updateAAD(byte[] foo, int s1, int len) throws Exception {
    }

    @Override
    public void doFinal(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
    }

    @Override
    public boolean isCBC() {
        return false;
    }

    @Override
    public boolean isAEAD() {
        return false;
    }

    @Override
    public boolean isChaCha20() {
        return false;
    }
}

