/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairDeferred;
import com.jcraft.jsch.KeyPairECDSA;
import com.jcraft.jsch.KeyPairEd25519;
import com.jcraft.jsch.KeyPairEd448;
import com.jcraft.jsch.KeyPairPKCS8;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public abstract class KeyPair {
    public static final int DEFERRED = -1;
    public static final int ERROR = 0;
    public static final int DSA = 1;
    public static final int RSA = 2;
    public static final int ECDSA = 3;
    public static final int UNKNOWN = 4;
    public static final int ED25519 = 5;
    public static final int ED448 = 6;
    static final int VENDOR_OPENSSH = 0;
    static final int VENDOR_FSECURE = 1;
    static final int VENDOR_PUTTY = 2;
    static final int VENDOR_PKCS8 = 3;
    static final int VENDOR_OPENSSH_V1 = 4;
    int vendor = 0;
    private static final byte[] AUTH_MAGIC = Util.str2byte("openssh-key-v1\u0000");
    private static final byte[] cr = Util.str2byte("\n");
    protected String publicKeyComment = "no comment";
    JSch jsch = null;
    protected Cipher cipher;
    private HASH hash;
    private Random random;
    private byte[] passphrase;
    protected String kdfName;
    protected byte[] kdfOptions;
    static byte[][] header = new byte[][]{Util.str2byte("Proc-Type: 4,ENCRYPTED"), Util.str2byte("DEK-Info: DES-EDE3-CBC,")};
    private static byte[] space = Util.str2byte(" ");
    protected boolean encrypted = false;
    protected byte[] data = null;
    private byte[] iv = null;
    private byte[] publickeyblob = null;
    private static final String[] header1 = new String[]{"PuTTY-User-Key-File-2: ", "Encryption: ", "Comment: ", "Public-Lines: "};
    private static final String[] header2 = new String[]{"Private-Lines: "};
    private static final String[] header3 = new String[]{"Private-MAC: "};

    public static KeyPair genKeyPair(JSch jsch, int type) throws JSchException {
        return KeyPair.genKeyPair(jsch, type, 1024);
    }

    public static KeyPair genKeyPair(JSch jsch, int type, int key_size) throws JSchException {
        KeyPair kpair = null;
        if (type == 1) {
            kpair = new KeyPairDSA(jsch);
        } else if (type == 2) {
            kpair = new KeyPairRSA(jsch);
        } else if (type == 3) {
            kpair = new KeyPairECDSA(jsch);
        } else if (type == 5) {
            kpair = new KeyPairEd25519(jsch);
        } else if (type == 6) {
            kpair = new KeyPairEd448(jsch);
        }
        if (kpair != null) {
            kpair.generate(key_size);
        }
        return kpair;
    }

    abstract void generate(int var1) throws JSchException;

    abstract byte[] getBegin();

    abstract byte[] getEnd();

    abstract int getKeySize();

    public abstract byte[] getSignature(byte[] var1);

    public abstract byte[] getSignature(byte[] var1, String var2);

    public abstract Signature getVerifier();

    public abstract Signature getVerifier(String var1);

    public abstract byte[] forSSHAgent() throws JSchException;

    public String getPublicKeyComment() {
        return this.publicKeyComment;
    }

    public void setPublicKeyComment(String publicKeyComment) {
        this.publicKeyComment = publicKeyComment;
    }

    public KeyPair(JSch jsch) {
        this.jsch = jsch;
    }

    abstract byte[] getPrivateKey();

    public void writePrivateKey(OutputStream out) {
        this.writePrivateKey(out, null);
    }

    public void writePrivateKey(OutputStream out, byte[] passphrase) {
        byte[][] _iv;
        byte[] plain;
        byte[] encoded;
        if (passphrase == null) {
            passphrase = this.passphrase;
        }
        if ((encoded = this.encrypt(plain = this.getPrivateKey(), _iv = new byte[1][], passphrase)) != plain) {
            Util.bzero(plain);
        }
        byte[] iv = _iv[0];
        byte[] prv = Util.toBase64(encoded, 0, encoded.length, true);
        try {
            int i2;
            out.write(this.getBegin());
            out.write(cr);
            if (passphrase != null) {
                out.write(header[0]);
                out.write(cr);
                out.write(header[1]);
                for (i2 = 0; i2 < iv.length; ++i2) {
                    out.write(KeyPair.b2a((byte)(iv[i2] >>> 4 & 0xF)));
                    out.write(KeyPair.b2a((byte)(iv[i2] & 0xF)));
                }
                out.write(cr);
                out.write(cr);
            }
            for (i2 = 0; i2 < prv.length; i2 += 64) {
                if (i2 + 64 < prv.length) {
                    out.write(prv, i2, 64);
                    out.write(cr);
                    continue;
                }
                out.write(prv, i2, prv.length - i2);
                out.write(cr);
                break;
            }
            out.write(this.getEnd());
            out.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract byte[] getKeyTypeName();

    public abstract int getKeyType();

    public byte[] getPublicKeyBlob() {
        return this.publickeyblob;
    }

    public void writePublicKey(OutputStream out, String comment) {
        byte[] pubblob = this.getPublicKeyBlob();
        byte[] pub = Util.toBase64(pubblob, 0, pubblob.length, true);
        try {
            out.write(this.getKeyTypeName());
            out.write(space);
            out.write(pub, 0, pub.length);
            out.write(space);
            out.write(Util.str2byte(comment));
            out.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writePublicKey(String name, String comment) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePublicKey(fos, comment);
        fos.close();
    }

    public void writeSECSHPublicKey(OutputStream out, String comment) {
        byte[] pubblob = this.getPublicKeyBlob();
        byte[] pub = Util.toBase64(pubblob, 0, pubblob.length, true);
        try {
            int len;
            out.write(Util.str2byte("---- BEGIN SSH2 PUBLIC KEY ----"));
            out.write(cr);
            out.write(Util.str2byte("Comment: \"" + comment + "\""));
            out.write(cr);
            for (int index = 0; index < pub.length; index += len) {
                len = 70;
                if (pub.length - index < len) {
                    len = pub.length - index;
                }
                out.write(pub, index, len);
                out.write(cr);
            }
            out.write(Util.str2byte("---- END SSH2 PUBLIC KEY ----"));
            out.write(cr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeSECSHPublicKey(String name, String comment) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writeSECSHPublicKey(fos, comment);
        fos.close();
    }

    public void writePrivateKey(String name) throws FileNotFoundException, IOException {
        this.writePrivateKey(name, null);
    }

    public void writePrivateKey(String name, byte[] passphrase) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePrivateKey(fos, passphrase);
        fos.close();
    }

    public String getFingerPrint() {
        byte[] kblob;
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        if ((kblob = this.getPublicKeyBlob()) == null) {
            return null;
        }
        return Util.getFingerPrint(this.hash, kblob, false, true);
    }

    private byte[] encrypt(byte[] plain, byte[][] _iv, byte[] passphrase) {
        if (passphrase == null) {
            return plain;
        }
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        _iv[0] = new byte[this.cipher.getIVSize()];
        byte[] iv = _iv[0];
        if (this.random == null) {
            this.random = this.genRandom();
        }
        this.random.fill(iv, 0, iv.length);
        byte[] key = this.genKey(passphrase, iv);
        byte[] encoded = plain;
        int bsize = this.cipher.getIVSize();
        byte[] foo = new byte[(encoded.length / bsize + 1) * bsize];
        System.arraycopy(encoded, 0, foo, 0, encoded.length);
        int padding = bsize - encoded.length % bsize;
        for (int i2 = foo.length - 1; foo.length - padding <= i2; --i2) {
            foo[i2] = (byte)padding;
        }
        encoded = foo;
        try {
            this.cipher.init(0, key, iv);
            this.cipher.update(encoded, 0, encoded.length, encoded, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.bzero(key);
        return encoded;
    }

    abstract boolean parse(byte[] var1);

    private byte[] decrypt(byte[] data, byte[] passphrase, byte[] iv) {
        try {
            byte[] key = this.genKey(passphrase, iv);
            this.cipher.init(1, key, iv);
            Util.bzero(key);
            byte[] plain = new byte[data.length];
            this.cipher.update(data, 0, data.length, plain, 0);
            return plain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    int writeSEQUENCE(byte[] buf, int index, int len) {
        buf[index++] = 48;
        index = this.writeLength(buf, index, len);
        return index;
    }

    int writeINTEGER(byte[] buf, int index, byte[] data) {
        buf[index++] = 2;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    int writeOCTETSTRING(byte[] buf, int index, byte[] data) {
        buf[index++] = 4;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    int writeDATA(byte[] buf, byte n, int index, byte[] data) {
        buf[index++] = n;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    int countLength(int len) {
        int i2 = 1;
        if (len <= 127) {
            return i2;
        }
        while (len > 0) {
            len >>>= 8;
            ++i2;
        }
        return i2;
    }

    int writeLength(byte[] data, int index, int len) {
        int i2 = this.countLength(len) - 1;
        if (i2 == 0) {
            data[index++] = (byte)len;
            return index;
        }
        data[index++] = (byte)(0x80 | i2);
        int j2 = index + i2;
        while (i2 > 0) {
            data[index + i2 - 1] = (byte)(len & 0xFF);
            len >>>= 8;
            --i2;
        }
        return j2;
    }

    private Random genRandom() {
        if (this.random == null) {
            try {
                Class<?> c2 = Class.forName(JSch.getConfig("random"));
                this.random = (Random)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                System.err.println("connect: random " + e2);
            }
        }
        return this.random;
    }

    private HASH genHash() {
        try {
            Class<?> c2 = Class.forName(JSch.getConfig("md5"));
            this.hash = (HASH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.hash.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hash;
    }

    private Cipher genCipher() {
        try {
            Class<?> c2 = Class.forName(JSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cipher;
    }

    synchronized byte[] genKey(byte[] passphrase, byte[] iv) {
        if (this.cipher == null) {
            this.cipher = this.genCipher();
        }
        if (this.hash == null) {
            this.hash = this.genHash();
        }
        byte[] key = new byte[this.cipher.getBlockSize()];
        int hsize = this.hash.getBlockSize();
        byte[] hn = new byte[key.length / hsize * hsize + (key.length % hsize == 0 ? 0 : hsize)];
        try {
            byte[] tmp = null;
            if (this.vendor == 0) {
                int index = 0;
                while (index + hsize <= hn.length) {
                    if (tmp != null) {
                        this.hash.update(tmp, 0, tmp.length);
                    }
                    this.hash.update(passphrase, 0, passphrase.length);
                    this.hash.update(iv, 0, iv.length > 8 ? 8 : iv.length);
                    tmp = this.hash.digest();
                    System.arraycopy(tmp, 0, hn, index, tmp.length);
                    index += tmp.length;
                }
                System.arraycopy(hn, 0, key, 0, key.length);
            } else if (this.vendor == 1) {
                int index = 0;
                while (index + hsize <= hn.length) {
                    if (tmp != null) {
                        this.hash.update(tmp, 0, tmp.length);
                    }
                    this.hash.update(passphrase, 0, passphrase.length);
                    tmp = this.hash.digest();
                    System.arraycopy(tmp, 0, hn, index, tmp.length);
                    index += tmp.length;
                }
                System.arraycopy(hn, 0, key, 0, key.length);
            } else if (this.vendor == 2) {
                Class<?> c2 = Class.forName(JSch.getConfig("sha-1"));
                HASH sha1 = (HASH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tmp = new byte[4];
                key = new byte[40];
                for (int i2 = 0; i2 < 2; ++i2) {
                    sha1.init();
                    tmp[3] = (byte)i2;
                    sha1.update(tmp, 0, tmp.length);
                    sha1.update(passphrase, 0, passphrase.length);
                    System.arraycopy(sha1.digest(), 0, key, i2 * 20, 20);
                }
            }
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        return key;
    }

    @Deprecated
    public void setPassphrase(String passphrase) {
        if (passphrase == null || passphrase.length() == 0) {
            this.setPassphrase((byte[])null);
        } else {
            this.setPassphrase(Util.str2byte(passphrase));
        }
    }

    @Deprecated
    public void setPassphrase(byte[] passphrase) {
        if (passphrase != null && passphrase.length == 0) {
            passphrase = null;
        }
        this.passphrase = passphrase;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean decrypt(String _passphrase) {
        if (_passphrase == null || _passphrase.length() == 0) {
            return !this.encrypted;
        }
        return this.decrypt(Util.str2byte(_passphrase));
    }

    public boolean decrypt(byte[] _passphrase) {
        if (!this.encrypted) {
            return true;
        }
        if (_passphrase == null) {
            return !this.encrypted;
        }
        byte[] bar = new byte[_passphrase.length];
        System.arraycopy(_passphrase, 0, bar, 0, bar.length);
        _passphrase = bar;
        byte[] foo = this.decrypt(this.data, _passphrase, this.iv);
        Util.bzero(_passphrase);
        if (this.parse(foo)) {
            this.encrypted = false;
        }
        return !this.encrypted;
    }

    public static KeyPair load(JSch jsch, String prvkey) throws JSchException {
        String pubkey = prvkey + ".pub";
        if (!new File(pubkey).exists()) {
            pubkey = null;
        }
        return KeyPair.load(jsch, prvkey, pubkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair load(JSch jsch, String prvfile, String pubfile) throws JSchException {
        byte[] pubkey;
        byte[] prvkey;
        block8: {
            prvkey = null;
            pubkey = null;
            try {
                prvkey = Util.fromFile(prvfile);
            }
            catch (IOException e2) {
                throw new JSchException(e2.toString(), e2);
            }
            String _pubfile = pubfile;
            if (pubfile == null) {
                _pubfile = prvfile + ".pub";
            }
            try {
                pubkey = Util.fromFile(_pubfile);
            }
            catch (IOException e3) {
                if (pubfile == null) break block8;
                throw new JSchException(e3.toString(), e3);
            }
        }
        try {
            KeyPair keyPair = KeyPair.load(jsch, prvkey, pubkey);
            return keyPair;
        }
        finally {
            Util.bzero(prvkey);
        }
    }

    public static KeyPair load(JSch jsch, byte[] prvkey, byte[] pubkey) throws JSchException {
        byte[] kdfOptions;
        String kdfName;
        Cipher cipher;
        String publicKeyComment;
        int vendor;
        int type;
        byte[] publickeyblob;
        byte[] data;
        boolean encrypted;
        byte[] iv;
        block109: {
            iv = new byte[8];
            encrypted = true;
            data = null;
            publickeyblob = null;
            type = 0;
            vendor = 0;
            publicKeyComment = "";
            cipher = null;
            kdfName = null;
            kdfOptions = null;
            if (pubkey == null && prvkey != null && prvkey.length > 11 && prvkey[0] == 0 && prvkey[1] == 0 && prvkey[2] == 0 && (prvkey[3] == 7 || prvkey[3] == 19)) {
                Buffer buf = new Buffer(prvkey);
                buf.skip(prvkey.length);
                String _type = Util.byte2str(buf.getString());
                buf.rewind();
                KeyPair kpair = null;
                if (_type.equals("ssh-rsa")) {
                    kpair = KeyPairRSA.fromSSHAgent(jsch, buf);
                } else if (_type.equals("ssh-dss")) {
                    kpair = KeyPairDSA.fromSSHAgent(jsch, buf);
                } else if (_type.equals("ecdsa-sha2-nistp256") || _type.equals("ecdsa-sha2-nistp384") || _type.equals("ecdsa-sha2-nistp521")) {
                    kpair = KeyPairECDSA.fromSSHAgent(jsch, buf);
                } else if (_type.equals("ssh-ed25519")) {
                    kpair = KeyPairEd25519.fromSSHAgent(jsch, buf);
                } else if (_type.equals("ssh-ed448")) {
                    kpair = KeyPairEd448.fromSSHAgent(jsch, buf);
                } else {
                    throw new JSchException("privatekey: invalid key " + Util.byte2str(prvkey, 4, 7));
                }
                return kpair;
            }
            try {
                int i2;
                KeyPair ppk;
                byte[] buf = prvkey;
                if (buf != null && (ppk = KeyPair.loadPPK(jsch, buf)) != null) {
                    return ppk;
                }
                int len = buf != null ? buf.length : 0;
                for (i2 = 0; i2 < len && (buf[i2] != 45 || i2 + 4 >= len || buf[i2 + 1] != 45 || buf[i2 + 2] != 45 || buf[i2 + 3] != 45 || buf[i2 + 4] != 45); ++i2) {
                }
                while (i2 < len) {
                    if (buf[i2] == 66 && i2 + 3 < len && buf[i2 + 1] == 69 && buf[i2 + 2] == 71 && buf[i2 + 3] == 73) {
                        if ((i2 += 6) + 2 >= len) {
                            throw new JSchException("invalid privatekey");
                        }
                        if (buf[i2] == 68 && buf[i2 + 1] == 83 && buf[i2 + 2] == 65) {
                            type = 1;
                        } else if (buf[i2] == 82 && buf[i2 + 1] == 83 && buf[i2 + 2] == 65) {
                            type = 2;
                        } else if (buf[i2] == 69 && buf[i2 + 1] == 67) {
                            type = 3;
                        } else if (buf[i2] == 83 && buf[i2 + 1] == 83 && buf[i2 + 2] == 72) {
                            type = 4;
                            vendor = 1;
                        } else if (i2 + 6 < len && buf[i2] == 80 && buf[i2 + 1] == 82 && buf[i2 + 2] == 73 && buf[i2 + 3] == 86 && buf[i2 + 4] == 65 && buf[i2 + 5] == 84 && buf[i2 + 6] == 69) {
                            type = 4;
                            vendor = 3;
                            encrypted = false;
                            i2 += 3;
                        } else if (i2 + 8 < len && buf[i2] == 69 && buf[i2 + 1] == 78 && buf[i2 + 2] == 67 && buf[i2 + 3] == 82 && buf[i2 + 4] == 89 && buf[i2 + 5] == 80 && buf[i2 + 6] == 84 && buf[i2 + 7] == 69 && buf[i2 + 8] == 68) {
                            type = 4;
                            vendor = 3;
                            i2 += 5;
                        } else if (KeyPair.isOpenSSHPrivateKey(buf, i2, len)) {
                            type = 4;
                            vendor = 4;
                        } else {
                            throw new JSchException("invalid privatekey");
                        }
                        i2 += 3;
                        continue;
                    }
                    if (buf[i2] == 65 && i2 + 7 < len && buf[i2 + 1] == 69 && buf[i2 + 2] == 83 && buf[i2 + 3] == 45 && buf[i2 + 4] == 50 && buf[i2 + 5] == 53 && buf[i2 + 6] == 54 && buf[i2 + 7] == 45) {
                        i2 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                            Class<?> c2 = Class.forName(JSch.getConfig("aes256-cbc"));
                            cipher = (Cipher)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            iv = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes256-cbc is not available");
                    }
                    if (buf[i2] == 65 && i2 + 7 < len && buf[i2 + 1] == 69 && buf[i2 + 2] == 83 && buf[i2 + 3] == 45 && buf[i2 + 4] == 49 && buf[i2 + 5] == 57 && buf[i2 + 6] == 50 && buf[i2 + 7] == 45) {
                        i2 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes192-cbc"))) {
                            Class<?> c3 = Class.forName(JSch.getConfig("aes192-cbc"));
                            cipher = (Cipher)c3.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            iv = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes192-cbc is not available");
                    }
                    if (buf[i2] == 65 && i2 + 7 < len && buf[i2 + 1] == 69 && buf[i2 + 2] == 83 && buf[i2 + 3] == 45 && buf[i2 + 4] == 49 && buf[i2 + 5] == 50 && buf[i2 + 6] == 56 && buf[i2 + 7] == 45) {
                        i2 += 8;
                        if (Session.checkCipher(JSch.getConfig("aes128-cbc"))) {
                            Class<?> c4 = Class.forName(JSch.getConfig("aes128-cbc"));
                            cipher = (Cipher)c4.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            iv = new byte[cipher.getIVSize()];
                            continue;
                        }
                        throw new JSchException("privatekey: aes128-cbc is not available");
                    }
                    if (buf[i2] == 67 && i2 + 3 < len && buf[i2 + 1] == 66 && buf[i2 + 2] == 67 && buf[i2 + 3] == 44) {
                        i2 += 4;
                        for (int ii = 0; ii < iv.length; ++ii) {
                            iv[ii] = (byte)((KeyPair.a2b(buf[i2++]) << 4 & 0xF0) + (KeyPair.a2b(buf[i2++]) & 0xF));
                        }
                        continue;
                    }
                    if (buf[i2] == 13 && i2 + 1 < buf.length && buf[i2 + 1] == 10) {
                        ++i2;
                        continue;
                    }
                    if (buf[i2] == 10 && i2 + 1 < buf.length) {
                        if (buf[i2 + 1] == 10) {
                            i2 += 2;
                            break;
                        }
                        if (buf[i2 + 1] == 13 && i2 + 2 < buf.length && buf[i2 + 2] == 10) {
                            i2 += 3;
                            break;
                        }
                        boolean inheader = false;
                        for (int j2 = i2 + 1; j2 < buf.length && buf[j2] != 10; ++j2) {
                            if (buf[j2] != 58) continue;
                            inheader = true;
                            break;
                        }
                        if (!inheader) {
                            ++i2;
                            if (vendor == 3) break;
                            encrypted = false;
                            break;
                        }
                    }
                    ++i2;
                }
                if (buf != null) {
                    if (type == 0) {
                        throw new JSchException("invalid privatekey");
                    }
                    int start = i2;
                    while (i2 < len && buf[i2] != 45) {
                        ++i2;
                    }
                    if (len - i2 == 0 || i2 - start == 0) {
                        throw new JSchException("invalid privatekey");
                    }
                    byte[] tmp = new byte[i2 - start];
                    System.arraycopy(buf, start, tmp, 0, tmp.length);
                    byte[] _buf = tmp;
                    start = 0;
                    i2 = 0;
                    int _len = _buf.length;
                    while (i2 < _len) {
                        if (_buf[i2] == 10) {
                            boolean xd = _buf[i2 - 1] == 13;
                            System.arraycopy(_buf, i2 + 1, _buf, i2 - (xd ? 1 : 0), _len - (i2 + 1));
                            if (xd) {
                                --_len;
                            }
                            --_len;
                            continue;
                        }
                        if (_buf[i2] == 45) break;
                        ++i2;
                    }
                    if (i2 - start > 0) {
                        data = Util.fromBase64(_buf, start, i2 - start);
                    }
                    Util.bzero(_buf);
                }
                if (data != null && data.length > 4 && data[0] == 63 && data[1] == 111 && data[2] == -7 && data[3] == -21) {
                    Buffer _buf = new Buffer(data);
                    _buf.getInt();
                    _buf.getInt();
                    byte[] _type = _buf.getString();
                    String _cipher = Util.byte2str(_buf.getString());
                    if (_cipher.equals("3des-cbc")) {
                        _buf.getInt();
                        byte[] foo = new byte[data.length - _buf.getOffSet()];
                        _buf.getByte(foo);
                        data = foo;
                        encrypted = true;
                        throw new JSchException("unknown privatekey format");
                    }
                    if (_cipher.equals("none")) {
                        _buf.getInt();
                        _buf.getInt();
                        encrypted = false;
                        byte[] foo = new byte[data.length - _buf.getOffSet()];
                        _buf.getByte(foo);
                        data = foo;
                    }
                } else if (data != null && Util.array_equals(AUTH_MAGIC, Arrays.copyOfRange(data, 0, AUTH_MAGIC.length))) {
                    vendor = 4;
                    Buffer buffer = new Buffer(data);
                    byte[] magic = new byte[AUTH_MAGIC.length];
                    buffer.getByte(magic);
                    String cipherName = Util.byte2str(buffer.getString());
                    kdfName = Util.byte2str(buffer.getString());
                    kdfOptions = buffer.getString();
                    int nrKeys = buffer.getInt();
                    if (nrKeys != 1) {
                        throw new IOException("We don't support having more than 1 key in the file (yet).");
                    }
                    pubkey = buffer.getString();
                    if ("none".equals(cipherName)) {
                        encrypted = false;
                        data = buffer.getString();
                        type = KeyPair.readOpenSSHKeyv1(data);
                    } else if (Session.checkCipher(JSch.getConfig(cipherName))) {
                        encrypted = true;
                        Class<?> c5 = Class.forName(JSch.getConfig(cipherName));
                        cipher = (Cipher)c5.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        data = buffer.getString();
                        type = -1;
                    } else {
                        throw new JSchException("cipher " + cipherName + " is not available");
                    }
                }
                if (pubkey == null) break block109;
                try {
                    buf = pubkey;
                    len = buf.length;
                    if (buf.length > 4 && buf[0] == 45 && buf[1] == 45 && buf[2] == 45 && buf[3] == 45) {
                        boolean valid = true;
                        i2 = 0;
                        while (buf.length > ++i2 && buf[i2] != 10) {
                        }
                        if (buf.length <= i2) {
                            valid = false;
                        }
                        while (valid) {
                            if (buf[i2] == 10) {
                                boolean inheader = false;
                                for (int j3 = i2 + 1; j3 < buf.length && buf[j3] != 10; ++j3) {
                                    if (buf[j3] != 58) continue;
                                    inheader = true;
                                    break;
                                }
                                if (!inheader) {
                                    ++i2;
                                    break;
                                }
                            }
                            ++i2;
                        }
                        if (buf.length <= i2) {
                            valid = false;
                        }
                        int start = i2;
                        while (valid && i2 < len) {
                            if (buf[i2] == 10) {
                                System.arraycopy(buf, i2 + 1, buf, i2, len - i2 - 1);
                                --len;
                                continue;
                            }
                            if (buf[i2] == 45) break;
                            ++i2;
                        }
                        if (valid) {
                            publickeyblob = Util.fromBase64(buf, start, i2 - start);
                            if (prvkey == null || type == 4) {
                                if (publickeyblob[8] == 100) {
                                    type = 1;
                                } else if (publickeyblob[8] == 114) {
                                    type = 2;
                                }
                            }
                        }
                    } else if (buf[0] == 115 && buf[1] == 115 && buf[2] == 104 && buf[3] == 45) {
                        if (prvkey == null && buf.length > 7) {
                            if (buf[4] == 100) {
                                type = 1;
                            } else if (buf[4] == 114) {
                                type = 2;
                            } else if (buf[4] == 101 && buf[6] == 50) {
                                type = 5;
                            } else if (buf[4] == 101 && buf[6] == 52) {
                                type = 6;
                            }
                        }
                        for (i2 = 0; i2 < len && buf[i2] != 32; ++i2) {
                        }
                        if (++i2 < len) {
                            int start = i2;
                            while (i2 < len && buf[i2] != 32) {
                                ++i2;
                            }
                            publickeyblob = Util.fromBase64(buf, start, i2 - start);
                        }
                        if (i2++ < len) {
                            int start = i2;
                            while (i2 < len && buf[i2] != 10) {
                                ++i2;
                            }
                            if (i2 > 0 && buf[i2 - 1] == 13) {
                                --i2;
                            }
                            if (start < i2) {
                                publicKeyComment = Util.byte2str(buf, start, i2 - start);
                            }
                        }
                    } else if (buf[0] == 101 && buf[1] == 99 && buf[2] == 100 && buf[3] == 115) {
                        if (prvkey == null && buf.length > 7) {
                            type = 3;
                        }
                        for (i2 = 0; i2 < len && buf[i2] != 32; ++i2) {
                        }
                        if (++i2 < len) {
                            int start = i2;
                            while (i2 < len && buf[i2] != 32) {
                                ++i2;
                            }
                            publickeyblob = Util.fromBase64(buf, start, i2 - start);
                        }
                        if (i2++ < len) {
                            int start = i2;
                            while (i2 < len && buf[i2] != 10) {
                                ++i2;
                            }
                            if (i2 > 0 && buf[i2 - 1] == 13) {
                                --i2;
                            }
                            if (start < i2) {
                                publicKeyComment = Util.byte2str(buf, start, i2 - start);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e2) {
                if (e2 instanceof JSchException) {
                    throw (JSchException)e2;
                }
                throw new JSchException(e2.toString(), e2);
            }
        }
        return KeyPair.getKeyPair(jsch, prvkey, pubkey, iv, encrypted, data, publickeyblob, type, vendor, publicKeyComment, cipher, kdfName, kdfOptions);
    }

    static KeyPair getKeyPair(JSch jsch, byte[] prvkey, byte[] pubkey, byte[] iv, boolean encrypted, byte[] data, byte[] publickeyblob, int type, int vendor, String publicKeyComment, Cipher cipher, String kdfName, byte[] kdfOptions) throws JSchException {
        KeyPair kpair = null;
        if (type == 1) {
            kpair = new KeyPairDSA(jsch);
        } else if (type == 2) {
            kpair = new KeyPairRSA(jsch);
        } else if (type == 3) {
            kpair = new KeyPairECDSA(jsch, pubkey);
        } else if (type == 5) {
            kpair = new KeyPairEd25519(jsch, pubkey, prvkey);
        } else if (type == 6) {
            kpair = new KeyPairEd448(jsch, pubkey, prvkey);
        } else if (vendor == 3) {
            kpair = new KeyPairPKCS8(jsch);
        } else if (type == -1) {
            kpair = new KeyPairDeferred(jsch);
        }
        if (kpair != null) {
            kpair.encrypted = encrypted;
            kpair.publickeyblob = publickeyblob;
            kpair.vendor = vendor;
            kpair.publicKeyComment = publicKeyComment;
            kpair.cipher = cipher;
            kpair.kdfName = kdfName;
            kpair.kdfOptions = kdfOptions;
            if (encrypted) {
                kpair.encrypted = true;
                kpair.iv = iv;
                kpair.data = data;
            } else {
                if (kpair.parse(data)) {
                    kpair.encrypted = false;
                    return kpair;
                }
                throw new JSchException("invalid privatekey");
            }
        }
        return kpair;
    }

    static int readOpenSSHKeyv1(byte[] data) throws IOException, JSchException {
        int checkInt2;
        if (data.length % 8 != 0) {
            throw new IOException("The private key section must be a multiple of the block size (8)");
        }
        Buffer prvKEyBuffer = new Buffer(data);
        int checkInt1 = prvKEyBuffer.getInt();
        if (checkInt1 != (checkInt2 = prvKEyBuffer.getInt())) {
            throw new JSchException("openssh v1 key check failed. Wrong passphrase?");
        }
        String keyType = Util.byte2str(prvKEyBuffer.getString());
        if (keyType.equalsIgnoreCase("ssh-rsa")) {
            return 2;
        }
        if (keyType.startsWith("ssh-dss")) {
            return 1;
        }
        if (keyType.startsWith("ecdsa-sha2")) {
            return 3;
        }
        if (keyType.startsWith("ssh-ed25519")) {
            return 5;
        }
        if (keyType.startsWith("ssh-ed448")) {
            return 6;
        }
        throw new JSchException("keytype " + keyType + " not supported as part of openssh v1 format");
    }

    private static boolean isOpenSSHPrivateKey(byte[] buf, int i2, int len) {
        String ident = "OPENSSH PRIVATE KEY-----";
        return i2 + ident.length() < len && ident.equals(Util.byte2str(Arrays.copyOfRange(buf, i2, i2 + ident.length())));
    }

    private static byte a2b(byte c2) {
        if (48 <= c2 && c2 <= 57) {
            return (byte)(c2 - 48);
        }
        return (byte)(c2 - 97 + 10);
    }

    private static byte b2a(byte c2) {
        if (0 <= c2 && c2 <= 9) {
            return (byte)(c2 + 48);
        }
        return (byte)(c2 - 10 + 65);
    }

    public void dispose() {
        Util.bzero(this.passphrase);
    }

    public void finalize() {
        this.dispose();
    }

    static KeyPair loadPPK(JSch jsch, byte[] buf) throws JSchException {
        Buffer _buf;
        byte[] pubkey = null;
        byte[] prvkey = null;
        int lines = 0;
        Buffer buffer = new Buffer(buf);
        Hashtable<String, String> v = new Hashtable<String, String>();
        while (KeyPair.parseHeader(buffer, v)) {
        }
        String typ = v.get("PuTTY-User-Key-File-2");
        if (typ == null) {
            return null;
        }
        lines = Integer.parseInt(v.get("Public-Lines"));
        pubkey = KeyPair.parseLines(buffer, lines);
        while (KeyPair.parseHeader(buffer, v)) {
        }
        lines = Integer.parseInt(v.get("Private-Lines"));
        prvkey = KeyPair.parseLines(buffer, lines);
        while (KeyPair.parseHeader(buffer, v)) {
        }
        prvkey = Util.fromBase64(prvkey, 0, prvkey.length);
        pubkey = Util.fromBase64(pubkey, 0, pubkey.length);
        KeyPair kpair = null;
        if (typ.equals("ssh-rsa")) {
            _buf = new Buffer(pubkey);
            _buf.skip(pubkey.length);
            int len = _buf.getInt();
            _buf.getByte(new byte[len]);
            byte[] pub_array = new byte[_buf.getInt()];
            _buf.getByte(pub_array);
            byte[] n_array = new byte[_buf.getInt()];
            _buf.getByte(n_array);
            kpair = new KeyPairRSA(jsch, n_array, pub_array, null);
        } else if (typ.equals("ssh-dss")) {
            _buf = new Buffer(pubkey);
            _buf.skip(pubkey.length);
            int len = _buf.getInt();
            _buf.getByte(new byte[len]);
            byte[] p_array = new byte[_buf.getInt()];
            _buf.getByte(p_array);
            byte[] q_array = new byte[_buf.getInt()];
            _buf.getByte(q_array);
            byte[] g_array = new byte[_buf.getInt()];
            _buf.getByte(g_array);
            byte[] y_array = new byte[_buf.getInt()];
            _buf.getByte(y_array);
            kpair = new KeyPairDSA(jsch, p_array, q_array, g_array, y_array, null);
        } else {
            return null;
        }
        if (kpair == null) {
            return null;
        }
        kpair.encrypted = !v.get("Encryption").equals("none");
        kpair.vendor = 2;
        kpair.publicKeyComment = v.get("Comment");
        if (kpair.encrypted) {
            if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                try {
                    Class<?> c2 = Class.forName(JSch.getConfig("aes256-cbc"));
                    kpair.cipher = (Cipher)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    kpair.iv = new byte[kpair.cipher.getIVSize()];
                }
                catch (Exception e2) {
                    throw new JSchException("The cipher 'aes256-cbc' is required, but it is not available.");
                }
            } else {
                throw new JSchException("The cipher 'aes256-cbc' is required, but it is not available.");
            }
            kpair.data = prvkey;
        } else {
            kpair.data = prvkey;
            kpair.parse(prvkey);
        }
        return kpair;
    }

    private static byte[] parseLines(Buffer buffer, int lines) {
        byte[] buf = buffer.buffer;
        int index = buffer.index;
        byte[] data = null;
        int i2 = index;
        while (lines-- > 0) {
            while (buf.length > i2) {
                if (buf[i2++] != 13) continue;
                if (data == null) {
                    data = new byte[i2 - index - 1];
                    System.arraycopy(buf, index, data, 0, i2 - index - 1);
                    break;
                }
                byte[] tmp = new byte[data.length + i2 - index - 1];
                System.arraycopy(data, 0, tmp, 0, data.length);
                System.arraycopy(buf, index, tmp, data.length, i2 - index - 1);
                for (int j2 = 0; j2 < data.length; ++j2) {
                    data[j2] = 0;
                }
                data = tmp;
                break;
            }
            if (buf[i2] == 10) {
                // empty if block
            }
            index = ++i2;
        }
        if (data != null) {
            buffer.index = index;
        }
        return data;
    }

    private static boolean parseHeader(Buffer buffer, Hashtable<String, String> v) {
        int i2;
        byte[] buf = buffer.buffer;
        int index = buffer.index;
        String key = null;
        String value = null;
        for (i2 = index; i2 < buf.length && buf[i2] != 13; ++i2) {
            if (buf[i2] != 58) continue;
            key = Util.byte2str(buf, index, i2 - index);
            if (++i2 < buf.length && buf[i2] == 32) {
                ++i2;
            }
            index = i2;
            break;
        }
        if (key == null) {
            return false;
        }
        for (i2 = index; i2 < buf.length; ++i2) {
            if (buf[i2] != 13) continue;
            value = Util.byte2str(buf, index, i2 - index);
            if (++i2 < buf.length && buf[i2] == 10) {
                ++i2;
            }
            index = i2;
            break;
        }
        if (value != null) {
            v.put(key, value);
            buffer.index = index;
        }
        return key != null && value != null;
    }

    void copy(KeyPair kpair) {
        this.publickeyblob = kpair.publickeyblob;
        this.vendor = kpair.vendor;
        this.publicKeyComment = kpair.publicKeyComment;
        this.cipher = kpair.cipher;
    }

    class ASN1 {
        byte[] buf;
        int start;
        int length;

        ASN1(byte[] buf) throws ASN1Exception {
            this(buf, 0, buf.length);
        }

        ASN1(byte[] buf, int start, int length) throws ASN1Exception {
            this.buf = buf;
            this.start = start;
            this.length = length;
            if (start + length > buf.length) {
                throw new ASN1Exception();
            }
        }

        int getType() {
            return this.buf[this.start] & 0xFF;
        }

        boolean isSEQUENCE() {
            return this.getType() == 48;
        }

        boolean isINTEGER() {
            return this.getType() == 2;
        }

        boolean isOBJECT() {
            return this.getType() == 6;
        }

        boolean isOCTETSTRING() {
            return this.getType() == 4;
        }

        private int getLength(int[] indexp) {
            int length;
            int index = indexp[0];
            if (((length = this.buf[index++] & 0xFF) & 0x80) != 0) {
                int foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (this.buf[index++] & 0xFF);
                }
            }
            indexp[0] = index;
            return length;
        }

        byte[] getContent() {
            int[] indexp = new int[]{this.start + 1};
            int length = this.getLength(indexp);
            int index = indexp[0];
            byte[] tmp = new byte[length];
            System.arraycopy(this.buf, index, tmp, 0, tmp.length);
            return tmp;
        }

        ASN1[] getContents() throws ASN1Exception {
            int l2;
            byte typ = this.buf[this.start];
            int[] indexp = new int[]{this.start + 1};
            if (typ == 5) {
                return new ASN1[0];
            }
            int index = indexp[0];
            Vector<ASN1> values = new Vector<ASN1>();
            for (int length = this.getLength(indexp); length > 0; length -= l2) {
                --length;
                int tmp = ++index;
                indexp[0] = index;
                l2 = this.getLength(indexp);
                index = indexp[0];
                length -= index - tmp;
                values.addElement(new ASN1(this.buf, tmp - 1, 1 + (index - tmp) + l2));
                index += l2;
            }
            ASN1[] result = new ASN1[values.size()];
            for (int i2 = 0; i2 < values.size(); ++i2) {
                result[i2] = (ASN1)values.elementAt(i2);
            }
            return result;
        }
    }

    static class ASN1Exception
    extends Exception {
        private static final long serialVersionUID = -1L;

        ASN1Exception() {
        }
    }
}

