#!/bin/sh
# JTS3ServerMod Linux start script
# Created by Stefan "Stefan1200" Martens
# The author of this script is not responsible for any damage or data loss!

JAVA_COMMANDLINE_PARAMETERS=""           # You can add java arguments here, like the -mx30M argument!
JTS3SERVERMOD_COMMANDLINE_PARAMETERS=""  # You can add JTS3ServerMod arguments here, like the -config and -log argument!
BINARYPATH="$(pwd)"                      # This have to point to the JTS3ServerMod directory!

# Don't change the lines below, if you are not a sh script expert!
cd "${BINARYPATH}"
BINARYNAME="JTS3ServerMod.jar"
ROOTUID="0"

installJava() {
	if which zypper >/dev/null 2>&1 ; then
		if ! zypper info java-1_8_0-openjdk-headless | grep "package 'java-1_8_0-openjdk-headless' not found." >/dev/null 2>&1 ; then
			echo "Installing package java-1.8.0-openjdk-headless, please wait some minutes..."
			zypper --non-interactive --quiet install java-1_8_0-openjdk-headless
		elif ! zypper info java-1_7_0-openjdk-headless | grep "package 'java-1_7_0-openjdk-headless' not found." >/dev/null 2>&1 ; then
			echo "Installing package java-1.7.0-openjdk-headless, please wait some minutes..."
			zypper --non-interactive --quiet install java-1_7_0-openjdk-headless
		fi
	elif which dnf >/dev/null 2>&1 ; then
		if dnf info java-1.8.0-openjdk-headless >/dev/null 2>&1 ; then
			echo "Installing package java-1.8.0-openjdk-headless, please wait some minutes..."
			dnf -y -q install java-1.8.0-openjdk-headless
		elif dnf info java-1.7.0-openjdk-headless >/dev/null 2>&1 ; then
			echo "Installing package java-1.7.0-openjdk-headless, please wait some minutes..."
			dnf -y -q install java-1.7.0-openjdk-headless
		fi
	elif which yum >/dev/null 2>&1 ; then
		if yum info java-1.8.0-openjdk-headless >/dev/null 2>&1 ; then
			echo "Installing package java-1.8.0-openjdk-headless, please wait some minutes..."
			yum -y -q install java-1.8.0-openjdk-headless
		elif yum info java-1.7.0-openjdk-headless >/dev/null 2>&1 ; then
			echo "Installing package java-1.7.0-openjdk-headless, please wait some minutes..."
			yum -y -q install java-1.7.0-openjdk-headless
		fi
	elif which apt-get >/dev/null 2>&1 ; then
		if apt-cache show openjdk-8-jre-headless >/dev/null 2>&1 ; then
			echo "Installing package openjdk-8-jre-headless, please wait some minutes..."
			apt-get -qq install openjdk-8-jre-headless > /dev/null
		elif apt-cache show openjdk-7-jre-headless >/dev/null 2>&1 ; then
			echo "Installing package openjdk-7-jre-headless, please wait some minutes..."
			apt-get -qq install openjdk-7-jre-headless > /dev/null
		fi
	fi
	
	if which java >/dev/null 2>&1 ; then
		echo "Java was successfully installed:"
		java -version
	else
		echo "Unable to install the Java runtime environment!"
		echo "Please read the system requirements of the JTS3ServerMod in the readme.txt file for a manual installation of the Java runtime environment."
		exit 6
	fi
}

case "$1" in
	java)
		if which java >/dev/null 2>&1 ; then
			echo "Java is already installed:"
			java -version
		else
			if [ "$(id -u)" -ne "$ROOTUID" ] ; then
				echo "Start this script as root to start the automatic installation of the Java runtime environment."
				echo "You can also read the system requirements of the JTS3ServerMod in the readme.txt file for a manual installation of the Java runtime environment."
				exit 6
			else
				read -p "Do you wish to install the Java runtime environment? (y/n) " yn
				case $yn in
					[Yy]* ) installJava; break;;
					* ) echo "Aborted!"; exit 6;;
				esac
			fi
		fi
	;;
	start)
		if ! which java >/dev/null 2>&1 ; then
			echo "The JTS3ServerMod needs the Java runtime environment installed to run!"
			echo "Start this script with the java argument as root to start the automatic installation of the Java runtime environment:"
			echo "$0 java"
			echo "You can also read the system requirements of the JTS3ServerMod in the readme.txt file for a manual installation of the Java runtime environment."
			exit 6
		fi
		if [ "$(id -u)" -eq "$ROOTUID" ] ; then
			echo "For security reasons it is prefered not to run the JTS3ServerMod as root!"
		fi
		if [ -e jts3servermod.pid ]; then
			if ( kill -0 $(cat jts3servermod.pid) 2> /dev/null ); then
				echo "The JTS3ServerMod is already running, try restart or stop!"
				exit 1
			else
				echo "jts3servermod.pid found, but no JTS3ServerMod running. Possibly your previously started JTS3ServerMod crashed!"
				echo "Please view the logfile for details."
				rm -f jts3servermod.pid
			fi
		fi
		echo "Starting the JTS3ServerMod..."
		if [ -e "$BINARYNAME" ]; then
			java ${JAVA_COMMANDLINE_PARAMETERS} -jar ${BINARYNAME} ${JTS3SERVERMOD_COMMANDLINE_PARAMETERS} > /dev/null &
			PID=$!
			ps -p ${PID} > /dev/null 2>&1
			if [ "$?" -ne "0" ]; then
				echo "JTS3ServerMod could not start!"
			else
				echo $PID > jts3servermod.pid
				echo "JTS3ServerMod started, for details please view the log file!"
			fi
		else
			echo "Could not find the file $BINARYNAME, aborting!"
			exit 5
		fi
	;;
	stop)
		if [ -e jts3servermod.pid ]; then
			echo -n "Stopping the JTS3ServerMod.."
			if ( kill -TERM $(cat jts3servermod.pid) 2> /dev/null ); then
				c=1
				while [ "$c" -le 120 ]; do
					if ( kill -0 $(cat jts3servermod.pid) 2> /dev/null ); then
						echo -n "."
						sleep 1
					else
						break
					fi
					c=$(($c+1)) 
				done
			fi
			if ( kill -0 $(cat jts3servermod.pid) 2> /dev/null ); then
				echo "JTS3ServerMod is not shutting down cleanly - killing!"
				kill -KILL $(cat jts3servermod.pid)
			else
				echo "done"
			fi
			rm -f jts3servermod.pid
		else
			echo "No JTS3ServerMod running (jts3servermod.pid is missing)!"
			exit 7
		fi
	;;
	restart)
		$0 stop && $0 start || exit 1
	;;
	status)
		if [ -e jts3servermod.pid ]; then
			if ( kill -0 $(cat jts3servermod.pid) 2> /dev/null ); then
				echo "JTS3ServerMod is running!"
			else
				echo "JTS3ServerMod seems to have died!"
			fi
		else
			echo "No JTS3ServerMod running (jts3servermod.pid is missing)!"
		fi
	;;
	*)
		echo "Usage: ${0} {start|stop|restart|status|java}"
		exit 2
esac
exit 0

