/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3serverquery;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import de.stefan1200.jts3serverquery.JTS3ServerQuery$1;
import de.stefan1200.jts3serverquery.JTS3ServerQuery$2;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.jts3serverquery.TeamspeakActionListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class JTS3ServerQuery {
    public boolean DEBUG = false;
    public String DEBUG_COMMLOG_PATH = "JTS3ServerQuery-communication.log";
    public String DEBUG_ERRLOG_PATH = "JTS3ServerQuery-error.log";
    public static final int LISTMODE_CLIENTLIST = 1;
    public static final int LISTMODE_CHANNELLIST = 2;
    public static final int LISTMODE_SERVERLIST = 3;
    public static final int LISTMODE_SERVERGROUPLIST = 4;
    public static final int LISTMODE_CLIENTDBLIST = 5;
    public static final int LISTMODE_PERMISSIONLIST = 6;
    public static final int LISTMODE_BANLIST = 7;
    public static final int LISTMODE_COMPLAINLIST = 8;
    public static final int LISTMODE_SERVERGROUPCLIENTLIST = 9;
    public static final int LISTMODE_SERVERGROUPSBYCLIENTID = 10;
    public static final int LISTMODE_CHANNELGROUPLIST = 11;
    public static final int INFOMODE_SERVERINFO = 11;
    public static final int INFOMODE_CHANNELINFO = 12;
    public static final int INFOMODE_CLIENTINFO = 13;
    public static final int INFOMODE_CLIENTDBINFO = 14;
    public static final int PERMLISTMODE_CHANNEL = 21;
    public static final int PERMLISTMODE_SERVERGROUP = 22;
    public static final int PERMLISTMODE_CLIENT = 23;
    public static final int TEXTMESSAGE_TARGET_CLIENT = 1;
    public static final int TEXTMESSAGE_TARGET_CHANNEL = 2;
    public static final int TEXTMESSAGE_TARGET_VIRTUALSERVER = 3;
    public static final int TEXTMESSAGE_TARGET_GLOBAL = 4;
    public static final int EVENT_MODE_TEXTSERVER = 1;
    public static final int EVENT_MODE_TEXTCHANNEL = 2;
    public static final int EVENT_MODE_TEXTPRIVATE = 3;
    public static final int EVENT_MODE_SERVER = 4;
    public static final int EVENT_MODE_CHANNEL = 5;
    private boolean eventNotifyCheckActive = false;
    private boolean sshMode = false;
    private TeamspeakActionListener actionClass = null;
    private int queryCurrentServerPort = -1;
    private int queryCurrentServerID = -1;
    private int queryCurrentClientID = -1;
    private int queryCurrentClientDatabaseID = -1;
    private int queryCurrentChannelID = -1;
    private String queryCurrentClientUniqueID = null;
    private String queryCurrentChannelPassword = null;
    private String queryCurrentClientName = null;
    private Socket socketQuery = null;
    private Session session = null;
    private BufferedReader in = null;
    private PrintStream out = null;
    private PrintStream commLogOut = null;
    private PrintStream errLogOut = null;
    private Timer eventNotifyTimer = null;
    private TimerTask eventNotifyTimerTask = null;
    private String threadName = null;
    private SimpleDateFormat sdfDebug = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String lastActionString = "";

    public JTS3ServerQuery() {
        this.threadName = "";
    }

    public JTS3ServerQuery(String string) {
        this.threadName = String.valueOf(string) + "_";
    }

    private synchronized void writeCommLog(String string) {
        if (!this.DEBUG) {
            return;
        }
        if (this.DEBUG_COMMLOG_PATH == null) {
            return;
        }
        if (string == null) {
            return;
        }
        try {
            if (this.commLogOut == null) {
                this.commLogOut = new PrintStream(this.DEBUG_COMMLOG_PATH, "UTF-8");
            }
            this.commLogOut.println(string);
            this.commLogOut.flush();
            return;
        }
        catch (Exception exception) {
            this.writeErrLog(exception);
            return;
        }
    }

    private void writeErrLog(Exception exception) {
        if (!this.DEBUG) {
            return;
        }
        if (this.DEBUG_ERRLOG_PATH == null) {
            return;
        }
        if (exception == null) {
            return;
        }
        try {
            if (this.errLogOut == null) {
                this.errLogOut = new PrintStream(this.DEBUG_ERRLOG_PATH, "UTF-8");
            }
            this.errLogOut.println(this.sdfDebug.format(new Date(System.currentTimeMillis())));
            exception.printStackTrace(this.errLogOut);
            this.errLogOut.flush();
            return;
        }
        catch (Exception exception2) {
            if (this.DEBUG) {
                exception2.printStackTrace();
            }
            return;
        }
    }

    private void eventNotifyRun() {
        if (this.eventNotifyCheckActive && this.isConnected()) {
            try {
                String string;
                if (this.in.ready() && (string = this.in.readLine()).length() > 0) {
                    this.writeCommLog("< ".concat(String.valueOf(string)));
                    this.handleAction(string);
                    return;
                }
            }
            catch (Exception exception) {
                this.writeErrLog(exception);
            }
        }
    }

    public void changeThreadName(String string) {
        this.threadName = String.valueOf(string) + "_";
    }

    public void setTeamspeakActionListener(TeamspeakActionListener teamspeakActionListener) {
        this.actionClass = teamspeakActionListener;
    }

    public void removeTeamspeakActionListener() {
        if (this.eventNotifyTimerTask != null) {
            this.removeAllEvents();
        }
        this.actionClass = null;
    }

    public void addEventNotify(int n, int n2) {
        if (this.actionClass == null) {
            throw new IllegalStateException("Use setTeamspeakActionListener() first!");
        }
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = null;
        if (n == 4) {
            object = "servernotifyregister event=server";
        }
        if (n == 5) {
            object = "servernotifyregister id=" + Integer.toString(n2) + " event=channel";
        }
        if (n == 1) {
            object = "servernotifyregister event=textserver";
        }
        if (n == 2) {
            object = "servernotifyregister event=textchannel";
        }
        if (n == 3) {
            object = "servernotifyregister event=textprivate";
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid eventMode given!");
        }
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("addEventNotify(" + Integer.toString(n) + ", " + Integer.toString(n2) + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        if (this.eventNotifyTimerTask == null) {
            this.eventNotifyTimerTask = new JTS3ServerQuery$1(this);
            this.eventNotifyTimer.schedule(this.eventNotifyTimerTask, 200L, 200L);
        }
    }

    public void removeAllEvents() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = "servernotifyunregister";
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("removeAllEvents()", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        if (this.eventNotifyTimerTask != null) {
            this.eventNotifyTimerTask.cancel();
            this.eventNotifyTimerTask = null;
        }
    }

    public void connectTS3Query(String string, int n) {
        this.connectTS3Query(string, n, null, -1);
    }

    public void connectTS3Query(String string, int n, String string2, int n2) {
        this.sshMode = false;
        if (this.socketQuery != null) {
            throw new IllegalStateException("Close currently open connection first!");
        }
        try {
            this.socketQuery = string2 != null && n2 > 0 && n2 <= 65535 ? new Socket(string, n, InetAddress.getByName(string2), n2) : new Socket(string, n);
        }
        catch (Exception exception) {
            this.socketQuery = null;
            throw exception;
        }
        if (this.socketQuery.isConnected()) {
            try {
                this.in = new BufferedReader(new InputStreamReader(this.socketQuery.getInputStream(), "UTF-8"));
                this.out = new PrintStream(this.socketQuery.getOutputStream(), true, "UTF-8");
                this.socketQuery.setSoTimeout(5000);
                string = this.in.readLine();
                this.writeCommLog("< ".concat(String.valueOf(string)));
                if (!string.equals("TS3") && !string.equals("TeaSpeak")) {
                    this.closeTS3Connection();
                    throw new IllegalStateException("Server does not respond as TS3 or TeaSpeak server!");
                }
                this.socketQuery.setSoTimeout(500);
                try {
                    while (true) {
                        if ((string = this.in.readLine()) == null) {
                            throw new EOFException("Connection was closed by TS3 server, maybe banned?");
                        }
                        this.writeCommLog("< ".concat(String.valueOf(string)));
                    }
                }
                catch (EOFException eOFException) {
                    this.closeTS3Connection();
                    throw eOFException;
                }
                catch (Exception exception) {
                    this.socketQuery.setSoTimeout(40000);
                }
            }
            catch (Exception exception) {
                this.closeTS3Connection();
                throw exception;
            }
        }
        try {
            this.socketQuery.close();
        }
        catch (Exception exception) {}
        this.socketQuery = null;
        throw new IllegalStateException("Unknown connection error occurred!");
        if (this.eventNotifyTimer != null) {
            this.eventNotifyTimer.cancel();
            this.eventNotifyTimer = null;
        }
        if (this.eventNotifyTimerTask != null) {
            this.eventNotifyTimerTask.cancel();
            this.eventNotifyTimerTask = null;
        }
        this.eventNotifyTimer = new Timer(true);
    }

    public void connectTS3SSHQuery(String object, int n, String string, String string2) {
        this.sshMode = true;
        try {
            JSch jSch = new JSch();
            this.session = jSch.getSession(string, (String)object, n);
            this.session.setPassword(string2);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect(40000);
            object = this.session.openChannel("shell");
            ((ChannelShell)object).setPty(false);
            this.in = new BufferedReader(new InputStreamReader(((Channel)object).getInputStream(), "UTF-8"));
            this.out = new PrintStream(((Channel)object).getOutputStream(), true, "UTF-8");
            ((Channel)object).connect(40000);
            boolean bl = false;
            while (this.in.ready()) {
                String string3 = this.in.readLine();
                if (!bl) {
                    if (string3.equals("TS3") || string3.equals("TeaSpeak")) {
                        bl = true;
                    } else {
                        this.closeTS3Connection();
                        throw new IllegalStateException("Server does not respond as TS3 server!");
                    }
                }
                if (string3 == null) {
                    throw new EOFException("Connection was closed by TS3 server, maybe banned?");
                }
                if (string3.equals("")) continue;
                this.writeCommLog("< ".concat(String.valueOf(string3)));
            }
        }
        catch (Exception exception) {
            this.closeTS3Connection();
            throw exception;
        }
        if (this.eventNotifyTimer != null) {
            this.eventNotifyTimer.cancel();
            this.eventNotifyTimer = null;
        }
        if (this.eventNotifyTimerTask != null) {
            this.eventNotifyTimerTask.cancel();
            this.eventNotifyTimerTask = null;
        }
        this.eventNotifyTimer = new Timer(true);
    }

    public void loginTS3(String string, String object) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        object = this.doInternalCommand("login " + this.encodeTS3String(string) + " " + this.encodeTS3String((String)object));
        if (!((String)((HashMap)object).get("id")).equals("0")) {
            throw new TS3ServerQueryException("loginTS3(" + string + ", hidden)", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        this.updateClientIDChannelID();
    }

    public void setDisplayName(String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("displayName null or shorter than 3 characters!");
        }
        HashMap hashMap = this.doInternalCommand("clientupdate client_nickname=" + this.encodeTS3String(string));
        if (!((String)hashMap.get("id")).equals("0")) {
            throw new TS3ServerQueryException("setDisplayName(" + string + ")", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
        this.queryCurrentClientName = string;
    }

    public void selectVirtualServer(int n) {
        this.selectVirtualServer(n, false, false, null);
    }

    public void selectVirtualServer(int n, boolean bl) {
        this.selectVirtualServer(n, bl, false, null);
    }

    public void selectVirtualServer(int n, boolean bl, boolean bl2) {
        this.selectVirtualServer(n, bl, bl2, null);
    }

    public void selectVirtualServer(int n, boolean bl, boolean bl2, String object) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        object = bl ? "use port=" + Integer.toString(n) + (object != null ? " client_nickname=" + this.encodeTS3String((String)object) : "") : "use sid=" + Integer.toString(n) + (object != null ? " client_nickname=" + this.encodeTS3String((String)object) : "");
        if (bl2) {
            object = String.valueOf(object) + " -virtual";
        }
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("selectVirtualServer(" + Integer.toString(n) + ", " + (bl ? "true" : "false") + ", " + (bl2 ? "true" : "false") + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        this.updateClientIDChannelID();
    }

    private void updateClientIDChannelID() {
        HashMap hashMap = this.doInternalCommand("whoami");
        if (!((String)hashMap.get("id")).equals("0")) {
            throw new TS3ServerQueryException("updateClientIDChannelID()", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
        if (hashMap.get("response") == null) {
            throw new IllegalStateException("No valid server response found!");
        }
        hashMap = this.parseLine((String)hashMap.get("response"));
        this.queryCurrentServerPort = Integer.parseInt((String)hashMap.get("virtualserver_port"));
        this.queryCurrentServerID = Integer.parseInt((String)hashMap.get("virtualserver_id"));
        this.queryCurrentClientID = Integer.parseInt((String)hashMap.get("client_id"));
        this.queryCurrentClientDatabaseID = Integer.parseInt((String)hashMap.get("client_database_id"));
        this.queryCurrentClientUniqueID = (String)hashMap.get("client_unique_identifier");
        this.queryCurrentClientName = (String)hashMap.get("client_nickname");
        this.queryCurrentChannelID = Integer.parseInt((String)hashMap.get("client_channel_id"));
        this.queryCurrentChannelPassword = null;
    }

    public void closeTS3Connection() {
        if (this.eventNotifyTimerTask != null) {
            this.eventNotifyTimerTask.cancel();
            this.eventNotifyTimerTask = null;
            this.eventNotifyTimer.cancel();
            this.eventNotifyTimer = null;
        }
        this.queryCurrentClientID = -1;
        this.queryCurrentServerID = -1;
        this.queryCurrentChannelPassword = null;
        this.lastActionString = "";
        try {
            if (this.out != null) {
                this.out.println("quit");
                this.out.close();
                this.out = null;
                this.writeCommLog("> quit");
            }
        }
        catch (Exception exception) {
            this.writeErrLog(exception);
        }
        if (this.commLogOut != null) {
            this.commLogOut.close();
            this.commLogOut = null;
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            this.writeErrLog(exception);
        }
        try {
            if (this.sshMode) {
                if (this.session != null) {
                    this.session.disconnect();
                    this.session = null;
                    return;
                }
            } else if (this.socketQuery != null) {
                this.socketQuery.close();
                this.socketQuery = null;
                return;
            }
        }
        catch (Exception exception) {
            this.writeErrLog(exception);
        }
    }

    public void deleteChannel(int n, boolean bl) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = "channeldelete cid=" + Integer.toString(n) + " force=" + (bl ? "1" : "0");
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("deleteChannel(" + Integer.toString(n) + ", " + (bl ? "true" : "false") + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        if (this.queryCurrentChannelID == n) {
            this.updateClientIDChannelID();
        }
    }

    public void moveClient(int n, int n2, String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = "clientmove clid=" + Integer.toString(n) + " cid=" + Integer.toString(n2);
        if (string != null && string.length() > 0) {
            object = String.valueOf(object) + " cpw=" + this.encodeTS3String(string);
        }
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("moveClient(" + Integer.toString(n) + ", " + Integer.toString(n2) + ", hidden)", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        if (n == this.queryCurrentClientID) {
            this.queryCurrentChannelID = n2;
            this.queryCurrentChannelPassword = string;
        }
    }

    public void kickClient(int n, boolean bl, String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = "clientkick reasonid=" + (bl ? "4" : "5");
        if (string != null && string.length() > 0) {
            object = String.valueOf(object) + " reasonmsg=" + this.encodeTS3String(string);
        }
        object = String.valueOf(object) + " clid=" + Integer.toString(n);
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("kickClient(" + Integer.toString(n) + ", " + (bl ? "true" : "false") + string + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
    }

    public int getCurrentQueryClientID() {
        return this.queryCurrentClientID;
    }

    public int getCurrentQueryClientDatabaseID() {
        return this.queryCurrentClientDatabaseID;
    }

    public String getCurrentQueryClientUniqueID() {
        return this.queryCurrentClientUniqueID;
    }

    public int getCurrentQueryClientServerID() {
        return this.queryCurrentServerID;
    }

    public int getCurrentQueryClientServerPort() {
        return this.queryCurrentServerPort;
    }

    public int getCurrentQueryClientChannelID() {
        return this.queryCurrentChannelID;
    }

    public String getCurrentQueryClientName() {
        return this.queryCurrentClientName;
    }

    public void sendTextMessage(int n, int n2, String string) {
        this.sendTextMessage(n, n2, string, null);
    }

    public void sendTextMessage(int n, int n2, String string, String string2) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No message given!");
        }
        if (n2 <= 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid targetMode given!");
        }
        HashMap hashMap = null;
        if (n2 == 4) {
            string2 = "gm msg=" + this.encodeTS3String(string);
            hashMap = this.doInternalCommand(string2);
        } else if (n2 == 2) {
            int n3 = -1;
            String string3 = null;
            if (n != this.queryCurrentChannelID) {
                n3 = this.queryCurrentChannelID;
                string3 = this.queryCurrentChannelPassword;
                JTS3ServerQuery jTS3ServerQuery = this;
                jTS3ServerQuery.moveClient(jTS3ServerQuery.queryCurrentClientID, n, string2);
            }
            string2 = "sendtextmessage targetmode=" + Integer.toString(n2) + " msg=" + this.encodeTS3String(string);
            hashMap = this.doInternalCommand(string2);
            if (n3 != -1) {
                JTS3ServerQuery jTS3ServerQuery = this;
                jTS3ServerQuery.moveClient(jTS3ServerQuery.queryCurrentClientID, n3, string3);
            }
        } else if (n2 == 1) {
            string2 = "sendtextmessage targetmode=" + Integer.toString(n2) + " msg=" + this.encodeTS3String(string) + " target=" + Integer.toString(n);
            hashMap = this.doInternalCommand(string2);
        } else if (n2 == 3) {
            int n4 = -1;
            if (n != this.queryCurrentServerID) {
                n4 = this.queryCurrentServerID;
                this.selectVirtualServer(n);
            }
            string2 = "sendtextmessage targetmode=" + Integer.toString(n2) + " msg=" + this.encodeTS3String(string);
            hashMap = this.doInternalCommand(string2);
            if (n4 != -1) {
                this.selectVirtualServer(n4);
            }
        }
        if (!((String)hashMap.get("id")).equals("0")) {
            throw new TS3ServerQueryException("sendTextMessage(" + Integer.toString(n) + ", " + Integer.toString(n2) + ", " + string + ", hidden)", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
    }

    public HashMap doCommand(String string) {
        if (string.startsWith("use ") || string.startsWith("clientmove ") || string.startsWith("channeldelete ")) {
            throw new IllegalArgumentException("This commands are not allowed here. Please use deleteChannel(), moveClient() or selectVirtualServer()!");
        }
        return this.doInternalCommand(string);
    }

    private synchronized HashMap doInternalCommand(String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No command given!");
        }
        this.eventNotifyCheckActive = false;
        this.writeCommLog("> ".concat(String.valueOf(string)));
        this.out.println(string);
        return this.readIncoming();
    }

    public void pokeClient(int n, String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No message given!");
        }
        Object object = "clientpoke clid=" + Integer.toString(n) + " msg=" + this.encodeTS3String(string);
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("pokeClient(" + Integer.toString(n) + ", " + string + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
    }

    public void complainAdd(int n, String string) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No message given!");
        }
        Object object = "complainadd tcldbid=" + Integer.toString(n) + " message=" + this.encodeTS3String(string);
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("complainAdd(" + Integer.toString(n) + ", " + string + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
    }

    public void complainDelete(int n, int n2) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        Object object = "complaindel tcldbid=" + Integer.toString(n) + " fcldbid=" + Integer.toString(n2);
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("complainDelete(" + Integer.toString(n) + ", " + Integer.toString(n2) + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
    }

    public boolean isConnected() {
        if (this.sshMode) {
            if (this.session == null || this.in == null || this.out == null) {
                return false;
            }
            return this.session.isConnected();
        }
        if (this.socketQuery == null || this.in == null || this.out == null) {
            return false;
        }
        return this.socketQuery.isConnected();
    }

    public Vector parseRawData(String object) {
        if (object == null) {
            throw new NullPointerException("Given argument is null!");
        }
        Vector<HashMap> vector = new Vector<HashMap>();
        object = new StringTokenizer((String)object, "|", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            vector.addElement(this.parseLine(((StringTokenizer)object).nextToken()));
        }
        return vector;
    }

    public Vector searchClientDB(String object, boolean bl) {
        if (object == null || ((String)object).length() == 0) {
            throw new IllegalArgumentException("No search string given!");
        }
        Object object2 = "clientdbfind pattern=" + (String)object + (bl ? " -uid" : "");
        if (!((String)((HashMap)(object2 = this.doInternalCommand((String)object2))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("searchClientDB(" + (String)object + ", " + (bl ? "true" : "false") + ")", (String)((HashMap)object2).get("id"), (String)((HashMap)object2).get("msg"), (String)((HashMap)object2).get("extra_msg"), (String)((HashMap)object2).get("failed_permid"));
        }
        if (((HashMap)object2).get("response") == null) {
            throw new IllegalStateException("No valid server response found!");
        }
        object = this.parseRawData((String)((HashMap)object2).get("response"));
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < ((Vector)object).size()) {
            try {
                vector.addElement(Integer.parseInt((String)((HashMap)((Vector)object).elementAt(n)).get("cldbid")));
            }
            catch (Exception exception) {}
            ++n;
        }
        return vector;
    }

    public int getClientDBIDFromUID(String string) {
        if (string == null || string.length() < 20 || string.length() > 50) {
            throw new IllegalArgumentException("Missing or invalid unique ID!");
        }
        HashMap hashMap = this.doInternalCommand("clientgetdbidfromuid cluid=".concat(String.valueOf(string)));
        if (!((String)hashMap.get("id")).equals("0")) {
            throw new TS3ServerQueryException("getClientDBIDFromUID(" + string + ")", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
        if (hashMap.get("response") == null) {
            throw new IllegalStateException("No valid server response found!");
        }
        hashMap = this.parseLine((String)hashMap.get("response"));
        return Integer.parseInt((String)hashMap.get("cldbid"));
    }

    public HashMap getInfo(int n, int n2) {
        Object object = this.getCommand(n, 2);
        if (object == null) {
            throw new IllegalArgumentException("Unknown infoMode!");
        }
        if (n != 11) {
            object = String.valueOf(object) + Integer.toString(n2);
        }
        if (!((String)((HashMap)(object = this.doInternalCommand((String)object))).get("id")).equals("0")) {
            throw new TS3ServerQueryException("getInfo(" + Integer.toString(n) + ", " + Integer.toString(n2) + ")", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
        }
        if (((HashMap)object).get("response") == null) {
            throw new IllegalStateException("No valid server response found!");
        }
        HashMap hashMap = this.parseLine((String)((HashMap)object).get("response"));
        return hashMap;
    }

    public HashMap getPermissionInfo(int n) {
        Cloneable cloneable3 = this.getList(6);
        Cloneable cloneable2 = null;
        for (Cloneable cloneable3 : cloneable3) {
            if (Integer.parseInt((String)((HashMap)cloneable3).get("permid")) != n) continue;
            cloneable2 = cloneable3;
            break;
        }
        return cloneable2;
    }

    public Vector getPermissionList(int n, int n2) {
        String string = this.getCommand(n, 3);
        if (string == null) {
            throw new IllegalArgumentException("Unknown permListMode!");
        }
        string = String.valueOf(string) + Integer.toString(n2);
        return this.getList(string);
    }

    public Vector getLogEntries(int n, boolean bl, boolean bl2, int n2) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("listLimitCount has to be between 1 and 100!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("beginpos must be 0 or higher!");
        }
        String string = "logview lines=" + Integer.toString(n) + " reverse=" + (bl ? "1" : "0") + " instance=" + (bl2 ? "1" : "0") + " begin_pos=" + Integer.toString(n2);
        return this.getList(string);
    }

    public Vector getList(int n) {
        return this.getList(n, null);
    }

    public Vector getList(int n, String object) {
        String string = this.getCommand(n, 1);
        if (string == null) {
            throw new IllegalArgumentException("Unknown listMode!");
        }
        if (object != null && ((String)object).length() > 1) {
            object = new StringTokenizer((String)object, ",", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (!this.checkListArguments(n, string2)) continue;
                string = String.valueOf(string) + " " + string2;
            }
        }
        return this.getList(string);
    }

    private Vector getList(String object) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        HashMap hashMap = this.doInternalCommand((String)object);
        if (!((String)hashMap.get("id")).equals("0")) {
            throw new TS3ServerQueryException("getList(" + (String)object + ")", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
        if (hashMap.get("response") == null) {
            throw new IllegalStateException("No valid server response found!");
        }
        object = this.parseRawData((String)hashMap.get("response"));
        return object;
    }

    private HashMap readIncoming() {
        Object object;
        String string = "";
        new HashMap();
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to TS3 server!");
        }
        while (true) {
            try {
                object = this.in.readLine();
                this.writeCommLog("< ".concat(String.valueOf(object)));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.closeTS3Connection();
                throw new IllegalStateException("Closed TS3 Connection: " + socketTimeoutException.toString(), socketTimeoutException);
            }
            catch (SocketException socketException) {
                this.closeTS3Connection();
                throw new IllegalStateException("Closed TS3 Connection: " + socketException.toString(), socketException);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unknown exception: " + exception.toString(), exception);
            }
            if (object == null) {
                this.closeTS3Connection();
                throw new IllegalStateException("null object, maybe connection to TS3 server interrupted.");
            }
            if (((String)object).startsWith("error ")) break;
            if (((String)object).length() <= 2 || this.handleAction((String)object)) continue;
            if (string.length() != 0) {
                string = String.valueOf(string) + System.getProperty("line.separator", "\n");
            }
            string = String.valueOf(string) + (String)object;
        }
        try {
            object = this.parseLine((String)object);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("null object, maybe connection to TS3 server interrupted.");
        }
        ((HashMap)object).put("response", string);
        this.eventNotifyCheckActive = true;
        return object;
    }

    public String encodeTS3String(String string) {
        string = string.replace("\\", "\\\\");
        string = string.replace(" ", "\\s");
        string = string.replace("/", "\\/");
        string = string.replace("|", "\\p");
        string = string.replace("\b", "\\b");
        string = string.replace("\f", "\\f");
        string = string.replace("\n", "\\n");
        string = string.replace("\r", "\\r");
        string = string.replace("\t", "\\t");
        Character c2 = Character.valueOf('\u0007');
        Character c3 = Character.valueOf('\u000b');
        string = string.replace(c2.toString(), "\\a");
        string = string.replace(c3.toString(), "\\v");
        return string;
    }

    public String decodeTS3String(String string) {
        string = string.replace("\\\\", "\\[$mksave]");
        string = string.replace("\\s", " ");
        string = string.replace("\\/", "/");
        string = string.replace("\\p", "|");
        string = string.replace("\\b", "\b");
        string = string.replace("\\f", "\f");
        string = string.replace("\\n", "\n");
        string = string.replace("\\r", "\r");
        string = string.replace("\\t", "\t");
        Character c2 = Character.valueOf('\u0007');
        Character c3 = Character.valueOf('\u000b');
        string = string.replace("\\a", c2.toString());
        string = string.replace("\\v", c3.toString());
        string = string.replace("\\[$mksave]", "\\");
        return string;
    }

    public HashMap parseLine(String object) {
        if (object == null) {
            throw new NullPointerException("Given argument is null!");
        }
        object = new StringTokenizer((String)object, " ", false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            int n = string.indexOf("=");
            if (n == -1) {
                hashMap.put(string, "");
                continue;
            }
            String string2 = string.substring(0, n);
            hashMap.put(string2, this.decodeTS3String(string.substring(n + 1)));
        }
        return hashMap;
    }

    private boolean checkListArguments(int n, String string) {
        if (n == 2) {
            if (string.equalsIgnoreCase("-topic")) {
                return true;
            }
            if (string.equalsIgnoreCase("-flags")) {
                return true;
            }
            if (string.equalsIgnoreCase("-voice")) {
                return true;
            }
            if (string.equalsIgnoreCase("-limits")) {
                return true;
            }
            if (string.equalsIgnoreCase("-icon")) {
                return true;
            }
            if (string.equalsIgnoreCase("-secondsempty")) {
                return true;
            }
        }
        if (n == 1) {
            if (string.equalsIgnoreCase("-uid")) {
                return true;
            }
            if (string.equalsIgnoreCase("-away")) {
                return true;
            }
            if (string.equalsIgnoreCase("-voice")) {
                return true;
            }
            if (string.equalsIgnoreCase("-times")) {
                return true;
            }
            if (string.equalsIgnoreCase("-groups")) {
                return true;
            }
            if (string.equalsIgnoreCase("-info")) {
                return true;
            }
            if (string.equalsIgnoreCase("-icon")) {
                return true;
            }
            if (string.equalsIgnoreCase("-country")) {
                return true;
            }
            if (string.equalsIgnoreCase("-ip")) {
                return true;
            }
        }
        if (n == 3) {
            if (string.equalsIgnoreCase("-uid")) {
                return true;
            }
            if (string.equalsIgnoreCase("-all")) {
                return true;
            }
            if (string.equalsIgnoreCase("-short")) {
                return true;
            }
            if (string.equalsIgnoreCase("-onlyoffline")) {
                return true;
            }
        }
        if (n == 5) {
            if (string.startsWith("start=") && string.indexOf(" ") == -1) {
                return true;
            }
            if (string.startsWith("duration=") && string.indexOf(" ") == -1) {
                return true;
            }
            if (string.equalsIgnoreCase("-count")) {
                return true;
            }
        }
        if (n == 8 && string.startsWith("tcldbid=") && string.indexOf(" ") == -1) {
            return true;
        }
        if (n == 9) {
            if (string.startsWith("sgid=") && string.indexOf(" ") == -1) {
                return true;
            }
            if (string.equalsIgnoreCase("-names")) {
                return true;
            }
        }
        return n == 10 && string.startsWith("cldbid=") && string.indexOf(" ") == -1;
    }

    private String getCommand(int n, int n2) {
        if (n2 == 1) {
            if (n == 2) {
                return "channellist";
            }
            if (n == 5) {
                return "clientdblist";
            }
            if (n == 1) {
                return "clientlist";
            }
            if (n == 6) {
                return "permissionlist";
            }
            if (n == 4) {
                return "servergrouplist";
            }
            if (n == 3) {
                return "serverlist";
            }
            if (n == 7) {
                return "banlist";
            }
            if (n == 8) {
                return "complainlist";
            }
            if (n == 9) {
                return "servergroupclientlist";
            }
            if (n == 10) {
                return "servergroupsbyclientid";
            }
            if (n == 11) {
                return "channelgrouplist";
            }
        } else if (n2 == 2) {
            if (n == 11) {
                return "serverinfo";
            }
            if (n == 12) {
                return "channelinfo cid=";
            }
            if (n == 13) {
                return "clientinfo clid=";
            }
            if (n == 14) {
                return "clientdbinfo cldbid=";
            }
        } else if (n2 == 3) {
            if (n == 21) {
                return "channelpermlist cid=";
            }
            if (n == 23) {
                return "clientpermlist cldbid=";
            }
            if (n == 22) {
                return "servergrouppermlist sgid=";
            }
        }
        return null;
    }

    private boolean handleAction(String string) {
        if (!string.startsWith("notify")) {
            return false;
        }
        int n = string.indexOf(" ");
        if (n != -1) {
            String string2 = string.substring(0, n);
            HashMap hashMap = this.parseLine(string.substring(n + 1));
            if (string2.equals("notifyclientmoved")) {
                try {
                    if (Integer.parseInt((String)hashMap.get("clid")) == this.getCurrentQueryClientID()) {
                        this.queryCurrentChannelID = Integer.parseInt((String)hashMap.get("ctid"));
                    }
                }
                catch (Exception exception) {
                    this.writeErrLog(exception);
                }
            }
            if (this.actionClass != null) {
                if (string.startsWith("notifyclient")) {
                    if (string.equals(this.lastActionString)) {
                        return true;
                    }
                    this.lastActionString = string;
                }
                Thread thread = new Thread(new JTS3ServerQuery$2(this, string2, hashMap));
                thread.setName(String.valueOf(this.threadName) + "handleAction");
                thread.start();
            }
        }
        return true;
    }

    static /* synthetic */ void access$0(JTS3ServerQuery jTS3ServerQuery) {
        jTS3ServerQuery.eventNotifyRun();
    }

    static /* synthetic */ TeamspeakActionListener access$1(JTS3ServerQuery jTS3ServerQuery) {
        return jTS3ServerQuery.actionClass;
    }

    static /* synthetic */ void access$2(JTS3ServerQuery jTS3ServerQuery, Exception exception) {
        jTS3ServerQuery.writeErrLog(exception);
    }
}

