/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerGroupProtection
implements HandleBotEvents,
HandleClientList,
HandleTS3Events,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private String b;
    private String c;
    private String d;
    private boolean b;
    private boolean c;
    private boolean d;
    private Vector a;
    private Vector b = false;
    private Vector c = false;
    private Vector d = false;
    private Vector e;
    private FunctionExceptionLog a = new Vector();

    public ServerGroupProtection() {
        this.b = new Vector();
        this.c = new Vector();
        this.d = new Vector();
        this.e = new Vector();
        this.a = new FunctionExceptionLog();
    }

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(n);
        }
        String string = "Server Group Protection will remove not allowed members from protected server groups (id: " + stringBuffer.toString() + ")" + (this.c ? " and kick them" : " but they will not kicked") + (this.d ? " (complaint will be added)" : "");
        this.a.addLogEntry(this.a, (byte)1, string, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
        int n = 0;
        while (n < this.a.size()) {
            this.e.setElementAt(this.a.getServerGroupType((Integer)this.a.elementAt(n)) == 1, n);
            ++n;
        }
    }

    @Override
    public void activate() {
        ServerGroupProtection serverGroupProtection = this;
        boolean bl = false;
        int n = 0;
        while (n < serverGroupProtection.a.size()) {
            if (((Vector)serverGroupProtection.c.elementAt(n)).size() == 0) {
                try {
                    Vector vector = serverGroupProtection.a.getList(9, "sgid=" + Integer.toString((Integer)serverGroupProtection.a.elementAt(n)) + ",-names");
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        ServerGroupProtection serverGroupProtection2 = serverGroupProtection;
                        serverGroupProtection2.a((Integer)serverGroupProtection2.a.elementAt(n), (String)((HashMap)vector.elementAt(n2)).get("client_unique_identifier"), (String)((HashMap)vector.elementAt(n2)).get("client_nickname"), false);
                        bl = true;
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    serverGroupProtection.a.addLogEntry(serverGroupProtection.a, exception, false);
                }
            }
            ++n;
        }
        if (bl) {
            serverGroupProtection.a();
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.c = null;
        this.d = null;
        this.e = null;
        this.b = null;
        this.a = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_groups", "A comma separated list (without spaces) of server group ids, which should be protected.");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_kick", "Enable this to kick every client which using a protected server group and are not on the list of the bot, set yes or no here!", "yes");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_add_complain", "Add complaint entry to the user, set yes or no here!\nThis would only add a complaint, if the bot has to remove a server group.", "no");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_add_missing_groups", "If a client is listed in the servergroupprotection_file and miss a server group, they get added to the server group.\nThis only works for normal server groups (clients do not get added to groups like Admin Server Query)! Set yes or no here!", "yes");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_chatcmd_group_list", "A comma separated list (without spaces) of server group ids, which are also allowed to use the add and remove chat commands.\nBot admins can always use this commands!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the client should get the message (useless if kick is enabled).\npoke, chat or none are valid values!", "poke");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the Server Group Protection client list and kick message.", "%apphome%config/server1/servergroupprotection.cfg");
        }
        if (this.a.getMySQLConnection() != null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "The kick or chat message for the server group protection.\nYou can use the following keywords, which will be replaced:\n%SERVER_GROUP_ID% - Replaced with the server group id.\n%SERVER_GROUP_NAME% - Replaced with the server group name.\nYou can use \\n for a new line and typical BBCode like in Teamspeak 3 Client.");
        }
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter arrangedPropertiesWriter, boolean bl) {
        String string = "";
        this.a = false;
        try {
            this.e.clear();
            this.a.clear();
            Object object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_groups");
            string = String.valueOf(this.a) + "_groups";
            if (object != null && ((String)object).length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                    this.a.addElement(n);
                    this.e.addElement(this.a.getServerGroupType(n) == 1);
                }
            } else {
                throw new BotConfigurationException("Server Group Protection needs at least one server group set! Check config key: " + this.a + "_groups");
            }
            this.b.clear();
            object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_chatcmd_group_list");
            string = String.valueOf(this.a) + "_chatcmd_group_list";
            if (object != null && ((String)object).length() > 0) {
                object = new StringTokenizer((String)object, ",", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.b.addElement(Integer.parseInt(((StringTokenizer)object).nextToken().trim()));
                }
            }
            this.d = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_add_complain", "no").trim().equalsIgnoreCase("yes");
            this.b = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_add_missing_groups", "no").trim().equalsIgnoreCase("yes");
            this.c = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_kick", "no").trim().equalsIgnoreCase("yes");
            if (this.c) {
                this.c = "kick";
            }
            this.c = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_message_mode", "chat").trim();
            this.b = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_file");
            if (!this.a(arrangedPropertiesWriter)) {
                throw new BotConfigurationException("Server Group Protection configuration does not exists or error while loading!");
            }
            if (!this.a.isMessageLengthValid(this.c, this.d)) {
                this.a.addLogEntry(this.a, (byte)2, "Server Group Protection message is to long! Make sure that " + this.c + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.c)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.b : ""), true);
            }
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + arrangedPropertiesWriter.getValue(string, "not set"));
            numberFormatException2.setStackTrace(numberFormatException.getStackTrace());
            throw numberFormatException2;
        }
        return this.a;
    }

    private boolean a(ArrangedPropertiesWriter object) {
        BufferedReader bufferedReader;
        block44: {
            if (this.a.getMySQLConnection() != null) {
                boolean bl;
                block43: {
                    MySQLConnect mySQLConnect = this.a.getMySQLConnection();
                    this.d = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message");
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        try {
                            mySQLConnect.connect();
                            preparedStatement = mySQLConnect.getPreparedStatement("SELECT servergroup_id, client_unique_id, comment FROM jts3servermod_servergroupprotection WHERE instance_id = ? AND prefix = ?");
                            preparedStatement.setInt(1, this.a.getInstanceID());
                            preparedStatement.setString(2, this.a);
                            resultSet = preparedStatement.executeQuery();
                            resultSet.last();
                            int n = resultSet.getRow();
                            this.c.clear();
                            this.d.clear();
                            int n2 = 0;
                            while (n2 < this.a.size()) {
                                this.c.addElement(new Vector());
                                this.d.addElement(new Vector());
                                ++n2;
                            }
                            if (n > 0) {
                                resultSet.beforeFirst();
                                while (resultSet.next()) {
                                    try {
                                        n2 = this.a.indexOf(resultSet.getInt(1));
                                        if (n2 == -1) continue;
                                        ((Vector)this.c.elementAt(n2)).addElement(resultSet.getString(2).trim());
                                        ((Vector)this.d.elementAt(n2)).addElement(resultSet.getString(3).trim());
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            bl = false;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception2) {}
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                            catch (Exception exception3) {}
                            mySQLConnect.close();
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception) {}
                        mySQLConnect.close();
                        throw throwable;
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {}
                    mySQLConnect.close();
                }
                return bl;
            }
            if (this.b == null) {
                this.a.addLogEntry(this.a, (byte)3, "Path to Server Group Protection config file was not set in bot config! Check config key: " + this.a + "_file", true);
                return false;
            }
            this.b = this.b.trim().replace("%apphome%", System.getProperty("app.home", ""));
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.b), this.a.getMessageEncoding()));
            object = bufferedReader.readLine();
            if (this.a.getMessageEncoding().equalsIgnoreCase("UTF-8") && object != null && ((String)object).charAt(0) == '\ufeff') {
                object = ((String)object).substring(1);
            }
            if (object != null && ((String)object).equals("# JTS3ServerMod Config File")) break block44;
            this.a.addLogEntry(this.a, (byte)3, "Special config file header is missing at Server Group Protection config file! File path: " + this.b, true);
            this.a.addLogEntry(this.a, (byte)3, "Check if you set the right file at config key: " + this.a + "_file", true);
            bufferedReader.close();
            return false;
        }
        try {
            this.c.clear();
            this.d.clear();
            int n = 0;
            while (n < this.a.size()) {
                this.c.addElement(new Vector());
                this.d.addElement(new Vector());
                ++n;
            }
            n = 0;
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("#") || ((String)object).length() <= 3) continue;
                if (n == 0) {
                    this.d = object = ((String)object).replace("\\n", "\n");
                }
                if (n > 0) {
                    int n3 = ((String)object).indexOf(",");
                    int n4 = ((String)object).indexOf(" ", n3 + 10);
                    if (n3 == -1 || n3 == 0) continue;
                    try {
                        String string;
                        int n5 = this.a.indexOf(Integer.parseInt(((String)object).substring(0, n3)));
                        if (n5 == -1) continue;
                        if (n4 == -1) {
                            string = ((String)object).substring(n3 + 1).trim();
                            ((Vector)this.d.elementAt(n5)).addElement("");
                        } else {
                            string = ((String)object).substring(n3 + 1, n4).trim();
                            ((Vector)this.d.elementAt(n5)).addElement(((String)object).substring(n4));
                        }
                        ((Vector)this.c.elementAt(n5)).addElement(string);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.a.addLogEntry(this.a, (byte)3, "Server Group Protection config file you set at config key \"" + this.a + "_file\" does not exist or missing permission for reading, check file path: " + new File(this.b).getAbsolutePath(), true);
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Server Group Protection config file! Check file you set at config key \"" + this.a + "_file\", the file path: " + this.b, true);
            this.a.addLogEntry(this.a, exception, true);
            return false;
        }
        return true;
    }

    private boolean a() {
        if (this.a.getMySQLConnection() != null) {
            int n;
            try (MySQLConnect mySQLConnect = this.a.getMySQLConnection();){
                try {
                    mySQLConnect.connect();
                    PreparedStatement preparedStatement = mySQLConnect.getPreparedStatement("DELETE FROM jts3servermod_servergroupprotection WHERE instance_id = " + Integer.toString(this.a.getInstanceID()) + " AND prefix = ?");
                    preparedStatement.setString(1, this.a);
                    preparedStatement.executeUpdate();
                    preparedStatement = mySQLConnect.getPreparedStatement("INSERT INTO jts3servermod_servergroupprotection (instance_id, prefix, servergroup_id, client_unique_id, comment) VALUES (" + Integer.toString(this.a.getInstanceID()) + ", ?, ?, ?, ?)");
                    if (this.c != null && this.a != null) {
                        n = 0;
                        while (n < this.c.size()) {
                            int n2 = 0;
                            while (n2 < ((Vector)this.c.elementAt(n)).size()) {
                                preparedStatement.setString(1, this.a);
                                preparedStatement.setInt(2, (Integer)this.a.elementAt(n));
                                preparedStatement.setString(3, (String)((Vector)this.c.elementAt(n)).elementAt(n2));
                                preparedStatement.setString(4, (String)((Vector)this.d.elementAt(n)).elementAt(n2));
                                preparedStatement.executeUpdate();
                                ++n2;
                            }
                            ++n;
                        }
                    }
                    n = 1;
                }
                catch (Exception exception) {
                    n = 0;
                    mySQLConnect.close();
                }
            }
            return n != 0;
        }
        if (this.b == null) {
            return false;
        }
        try {
            PrintStream printStream = new PrintStream(this.b, this.a.getMessageEncoding());
            printStream.println("# JTS3ServerMod Config File");
            printStream.println("# The first line is the kick or chat message for the Server Group Protection.");
            printStream.println("# You can use the following keywords, which will be replaced:");
            printStream.println("# %SERVER_GROUP_ID% - Replaced with the server group id.");
            printStream.println("# %SERVER_GROUP_NAME% - Replaced with the server group name.");
            printStream.println("# Typical BBCode like in Teamspeak 3 Client possible.");
            if (this.d == null) {
                printStream.println();
            } else {
                printStream.println(this.d.replace("\n", "\\n"));
            }
            printStream.println();
            printStream.println("# This is the list of allowed clients in the protected server groups.");
            printStream.println("# One line per client starting with the server group id, followed by a comma,");
            printStream.println("# and ends with the unique id of the client.");
            printStream.println("# Comments separated with a space behind the unique ids are allowed.");
            printStream.println("# If a client is member of two protected groups, make two lines with the");
            printStream.println("# same unique id, but different server group id.");
            printStream.println("# Notice: If no clients are set for one server group, a list");
            printStream.println("# with the current members of the server group will be requested from the TS3 server");
            printStream.println("# and written into this file automatically!");
            if (this.c != null && this.a != null) {
                int n = 0;
                while (n < this.c.size()) {
                    int n3 = 0;
                    while (n3 < ((Vector)this.c.elementAt(n)).size()) {
                        printStream.print(this.a.elementAt(n));
                        printStream.print(",");
                        printStream.print((String)((Vector)this.c.elementAt(n)).elementAt(n3));
                        printStream.println((String)((Vector)this.d.elementAt(n)).elementAt(n3));
                        ++n3;
                    }
                    ++n;
                }
            }
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, true);
            return false;
        }
        return true;
    }

    private int a(int n, String string, String string2, boolean bl) {
        if (this.c == null || this.a == null) {
            return -3;
        }
        if ((n = this.a.indexOf(n)) < 0) {
            return -2;
        }
        int n2 = ((Vector)this.c.elementAt(n)).indexOf(string);
        if (n2 >= 0) {
            return 0;
        }
        ((Vector)this.c.elementAt(n)).addElement(string);
        if (this.a.getMySQLConnection() == null) {
            ((Vector)this.d.elementAt(n)).addElement(string2 != null && string2.length() > 0 ? "   # ".concat(String.valueOf(string2)) : "");
        } else {
            ((Vector)this.d.elementAt(n)).addElement(string2);
        }
        if (bl) {
            if (this.a()) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    @Override
    public void setListModes(BitSet bitSet) {
        bitSet.set(1);
        bitSet.set(4);
    }

    @Override
    public String[] botChatCommandList(HashMap stringArray, boolean bl, boolean bl2) {
        if (bl || bl2 || this.a((String)stringArray.get("invokerid"))) {
            stringArray = new String[]{"add <server group id> <client unique id> [comment]", "remove <server group id> <client unique id>"};
            return stringArray;
        }
        return null;
    }

    @Override
    public String botChatCommandHelp(String string) {
        if (string.equals("add")) {
            return "Adds the unique id of a client to a protected server group (this will also saved into config).";
        }
        if (string.equals("remove")) {
            return "Removes a client unique id from a protected server group (this will also saved into config).";
        }
        return null;
    }

    private boolean a(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        HashMap hashMap = this.a.getClientListEntry(n);
        if (hashMap != null) {
            return this.a.isGroupListed((String)hashMap.get("client_servergroups"), this.b);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleChatCommands(String object, HashMap object2, boolean n, boolean n2) {
        if (n != 0 || n2 != 0 || this.a((String)((HashMap)object2).get("invokerid"))) {
            if (((String)object).toLowerCase().startsWith("add ") || ((String)object).toLowerCase().equals("add")) {
                n2 = n;
                Object object3 = object2;
                object2 = object;
                object = this;
                try {
                    if (((String)object2).length() < 30) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Wrong usage! Right: !" + ((ServerGroupProtection)object).a + " add <server group id> <client unique id> [comment]");
                        return true;
                    }
                    try {
                        object2 = ((String)object2).substring(4).split(" ", 3);
                        int n3 = -1;
                        String string = null;
                        Object object4 = "";
                        String string2 = ((String)object2[0]).trim();
                        try {
                            n3 = Integer.parseInt(string2);
                            string = ((String)object2[1]).trim();
                            if (((Object)object2).length > 2) {
                                object4 = object2[2];
                            }
                        }
                        catch (Exception exception) {
                            try {
                                string = string2;
                                n3 = Integer.parseInt(((String)object2[1]).trim());
                                if (((Object)object2).length > 2) {
                                    object4 = object2[2];
                                }
                            }
                            catch (Exception exception2) {}
                        }
                        if (string.length() < 20) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Error while reading given client unique id!");
                            return true;
                        } else if (n3 <= 0) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Error while reading given server group id!");
                            return true;
                        } else if (((ServerGroupProtection)object).a.indexOf(n3) == -1) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "The server group id " + Integer.toString(n3) + " is not protected!");
                            return true;
                        } else if (n2 == 0 && !((Boolean)((ServerGroupProtection)object).e.elementAt(((ServerGroupProtection)object).a.indexOf(n3))).booleanValue()) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Only full bot admins can add someone to this server group!");
                            return true;
                        } else {
                            int n4 = super.a(n3, string, (String)object4, true);
                            if (n4 == 1) {
                                ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Successfully added client to protected server group!");
                                return true;
                            } else if (n4 == 0) {
                                ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Client was already on that list for server group " + Integer.toString(n3) + "!");
                                return true;
                            } else if (n4 == -1) {
                                ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Unable to save server group protection configuration file! Check if the configuration file is write protected!");
                                return true;
                            } else if (n4 == -2) {
                                ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Unable to add client to protected server group! Server group protection feature must be enabled and server group " + Integer.toString(n3) + " has to be on the watch list of the server group protection feature. Please make sure that this feature is enabled and add this server group to config value servergroupprotection_groups first!");
                                return true;
                            } else {
                                if (n4 != -3) return true;
                                ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Unable to add client to protected server group! Server group protection feature is disabled, enable it first!");
                            }
                        }
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object3).get("invokerid")), 1, "Error while reading given server group id!");
                        return true;
                    }
                }
                catch (Exception exception) {
                    ((ServerGroupProtection)object).a.addLogEntry(((ServerGroupProtection)object).a, exception, false);
                }
                return true;
            }
            if (!((String)object).toLowerCase().startsWith("remove ") && !((String)object).toLowerCase().equals("remove")) return false;
            n2 = n;
            Object object5 = object2;
            object2 = object;
            object = this;
            try {
                if (((String)object2).length() < 33) {
                    ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Wrong usage! Right: !" + ((ServerGroupProtection)object).a + " remove <server group id> <client unique id>");
                    return true;
                }
                try {
                    object2 = new StringTokenizer(((String)object2).substring(7), " ", false);
                    int n5 = -1;
                    String string = null;
                    String string3 = ((StringTokenizer)object2).nextToken().trim();
                    try {
                        n5 = Integer.parseInt(string3);
                        string3 = ((StringTokenizer)object2).nextToken().trim();
                        string = new String(string3);
                    }
                    catch (Exception exception) {
                        try {
                            string = new String(string3);
                            string3 = ((StringTokenizer)object2).nextToken().trim();
                            n5 = Integer.parseInt(string3);
                        }
                        catch (Exception exception3) {}
                    }
                    if (string.length() < 20) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Error while reading given client unique id!");
                        return true;
                    } else if (n5 <= 0) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Error while reading given server group id!");
                        return true;
                    } else if (((ServerGroupProtection)object).a.indexOf(n5) == -1) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "The server group id " + Integer.toString(n5) + " is not protected!");
                        return true;
                    } else if (n2 == 0 && !((Boolean)((ServerGroupProtection)object).e.elementAt(((ServerGroupProtection)object).a.indexOf(n5))).booleanValue()) {
                        ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Only full bot admins can remove someone from this server group!");
                        return true;
                    } else {
                        int n6;
                        int n7;
                        n2 = n5;
                        object2 = object;
                        if (((ServerGroupProtection)object2).c == null || ((ServerGroupProtection)object2).a == null) {
                            n7 = -3;
                        } else if ((n2 = ((ServerGroupProtection)object2).a.indexOf(n2)) < 0) {
                            n7 = -2;
                        } else {
                            int n8 = ((Vector)((ServerGroupProtection)object2).c.elementAt(n2)).indexOf(string);
                            if (n8 < 0) {
                                n7 = 0;
                            } else {
                                ((Vector)((ServerGroupProtection)object2).c.elementAt(n2)).remove(n8);
                                ((Vector)((ServerGroupProtection)object2).d.elementAt(n2)).remove(n8);
                                n7 = n6 = super.a() ? 1 : -1;
                            }
                        }
                        if (n7 == 1) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Successfully removed client from protected server group!");
                            return true;
                        } else if (n6 == 0) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Client is already not on that list for server group " + Integer.toString(n5) + "!");
                            return true;
                        } else if (n6 == -1) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Unable to save server group protection configuration file! Check if the configuration file is write protected!");
                            return true;
                        } else if (n6 == -2) {
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Unable to removed client from protected server group! Server group protection feature must be enabled and server group " + Integer.toString(n5) + " has to be on the watch list of the server group protection feature. Please make sure that this feature is enabled and add this server group to config value servergroupprotection_groups first!");
                            return true;
                        } else {
                            if (n6 != -3) return true;
                            ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Unable to removed client from protected server group! Server group protection feature is disabled, enable it first!");
                        }
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    ((ServerGroupProtection)object).a.sendTextMessage(Integer.parseInt((String)((HashMap)object5).get("invokerid")), 1, "Error while reading given server group id!");
                    return true;
                }
            }
            catch (Exception exception) {
                ((ServerGroupProtection)object).a.addLogEntry(((ServerGroupProtection)object).a, exception, false);
            }
            return true;
        }
        try {
            this.a.sendTextMessage(Integer.parseInt((String)((HashMap)object2).get("invokerid")), 1, "You are not my master!");
            return true;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, false);
        }
        return true;
    }

    @Override
    public void handleTS3Events(String string, HashMap hashMap) {
    }

    @Override
    public void handleClientCheck(Vector vector) {
        if (!this.a) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            HashMap hashMap = (HashMap)vector.elementAt(n);
            if (((String)hashMap.get("client_type")).equals("0")) {
                Object object;
                int n2;
                int n3 = Integer.parseInt((String)hashMap.get("clid"));
                StringTokenizer stringTokenizer = new StringTokenizer((String)hashMap.get("client_servergroups"), ",", false);
                Vector<Integer> vector2 = new Vector<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    vector2.addElement(n4);
                    n2 = 0;
                    while (n2 < this.a.size()) {
                        block31: {
                            if (n4 == (Integer)this.a.elementAt(n2) && ((Vector)this.c.elementAt(n2)).indexOf(hashMap.get("client_unique_identifier")) == -1) {
                                block30: {
                                    object = this.a.doCommand("servergroupdelclient sgid=" + Integer.toString(n4) + " cldbid=" + (String)hashMap.get("client_database_id"));
                                    if (((String)((HashMap)object).get("id")).equals("0")) {
                                        this.a.addLogEntry(this.a, (byte)1, "Removed client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") from server group " + Integer.toString(n4) + "!", false);
                                        this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                                    } else {
                                        try {
                                            throw new TS3ServerQueryException("ServerGroupProtection", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
                                        }
                                        catch (TS3ServerQueryException tS3ServerQueryException) {
                                            if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) break block30;
                                            this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                            this.a.addLogEntry(this.a, (byte)3, "Error while removing client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") from server group " + Integer.toString(n4) + "!", false);
                                            this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                                        }
                                    }
                                }
                                if (this.d) {
                                    try {
                                        this.a.complainAdd(Integer.parseInt((String)hashMap.get("client_database_id")), "Not allowed server group (id: " + Integer.toString(n4) + "): " + (String)hashMap.get("client_nickname"));
                                        this.a.addLogEntry(this.a, (byte)1, "Added complaint to client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + "), not allowed to be in the server group " + Integer.toString(n4) + "!", false);
                                        this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                                    }
                                    catch (TS3ServerQueryException tS3ServerQueryException) {
                                        if (!this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) {
                                            this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                            if (tS3ServerQueryException.getFailedPermissionID() >= 0) {
                                                this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + "), not allowed to be in the server group " + Integer.toString(n4) + "!", false);
                                                this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                                            } else {
                                                this.a.addLogEntry(this.a, (byte)2, "Error while adding complaint to client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + "), not allowed to be in the server group " + Integer.toString(n4) + "! Maybe the client already got a complaint from the bot?", false);
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + "), not allowed to be in the server group " + Integer.toString(n4) + "!", false);
                                        this.a.addLogEntry(this.a, exception, false);
                                    }
                                }
                                String string = this.a.getServerGroupName(n4);
                                object = new String(this.d);
                                object = ((String)object).replace("%SERVER_GROUP_ID%", Integer.toString(n4));
                                object = ((String)object).replace("%SERVER_GROUP_NAME%", string == null ? "Unknown" : string);
                                if (this.c) {
                                    try {
                                        this.a.kickClient(n3, false, (String)object);
                                        vector.removeElementAt(n);
                                        --n;
                                        this.a.addLogEntry(this.a, (byte)1, "Client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") was kicked for being member of the protected server group " + Integer.toString(n4) + ", unique ID is not on list!", false);
                                        this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                                    }
                                    catch (TS3ServerQueryException tS3ServerQueryException) {
                                        if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) break block31;
                                        this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                        this.a.addLogEntry(this.a, (byte)2, "Error while kicking client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") for being member of the protected server group " + Integer.toString(n4) + "!", false);
                                        if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                                            this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                                            break block31;
                                        }
                                        this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                                    }
                                    catch (Exception exception) {
                                        this.a.addLogEntry(this.a, (byte)3, "Error while kicking client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") for being member of the protected server group " + Integer.toString(n4) + "!", false);
                                        this.a.addLogEntry(this.a, exception, false);
                                    }
                                } else {
                                    this.a.sendMessageToClient(this.a, this.c, n3, (String)object);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (this.b) {
                    n2 = 0;
                    while (n2 < this.a.size()) {
                        block32: {
                            if (((Boolean)this.e.elementAt(n2)).booleanValue() && ((Vector)this.c.elementAt(n2)).indexOf(hashMap.get("client_unique_identifier")) != -1 && vector2.indexOf(this.a.elementAt(n2)) == -1) {
                                object = this.a.doCommand("servergroupaddclient sgid=" + Integer.toString((Integer)this.a.elementAt(n2)) + " cldbid=" + (String)hashMap.get("client_database_id"));
                                if (((String)((HashMap)object).get("id")).equals("0")) {
                                    this.a.addLogEntry(this.a, (byte)1, "Added client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") to server group " + Integer.toString((Integer)this.a.elementAt(n2)) + "!", false);
                                    this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                                } else {
                                    try {
                                        throw new TS3ServerQueryException("ServerGroupProtection", (String)((HashMap)object).get("id"), (String)((HashMap)object).get("msg"), (String)((HashMap)object).get("extra_msg"), (String)((HashMap)object).get("failed_permid"));
                                    }
                                    catch (TS3ServerQueryException tS3ServerQueryException) {
                                        if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) break block32;
                                        this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                        this.a.addLogEntry(this.a, (byte)3, "Error while adding client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") to server group " + Integer.toString((Integer)this.a.elementAt(n2)) + "!", false);
                                        this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Server Group Protection function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

