/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerGroupNotify
implements HandleBotEvents,
HandleTS3Events,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private Vector a = new Vector();
    private Vector b;
    private Vector c;
    private String b;
    private String c = null;
    private String d;
    private String e = null;
    private String f = null;
    private String g = null;
    private Vector d = null;
    private boolean b = true;

    public ServerGroupNotify() {
        this.c = new Vector();
        this.d = new Vector();
    }

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.a.iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(n);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (stringBuffer2.length() != 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(n);
        }
        object = "Watching for new connecting clients of selected server groups (id: " + stringBuffer.toString() + "), sending message to all online clients of server group ids: " + stringBuffer2.toString();
        this.a.addLogEntry(this.a, (byte)1, (String)object, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.b = null;
        this.d = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_groups", "A comma separated list (without spaces) of server group ids, which should be watched on joining.");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_grouptargets", "A comma separated list (without spaces) of server group ids, which should be notified about joining clients.");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_showonconnectionnumber", "A comma separated list (without spaces) of the total connection count (it's the same value as %CLIENT_TOTALCONNECTIONS% at the welcome message),\nwhen this message should be send to the clients. Set this to -1 to show it every time.\nRanges like 1-100, -20 (means 20 or less) or 100- (means 100 or more) are also possible.", "-1");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nDepends on the given mode, target clients in this channels can be ignored or only clients in this channels receive the notify message!\nIf no channels should be ignored, set no channels here and select the channel list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_list_mode", "Select one of the two modes for the channel list.\nignore = Clients in the selected channels will be ignored.\nonly = Only clients in the selected channels receive the notify message.", "ignore");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the notified clients should get the message.\npoke, chat or none are valid values!", "poke");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_messagenotified_mode", "Select the message mode, how the clients (who joined the server) should get the message.\npoke, chat or none are valid values!", "none");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the server group notify message", "%apphome%config/server1/servergroupnotifymessages.cfg");
        }
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "Server Group Notify message, specified clients get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%SERVER_GROUP_ID% - Server Group ID\n%SERVER_GROUP_NAME% - Server Group Name\n%CLIENT_NAME% - Client Name\n%CLIENT_DBID% - Client Database ID\n%CLIENT_UNIQUEID% - Client Unique ID\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.a.getMySQLConnection() != null);
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_messagenotified", "Server Group Notify message for the watched client.\nIf enabled, clients with a watched server group connecting the server get this message as chat or poke message.\nYou can use the following keywords, which will be replaced:\n%CLIENT_COUNT% - Number of target group clients who get informed about this client\n%CLIENT_NAMES% - List of names of target group clients who get informed about this client\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.a.getMySQLConnection() != null);
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_messagenotnotified", "Server Group Notify message for the watched client, if no target group client is online\nIf enabled, clients with a watched server group connecting the server get this message as chat or poke message.\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.a.getMySQLConnection() != null);
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter arrangedPropertiesWriter, boolean bl) {
        this.a = false;
        if (bl) {
            this.a.addLogEntry(this.a, (byte)2, "Slow Mode is activated, if the bot gets banned by the TS3 server, you should disable the Server Group Notify!", true);
        }
        String string = "";
        try {
            StringTokenizer stringTokenizer;
            this.d = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_file");
            this.b = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_message_mode", "chat").trim();
            this.c = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_messagenotified_mode", "chat").trim();
            Object object = new String[]{String.valueOf(this.a) + "_message", String.valueOf(this.a) + "_messagenotified", String.valueOf(this.a) + "_messagenotnotified"};
            if (!this.a.loadMessages(this.a, "_file", (String[])object)) {
                throw new BotConfigurationException("Server Group Notify messages could not be loaded!");
            }
            this.e = arrangedPropertiesWriter.getValue(object[0]);
            if (this.e == null || this.e.length() == 0) {
                throw new BotConfigurationException("Server Group Notify message could not be loaded!");
            }
            if (this.c.equalsIgnoreCase("poke") || this.c.equalsIgnoreCase("chat")) {
                this.f = arrangedPropertiesWriter.getValue(object[1]);
                if (this.f == null || this.f.length() == 0) {
                    throw new BotConfigurationException("Server Group Notify message for the watched client missing in config!");
                }
                this.g = arrangedPropertiesWriter.getValue(object[2]);
                if (this.g == null || this.g.length() == 0) {
                    throw new BotConfigurationException("Server Group Notify message for the watched client (if no target group client is online) missing in config!");
                }
            }
            this.c.clear();
            object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_showonconnectionnumber", "-1");
            string = String.valueOf(this.a) + "_showonconnectionnumber";
            if (object != null && ((String)object).length() > 0) {
                stringTokenizer = new StringTokenizer((String)object, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.c.addElement(stringTokenizer.nextToken().trim());
                }
            }
            this.a.clear();
            object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_groups");
            string = String.valueOf(this.a) + "_groups";
            if (object != null && ((String)object).length() > 0) {
                stringTokenizer = new StringTokenizer((String)object, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.a.addElement(Integer.parseInt(stringTokenizer.nextToken().trim()));
                }
            }
            this.b.clear();
            object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_grouptargets");
            string = String.valueOf(this.a) + "_grouptargets";
            if (object != null && ((String)object).length() > 0) {
                stringTokenizer = new StringTokenizer((String)object, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.b.addElement(Integer.parseInt(stringTokenizer.nextToken().trim()));
                }
            }
            this.d.clear();
            object = arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_channel_list");
            string = String.valueOf(this.a) + "_channel_list";
            if (object != null && ((String)object).length() > 0) {
                stringTokenizer = new StringTokenizer((String)object, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.d.addElement(Integer.parseInt(stringTokenizer.nextToken().trim()));
                }
            }
            boolean bl2 = this.b = !arrangedPropertiesWriter.getValue(String.valueOf(this.a) + "_channel_list_mode", "ignore").trim().equalsIgnoreCase("only");
            if (this.a.size() == 0 || this.b.size() == 0) {
                throw new BotConfigurationException("No server groups in bot configuration set. Check config values of " + this.a + "_groups and " + this.a + "_grouptargets");
            }
            this.a.addTS3ServerEvent(this);
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + arrangedPropertiesWriter.getValue(string, "not set"));
            numberFormatException2.setStackTrace(numberFormatException.getStackTrace());
            throw numberFormatException2;
        }
        return this.a;
    }

    @Override
    public void setListModes(BitSet bitSet) {
        bitSet.set(1);
        bitSet.set(4);
    }

    @Override
    public String[] botChatCommandList(HashMap hashMap, boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public String botChatCommandHelp(String string) {
        return null;
    }

    @Override
    public boolean handleChatCommands(String string, HashMap hashMap, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void handleTS3Events(String object, HashMap hashMap) {
        int n;
        if (!this.a) {
            return;
        }
        if (((String)object).equals("notifycliententerview") && ((String)hashMap.get("client_type")).equals("0") && this.a((String)hashMap.get("clid")) && (object = this.a.getClientList()) != null && (n = this.a.getListedGroup((String)hashMap.get("client_servergroups"), this.a)) > 0) {
            int n2;
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Object object2 = this.a.getServerGroupName(n);
            String string = new String(this.e);
            string = string.replace("%SERVER_GROUP_ID%", Integer.toString(n));
            string = string.replace("%SERVER_GROUP_NAME%", (CharSequence)(object2 == null ? "Unknown" : object2));
            if (!this.a.isMessageLengthValid(this.b, string = string.replace("%CLIENT_NAME_CLICKABLE%", "[URL=client://0/" + (String)hashMap.get("client_unique_identifier") + "]" + (String)hashMap.get("client_nickname") + "[/URL]"))) {
                this.a.addLogEntry(this.a, (byte)2, "Server Group Notify message is to long! Make sure that " + this.b + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.b)) + " characters (including spaces and BBCode), check file: " + this.d, true);
            }
            object2 = ((Vector)object).iterator();
            while (object2.hasNext()) {
                HashMap hashMap2 = (HashMap)object2.next();
                if (!((String)hashMap2.get("client_type")).equals("0") || !this.a.isGroupListed((String)hashMap2.get("client_servergroups"), this.b)) continue;
                n2 = this.a.isIDListed(Integer.parseInt((String)hashMap2.get("cid")), this.d) ? 1 : 0;
                if (!(this.b ? n2 == 0 : n2 != 0)) continue;
                int n3 = Integer.parseInt((String)hashMap2.get("clid"));
                if (!this.b.equalsIgnoreCase("none") && !this.a.sendMessageToClient(this.a, this.b, n3, this.a(string, hashMap))) continue;
                vector.addElement((String)hashMap2.get("client_nickname"));
                vector2.addElement((String)hashMap2.get("client_unique_identifier"));
            }
            if (this.c.equalsIgnoreCase("poke") || this.c.equalsIgnoreCase("chat")) {
                int n4 = Integer.parseInt((String)hashMap.get("clid"));
                if (vector.size() == 0) {
                    if (!this.a.isMessageLengthValid(this.c, this.g)) {
                        this.a.addLogEntry(this.a, (byte)2, "Server Group Notify message for the watched client (if no target group client is online) is to long! Make sure that " + this.c + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.c)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.d : "!"), true);
                    }
                    ServerGroupNotify serverGroupNotify = this;
                    this.a.sendMessageToClient(this.a, this.c, n4, serverGroupNotify.a(serverGroupNotify.g, hashMap));
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                object2 = new StringBuffer();
                n2 = 0;
                while (n2 < vector.size()) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                        ((StringBuffer)object2).append(", ");
                    }
                    stringBuffer.append((String)vector.elementAt(n2));
                    ((StringBuffer)object2).append("[URL=client://0/" + (String)vector2.elementAt(n2) + "]" + (String)vector.elementAt(n2) + "[/URL]");
                    ++n2;
                }
                String string2 = new String(this.f);
                string2 = string2.replace("%CLIENT_COUNT%", Integer.toString(vector.size()));
                string2 = string2.replace("%CLIENT_NAMES%", stringBuffer.toString());
                if (!this.a.isMessageLengthValid(this.c, string2 = string2.replace("%CLIENT_NAMES_CLICKABLE%", ((StringBuffer)object2).toString()))) {
                    this.a.addLogEntry(this.a, (byte)2, "Server Group Notify message for the watched client is to long! Make sure that " + this.c + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.c)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.d : "!"), true);
                }
                this.a.sendMessageToClient(this.a, this.c, n4, this.a(string2, hashMap));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String string) {
        try {
            HashMap hashMap;
            if (this.c.indexOf("-1") != -1) return true;
            try {
                hashMap = this.a.getInfo(13, Integer.parseInt(string));
                if (hashMap == null) {
                    throw new NullPointerException("Invalid client information returned!");
                }
            }
            catch (Exception exception) {
                this.a.addLogEntry(this.a, (byte)3, "Error while requesting information of client id " + string + " from TS3 server!", false);
                this.a.addLogEntry(this.a, exception, false);
                return false;
            }
            if (hashMap.get("client_totalconnections") == null) {
                this.a.addLogEntry(this.a, new NullPointerException("Got no client_totalconnections value from TS3 server!"), false);
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= this.c.size()) {
                    return false;
                }
                int n2 = Integer.parseInt((String)hashMap.get("client_totalconnections"));
                String string2 = (String)this.c.elementAt(n);
                int n3 = string2.indexOf("-");
                if (n3 != -1) {
                    int n4 = 0;
                    int n5 = Integer.MAX_VALUE;
                    if (n3 > 0) {
                        n4 = Integer.parseInt(string2.substring(0, n3).trim());
                    }
                    if (n3 < string2.length() - 1) {
                        n5 = Integer.parseInt(string2.substring(n3 + 1).trim());
                    }
                    if (n2 >= n4 && n2 <= n5) {
                        return true;
                    }
                } else if (n2 == Integer.parseInt(string2)) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, false);
            return false;
        }
    }

    private String a(String string, HashMap hashMap) {
        try {
            if (hashMap.get("cid") != null) {
                string = string.replace("%CLIENT_ID%", (CharSequence)hashMap.get("cid"));
            }
            if (hashMap.get("client_nickname") != null) {
                string = string.replace("%CLIENT_NAME%", (CharSequence)hashMap.get("client_nickname"));
            }
            if (hashMap.get("client_database_id") != null) {
                string = string.replace("%CLIENT_DBID%", (CharSequence)hashMap.get("client_database_id"));
            }
            if (hashMap.get("client_unique_identifier") != null) {
                string = string.replace("%CLIENT_UNIQUEID%", (CharSequence)hashMap.get("client_unique_identifier"));
            }
            if (hashMap.get("client_country") != null) {
                string = string.replace("%CLIENT_COUNTRY%", hashMap.get("client_country") == "" ? "unknown" : (String)hashMap.get("client_country"));
            }
            if (hashMap.get("client_version") != null) {
                string = string.replace("%CLIENT_VERSION%", this.a.getVersionString((String)hashMap.get("client_version")));
            }
            if (hashMap.get("client_platform") != null) {
                string = string.replace("%CLIENT_PLATFORM%", (CharSequence)hashMap.get("client_platform"));
            }
            if (hashMap.get("connection_client_ip") != null) {
                string = string.replace("%CLIENT_IP%", (CharSequence)hashMap.get("connection_client_ip"));
            }
            if (hashMap.get("client_created") != null) {
                string = string.replace("%CLIENT_CREATED%", this.a.getStringFromTimestamp(Long.parseLong((String)hashMap.get("client_created")) * 1000L));
            }
            if (hashMap.get("client_totalconnections") != null) {
                string = string.replace("%CLIENT_TOTALCONNECTIONS%", (CharSequence)hashMap.get("client_totalconnections"));
            }
            if (hashMap.get("client_month_bytes_uploaded") != null) {
                string = string.replace("%CLIENT_MONTH_BYTES_UPLOADED%", this.a.getFileSizeString(Long.parseLong((String)hashMap.get("client_month_bytes_uploaded")), false));
            }
            if (hashMap.get("client_month_bytes_downloaded") != null) {
                string = string.replace("%CLIENT_MONTH_BYTES_DOWNLOADED%", this.a.getFileSizeString(Long.parseLong((String)hashMap.get("client_month_bytes_downloaded")), false));
            }
            if (hashMap.get("client_total_bytes_uploaded") != null) {
                string = string.replace("%CLIENT_TOTAL_BYTES_UPLOADED%", this.a.getFileSizeString(Long.parseLong((String)hashMap.get("client_total_bytes_uploaded")), false));
            }
            if (hashMap.get("client_total_bytes_downloaded") != null) {
                string = string.replace("%CLIENT_TOTAL_BYTES_DOWNLOADED%", this.a.getFileSizeString(Long.parseLong((String)hashMap.get("client_total_bytes_downloaded")), false));
            }
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, false);
            string = null;
        }
        return string;
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Server Group Notify function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

