/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.functions.InactiveClientsCleaner$1;
import de.stefan1200.jts3servermod.interfaces.ClientDatabaseCache_Interface;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3servermod.interfaces.ServerInfoCache_Interface;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InactiveClientsCleaner
implements HandleBotEvents,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private ClientDatabaseCache_Interface a;
    private boolean a;
    private int a;
    private Vector a;
    private boolean b = true;
    private TimerTask a;
    private FunctionExceptionLog a = new FunctionExceptionLog();

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        String string = "Delete clients from Teamspeak 3 database after being inactive for at least " + Integer.toString(this.a) + " days.";
        if (!this.b || this.a.size() > 0) {
            string = String.valueOf(string) + " Only members of " + Integer.toString(this.a.size()) + " specified server groups will " + (this.b ? "not " : "") + "be deleted.";
        }
        this.a.addLogEntry(this.a, (byte)1, string, true);
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_inactivity_days", "How many days a client has to be inactive to get deleted from the TS3 server database?\nPossible values are between 30 and 730.\nNotice: After the client was deleted, the client can connect again to the server, but all permissions are lost!", "180");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter object, boolean bl) {
        String string = "";
        this.a = false;
        if (!this.a.isLocalClientDatabaseCacheEnabled()) {
            throw new BotConfigurationException("The local Client Database Cache of the JTS3ServerMod must be enabled to use this function!");
        }
        try {
            string = String.valueOf(this.a) + "_inactivity_days";
            Object object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_inactivity_days");
            if (object2 == null) {
                throw new NumberFormatException();
            }
            this.a = Integer.parseInt(((String)object2).trim());
            if (this.a < 30) {
                this.a = 30;
            } else if (this.a > 730) {
                this.a = 730;
            }
            this.a.clear();
            object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list");
            string = String.valueOf(this.a) + "_group_list";
            if (object2 != null && ((String)object2).length() > 0) {
                object2 = new StringTokenizer((String)object2, ",", false);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    this.a.addElement(Integer.parseInt(((StringTokenizer)object2).nextToken().trim()));
                }
            }
            boolean bl2 = this.b = !((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            if (!this.b && this.a.size() == 0) {
                throw new BotConfigurationException("An empty group list is not allowed while using the group list mode only!");
            }
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            object = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + ((ArrangedPropertiesWriter)object).getValue(string, "not set"));
            ((Throwable)object).setStackTrace(numberFormatException.getStackTrace());
            throw object;
        }
        return this.a;
    }

    @Override
    public void setListModes(BitSet bitSet) {
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
        if (!this.a) {
            return;
        }
        if (this.a != null) {
            this.a.cancel();
        }
        this.a = null;
        this.a = new InactiveClientsCleaner$1(this);
        this.a.addBotTimer(this.a, 86400000L, 86400000L);
    }

    @Override
    public void disable() {
        if (this.a != null) {
            this.a.cancel();
        }
        this.a = null;
    }

    @Override
    public void unload() {
        this.a = null;
        this.a = null;
    }

    private boolean a(int n) {
        HashMap hashMap = this.a.doCommand("clientdbdelete cldbid=" + Integer.toString(n));
        if (((String)hashMap.get("id")).equals("0")) {
            this.a.clearException(n);
            return true;
        }
        try {
            throw new TS3ServerQueryException("ServerGroupProtection", (String)hashMap.get("id"), (String)hashMap.get("msg"), (String)hashMap.get("extra_msg"), (String)hashMap.get("failed_permid"));
        }
        catch (TS3ServerQueryException tS3ServerQueryException) {
            if (!this.a.existsException(tS3ServerQueryException, n)) {
                this.a.addException(tS3ServerQueryException, n);
                this.a.addLogEntry(this.a, (byte)3, "Error while deleting inactive client db id " + Integer.toString(n) + " from the Teamspeak 3 database!", false);
                if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                    this.a.addLogEntry(this.a, (byte)3, tS3ServerQueryException.toString(), false);
                } else {
                    this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                }
            }
            return false;
        }
    }

    private static boolean a(Vector vector, Vector vector2) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                int n2 = (Integer)iterator2.next();
                if (n != n2) continue;
                return true;
            }
        }
        return false;
    }

    private Vector a(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        Cloneable cloneable = this.a.getList(10, "cldbid=" + Integer.toString(n));
        ServerInfoCache_Interface serverInfoCache_Interface = this.a.getServerInfoCache();
        int n2 = serverInfoCache_Interface.getServerDefaultServerGroup();
        Iterator iterator = ((Vector)cloneable).iterator();
        while (iterator.hasNext()) {
            cloneable = (HashMap)iterator.next();
            if (n2 == Integer.parseInt((String)((HashMap)cloneable).get("sgid"))) continue;
            vector.addElement(Integer.parseInt((String)((HashMap)cloneable).get("sgid")));
        }
        return vector;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Inactive Clients Cleaner function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }

    static /* synthetic */ void a(InactiveClientsCleaner inactiveClientsCleaner) {
        if (inactiveClientsCleaner.a == null) {
            inactiveClientsCleaner.a = inactiveClientsCleaner.a.getClientCache();
            if (inactiveClientsCleaner.a == null) {
                inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, (byte)3, "The local Client Database Cache of the JTS3ServerMod must be enabled to use this function!", true);
                inactiveClientsCleaner.a = false;
                inactiveClientsCleaner.a.unloadFunction(inactiveClientsCleaner);
                return;
            }
        }
        int n = 0;
        Vector vector = inactiveClientsCleaner.a.searchInactiveClients(inactiveClientsCleaner.a, -1);
        inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, (byte)1, "Start checking " + Integer.toString(vector.size()) + " clients, which are already inactive for at least " + Integer.toString(inactiveClientsCleaner.a) + " days!", false);
        for (HashMap hashMap : vector) {
            block16: {
                if (((Integer)hashMap.get("cldbid")).equals(Integer.toString(inactiveClientsCleaner.a.getCurrentQueryClientDatabaseID()))) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!inactiveClientsCleaner.b || inactiveClientsCleaner.a.size() > 0) {
                    try {
                        Vector vector2 = inactiveClientsCleaner.a((Integer)hashMap.get("cldbid"));
                        inactiveClientsCleaner.a.clearException((Integer)hashMap.get("cldbid"));
                        boolean bl = InactiveClientsCleaner.a(vector2, inactiveClientsCleaner.a);
                        if (inactiveClientsCleaner.b) {
                            if (bl) {
                                continue;
                            }
                        } else if (!bl) {
                        }
                        break block16;
                    }
                    catch (TS3ServerQueryException tS3ServerQueryException) {
                        TS3ServerQueryException tS3ServerQueryException2 = tS3ServerQueryException;
                        if (tS3ServerQueryException.getErrorID() == 512) {
                            inactiveClientsCleaner.a.deleteClientFromCache((Integer)hashMap.get("cldbid"));
                            continue;
                        }
                        if (inactiveClientsCleaner.a.existsException(tS3ServerQueryException2, (Integer)hashMap.get("cldbid"))) continue;
                        inactiveClientsCleaner.a.addException(tS3ServerQueryException2, (Integer)hashMap.get("cldbid"));
                        inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, (byte)2, "Can't request server groups for client db id " + Integer.toString((Integer)hashMap.get("cldbid")) + "!", false);
                        if (tS3ServerQueryException2.getFailedPermissionID() < 0) {
                            inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, (byte)2, tS3ServerQueryException2.toString(), false);
                            continue;
                        }
                        inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, tS3ServerQueryException2, false);
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            inactiveClientsCleaner.a.deleteClientFromCache((Integer)hashMap.get("cldbid"));
            if (inactiveClientsCleaner.a((Integer)hashMap.get("cldbid"))) {
                ++n;
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
        inactiveClientsCleaner.a.addLogEntry(inactiveClientsCleaner.a, (byte)1, "Deleted " + Integer.toString(n) + " inactive clients from the Teamspeak 3 database!", false);
    }
}

