/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BadNicknameCheck
implements HandleBotEvents,
HandleClientList,
HandleTS3Events,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private boolean b;
    private String b;
    private boolean c;
    private Vector a;
    private boolean d;
    private String c;
    private String d = null;
    private Vector b = null;
    private Vector c = null;
    private FunctionExceptionLog a = new Vector();

    public BadNicknameCheck() {
        this.b = new Vector();
        this.c = new Vector();
        this.a = new FunctionExceptionLog();
    }

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        String string = "Bad Nickname Check is enabled, " + Integer.toString(this.b.size()) + " rules loaded";
        if (this.c && this.b) {
            string = String.valueOf(string) + " (client will be kicked and a complaint will be added)";
        } else if (this.b) {
            string = String.valueOf(string) + " (client will be kicked)";
        } else if (this.c) {
            string = String.valueOf(string) + " (complaint will be added)";
        }
        this.a.addLogEntry(this.a, (byte)1, string, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.b = null;
        this.a = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_kick", "Kick client with a bad nickname? Set yes or no here!", "yes");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_add_complain", "Add complain entry to the user? Set yes or no here!", "no");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored and can have bad nicknames.\nonly = Only the selected server groups will be checked.", "ignore");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the client should get the message.\npoke or chat are valid values!\nIf client kick is activated, the message will be always used as kick message!", "poke");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the bad nickname message and check rules.", "%apphome%config/server1/badnickname.cfg");
        }
        if (this.a.getMySQLConnection() != null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "Set kick message for using a bad nickname.\nYou can use the following keywords, which will be replaced:\n%CLIENT_NAME% - Client Name\nYou can use \\n for a new line and typical BBCode like in Teamspeak 3 Client.");
        }
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter object, boolean bl) {
        String string = "";
        this.a = false;
        try {
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_kick", "yes").trim().equalsIgnoreCase("yes");
            this.d = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message_mode", "chat").trim();
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_file");
            if (!this.a((ArrangedPropertiesWriter)object)) {
                throw new BotConfigurationException("Bad Nickname Check rules could not be loaded!");
            }
            if (this.c == null || this.c.length() == 0) {
                throw new BotConfigurationException("Bad Nickname Check message could not be loaded!");
            }
            if (!this.a.isMessageLengthValid(this.b ? "kick" : this.d, this.c)) {
                this.a.addLogEntry(this.a, (byte)2, "Bad Nickname Check message is to long! Make sure that " + (this.b ? "kick" : this.d) + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.b ? "kick" : this.d)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.b : ""), true);
            }
            this.a.clear();
            Object object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list");
            string = String.valueOf(this.a) + "_group_list";
            if (object2 != null && ((String)object2).length() > 0) {
                object2 = new StringTokenizer((String)object2, ",", false);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    this.a.addElement(Integer.parseInt(((StringTokenizer)object2).nextToken().trim()));
                }
            }
            this.d = !((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.c = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_add_complain", "no").trim().equalsIgnoreCase("yes");
            if (this.b.size() == 0) {
                throw new BotConfigurationException("No bad nickname check rules was found! Config file: " + this.b);
            }
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            object = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + ((ArrangedPropertiesWriter)object).getValue(string, "not set"));
            ((Throwable)object).setStackTrace(numberFormatException.getStackTrace());
            throw object;
        }
        return this.a;
    }

    private boolean a(ArrangedPropertiesWriter object) {
        BufferedReader bufferedReader;
        block43: {
            if (this.a.getMySQLConnection() != null) {
                boolean bl;
                block42: {
                    MySQLConnect mySQLConnect = this.a.getMySQLConnection();
                    this.c = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message");
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        mySQLConnect.connect();
                        preparedStatement = mySQLConnect.getPreparedStatement("SELECT textentry FROM jts3servermod_badnickname WHERE instance_id = ? AND prefix = ?");
                        preparedStatement.setInt(1, this.a.getInstanceID());
                        preparedStatement.setString(2, this.a);
                        resultSet = preparedStatement.executeQuery();
                        this.b.clear();
                        while (resultSet.next()) {
                            this.b.addElement(Pattern.compile(resultSet.getString(1), 66));
                        }
                        bl = true;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.a.addLogEntry(this.a, (byte)3, "Found invalid Bad Nickname Check rules!", true);
                        this.a.addLogEntry(this.a, patternSyntaxException, true);
                        bl = false;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception) {}
                        mySQLConnect.close();
                        break block42;
                    }
                    catch (Exception exception) {
                        try {
                            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Bad Nickname Check rules!", true);
                            this.a.addLogEntry(this.a, exception, true);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception2) {}
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                            catch (Exception exception3) {}
                            mySQLConnect.close();
                            throw throwable;
                        }
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception4) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception5) {}
                        mySQLConnect.close();
                        break block42;
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {}
                    mySQLConnect.close();
                }
                return bl;
            }
            if (this.b == null) {
                this.a.addLogEntry(this.a, (byte)3, "Path to Bad Nickname Check config file was not set in bot config! Check config key: " + this.a + "_file", true);
                return false;
            }
            this.b = this.b.trim().replace("%apphome%", System.getProperty("app.home", ""));
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.b), this.a.getMessageEncoding()));
            this.b.clear();
            object = bufferedReader.readLine();
            if (this.a.getMessageEncoding().equalsIgnoreCase("UTF-8") && object != null && ((String)object).charAt(0) == '\ufeff') {
                object = ((String)object).substring(1);
            }
            if (object != null && ((String)object).equals("# JTS3ServerMod Config File")) break block43;
            this.a.addLogEntry(this.a, (byte)3, "Special config file header is missing at Bad Nickname Check config file! File path: " + this.b, true);
            this.a.addLogEntry(this.a, (byte)3, "Check if you set the right file at config key: " + this.a + "_file", true);
            bufferedReader.close();
            return false;
        }
        try {
            int n = 0;
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("#") || ((String)object).length() <= 3) continue;
                if (n == 0) {
                    this.c = object = ((String)object).replace("\\n", "\n");
                }
                if (n > 0) {
                    this.b.addElement(Pattern.compile((String)object, 66));
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.a.addLogEntry(this.a, (byte)3, "Bad Nickname Check config file you set at config key \"" + this.a + "_file\" does not exist or missing permission for reading, check file path: " + new File(this.b).getAbsolutePath(), true);
            return false;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.a.addLogEntry(this.a, (byte)3, "Found invalid Bad Nickname Check rules, check rules in file: " + this.b, true);
            this.a.addLogEntry(this.a, patternSyntaxException, true);
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Bad Nickname Check config file! Check file you set at config key \"" + this.a + "_file\", the file path: " + this.b, true);
            this.a.addLogEntry(this.a, exception, true);
            return false;
        }
        return true;
    }

    @Override
    public void setListModes(BitSet bitSet) {
        bitSet.set(1);
    }

    @Override
    public String[] botChatCommandList(HashMap stringArray, boolean bl, boolean bl2) {
        if (!this.a) {
            return null;
        }
        if (bl || bl2) {
            stringArray = new String[]{"findrule <name>"};
            return stringArray;
        }
        return null;
    }

    @Override
    public String botChatCommandHelp(String string) {
        if (string.equalsIgnoreCase("findrule")) {
            return "Check if the given name will be found by a bad name rule of this function and return the matching rules.";
        }
        return null;
    }

    @Override
    public boolean handleChatCommands(String string, HashMap hashMap, boolean bl, boolean bl2) {
        if (!this.a) {
            return false;
        }
        try {
            if (string.startsWith("findrule ")) {
                if (bl || bl2) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    bl2 = false;
                    string = string.substring(9);
                    try {
                        for (Pattern pattern : this.b) {
                            Matcher matcher = pattern.matcher(string);
                            if (!matcher.matches()) continue;
                            stringBuffer.append("\n" + pattern.toString());
                            bl2 += 1;
                        }
                    }
                    catch (Exception exception) {}
                    if (!bl2) {
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "No rule found for \"" + string + "\"!");
                    } else {
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "The following " + (bl2 ? String.valueOf(Integer.toString(bl2 ? 1 : 0)) + " rule" : String.valueOf(Integer.toString(bl2 ? 1 : 0)) + " rules") + " matching your text \"" + string + "\":");
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, stringBuffer.toString());
                    }
                } else {
                    this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "You are not my master!");
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, false);
            return true;
        }
    }

    @Override
    public void handleTS3Events(String string, HashMap hashMap) {
    }

    @Override
    public void handleClientCheck(Vector vector) {
        int n;
        if (!this.a) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            HashMap hashMap = (HashMap)vector.elementAt(n2);
            if (((String)hashMap.get("client_type")).equals("0") && (this.b || this.c.indexOf(hashMap.get("client_nickname")) < 0)) {
                n = Integer.parseInt((String)hashMap.get("clid"));
                boolean bl = this.a.isGroupListed((String)hashMap.get("client_servergroups"), this.a);
                if (this.d ? !bl : bl) {
                    for (Pattern pattern : this.b) {
                        Matcher matcher = pattern.matcher((CharSequence)hashMap.get("client_nickname"));
                        if (!matcher.matches()) continue;
                        if (this.c) {
                            try {
                                this.a.complainAdd(Integer.parseInt((String)hashMap.get("client_database_id")), "Bad Nickname: " + (String)hashMap.get("client_nickname"));
                                this.a.addLogEntry(this.a, (byte)1, "Added complaint to client with the bad nickname \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ")!", false);
                                this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                            }
                            catch (TS3ServerQueryException tS3ServerQueryException) {
                                if (!this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) {
                                    this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                    if (tS3ServerQueryException.getFailedPermissionID() >= 0) {
                                        this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client with the bad nickname \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ")!", false);
                                        this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                                    } else {
                                        this.a.addLogEntry(this.a, (byte)2, "Error while adding complaint to client with the bad nickname \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ")! Maybe the client already got a complaint from the bot?", false);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client with the bad nickname \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ")!", false);
                                this.a.addLogEntry(this.a, exception, false);
                            }
                        }
                        if (this.b) {
                            try {
                                this.a.kickClient(n, false, this.a((String)hashMap.get("client_nickname")));
                                vector.removeElementAt(n2);
                                --n2;
                                this.a.addLogEntry(this.a, (byte)1, "Client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") was kicked, nickname matched bad nickname rules!", false);
                                this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                            }
                            catch (TS3ServerQueryException tS3ServerQueryException) {
                                if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) continue;
                                this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                                this.a.addLogEntry(this.a, (byte)2, "Nickname of the client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") match a bad nickname rule, but kick is not possible because of an error!", false);
                                if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                                    this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                                    continue;
                                }
                                this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                            }
                            catch (Exception exception) {
                                this.a.addLogEntry(this.a, (byte)3, "Nickname of the client \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") match a bad nickname rule, but kick is not possible because of an error!", false);
                                this.a.addLogEntry(this.a, exception, false);
                            }
                            continue;
                        }
                        this.c.addElement((String)hashMap.get("client_nickname"));
                        this.a.sendMessageToClient(this.a, this.d, n, this.a((String)hashMap.get("client_nickname")));
                    }
                }
            }
            ++n2;
        }
        if (!this.b) {
            n = 0;
            while (n < this.c.size()) {
                n2 = 0;
                for (HashMap hashMap : vector) {
                    if (!((String)hashMap.get("client_nickname")).equals(this.c.elementAt(n))) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) {
                    this.c.removeElementAt(n);
                }
                ++n;
            }
        }
    }

    private String a(String string) {
        return this.c.replace("%CLIENT_NAME%", string);
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Bad Nickname Check function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

