/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import de.stefan1200.util.MySQLConnect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BadChannelNameCheck
implements HandleBotEvents,
HandleTS3Events,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private Vector a;
    private String b;
    private byte a = 1;
    private boolean b;
    private boolean c;
    private Vector b = new Vector();
    private boolean d;
    private String c;
    private String d = null;
    private Vector c = new Vector();

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        String string = "Bad Channel Name Check is enabled, " + Integer.toString(this.c.size()) + " rules loaded";
        string = this.a == 2 ? String.valueOf(string) + " and matching channel names will be deleted!" : (this.a == 1 ? String.valueOf(string) + " and matching channel names will be deleted, if rename is not possible!" : String.valueOf(string) + "!");
        this.a.addLogEntry(this.a, (byte)1, string, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.b = null;
        this.c = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_kick", "Instantly kick client that creates a channel with a bad name? Set yes or no here!", "no");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_delete", "Instantly delete a channel with a bad name? Set always, onlynew or no here!\nonlynew = Try to rename channel back first. Only if that fail (maybe channel is quite new and the old name is unknown) the channel will be deleted!\nno = Try to rename channel back, but the channel will not be deleted!", "onlynew");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nThis channels will be ignored!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_add_complain", "Add complain entry to the user? Set yes or no here!", "no");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored and can create channels with bad channel names.\nonly = Only the selected server groups will be checked.", "ignore");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the client should get the message.\npoke, chat or none are valid values!\nIf client kick is activated, the message will be always used as kick message!", "poke");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the Bad Channel Name Check rules and the message.", "%apphome%config/server1/badchannelname.cfg");
        }
        if (this.a.getMySQLConnection() != null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "Set message for using a bad channel name.\nYou can use the following keywords, which will be replaced:\n%CHANNEL_NAME% - Bad Channel Name\nYou can use \\n for a new line and typical BBCode like in Teamspeak 3 Client.");
        }
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter object, boolean bl) {
        this.a = false;
        String string = "";
        try {
            Object object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_delete", "yes").trim();
            this.a = ((String)object2).equalsIgnoreCase("yes") ? (byte)2 : (((String)object2).equalsIgnoreCase("onlynew") ? (byte)1 : 0);
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_kick", "yes").trim().equalsIgnoreCase("yes");
            this.d = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message_mode", "chat").trim();
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_file");
            if (!this.a((ArrangedPropertiesWriter)object)) {
                throw new BotConfigurationException("Bad Channel Name Check rules could not be loaded!");
            }
            if ((this.b || this.d.equalsIgnoreCase("chat") || this.d.equalsIgnoreCase("poke")) && !this.a.isMessageLengthValid(this.b ? "kick" : this.d, this.c)) {
                this.a.addLogEntry(this.a, (byte)2, "Bad Nickname Check message is to long! Make sure that " + (this.b ? "kick" : this.d) + " messages are not longer than " + Short.toString(this.a.getMaxMessageLength(this.b ? "kick" : this.d)) + " characters (including spaces and BBCode)" + (this.a.getMySQLConnection() == null ? ", check file: " + this.b : ""), true);
            }
            this.a.clear();
            object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_channel_list");
            string = String.valueOf(this.a) + "_channel_list";
            if (object2 != null && ((String)object2).length() > 0) {
                object2 = new StringTokenizer((String)object2, ",", false);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    this.a.addElement(Integer.parseInt(((StringTokenizer)object2).nextToken().trim()));
                }
            }
            this.b.clear();
            object2 = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list");
            string = String.valueOf(this.a) + "_group_list";
            if (object2 != null && ((String)object2).length() > 0) {
                object2 = new StringTokenizer((String)object2, ",", false);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    this.b.addElement(Integer.parseInt(((StringTokenizer)object2).nextToken().trim()));
                }
            }
            this.d = !((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.c = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_add_complain", "no").trim().equalsIgnoreCase("yes");
            if (this.c.size() == 0) {
                throw new BotConfigurationException("No bad channel name rules was found! Please check configuration.");
            }
            this.a.addTS3ChannelEvent(this);
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            object = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + ((ArrangedPropertiesWriter)object).getValue(string, "not set"));
            ((Throwable)object).setStackTrace(numberFormatException.getStackTrace());
            throw object;
        }
        return this.a;
    }

    private boolean a(ArrangedPropertiesWriter object) {
        BufferedReader bufferedReader;
        block43: {
            if (this.a.getMySQLConnection() != null) {
                boolean bl;
                block42: {
                    MySQLConnect mySQLConnect = this.a.getMySQLConnection();
                    this.c = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message");
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        mySQLConnect.connect();
                        preparedStatement = mySQLConnect.getPreparedStatement("SELECT textentry FROM jts3servermod_badchannelname WHERE instance_id = ? AND prefix = ?");
                        preparedStatement.setInt(1, this.a.getInstanceID());
                        preparedStatement.setString(2, this.a);
                        resultSet = preparedStatement.executeQuery();
                        this.c.clear();
                        while (resultSet.next()) {
                            this.c.addElement(Pattern.compile(resultSet.getString(1), 66));
                        }
                        bl = true;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.a.addLogEntry(this.a, (byte)3, "Found invalid Bad Channel Name Check rules!", true);
                        this.a.addLogEntry(this.a, patternSyntaxException, true);
                        bl = false;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception) {}
                        mySQLConnect.close();
                        break block42;
                    }
                    catch (Exception exception) {
                        try {
                            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Bad Channel Name Check rules!", true);
                            this.a.addLogEntry(this.a, exception, true);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception2) {}
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                            }
                            catch (Exception exception3) {}
                            mySQLConnect.close();
                            throw throwable;
                        }
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (Exception exception4) {}
                        try {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        catch (Exception exception5) {}
                        mySQLConnect.close();
                        break block42;
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    catch (Exception exception) {}
                    mySQLConnect.close();
                }
                return bl;
            }
            if (this.b == null) {
                this.a.addLogEntry(this.a, (byte)3, "Path to Bad Channel Name Check config file was not set in bot config! Check config key: " + this.a + "_file", true);
                return false;
            }
            this.b = this.b.trim().replace("%apphome%", System.getProperty("app.home", ""));
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.b), this.a.getMessageEncoding()));
            this.c.clear();
            object = bufferedReader.readLine();
            if (this.a.getMessageEncoding().equalsIgnoreCase("UTF-8") && object != null && ((String)object).charAt(0) == '\ufeff') {
                object = ((String)object).substring(1);
            }
            if (object != null && ((String)object).equals("# JTS3ServerMod Config File")) break block43;
            this.a.addLogEntry(this.a, (byte)3, "Special config file header is missing at Bad Channel Name Check config file! File path: " + this.b, true);
            this.a.addLogEntry(this.a, (byte)3, "Check if you set the right file at config key: " + this.a + "_file", true);
            bufferedReader.close();
            return false;
        }
        try {
            int n = 0;
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).startsWith("#") || ((String)object).length() <= 3) continue;
                if (n == 0) {
                    this.c = object = ((String)object).replace("\\n", "\n");
                }
                if (n > 0) {
                    this.c.addElement(Pattern.compile((String)object, 66));
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.a.addLogEntry(this.a, (byte)3, "Bad Channel Name Check config file you set at config key \"" + this.a + "_file\" does not exist or missing permission for reading, check file: " + new File(this.b).getAbsolutePath(), true);
            return false;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.a.addLogEntry(this.a, (byte)3, "Found invalid Bad Channel Name Check rules, check rules in file: " + this.b, true);
            this.a.addLogEntry(this.a, patternSyntaxException, true);
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, (byte)3, "Unknown error while loading Bad Channel Name Check config file! Check file you set at config key \"" + this.a + "_file\", the file path: " + this.b, true);
            this.a.addLogEntry(this.a, exception, true);
            return false;
        }
        return true;
    }

    @Override
    public void setListModes(BitSet bitSet) {
        bitSet.set(1);
    }

    @Override
    public String[] botChatCommandList(HashMap stringArray, boolean bl, boolean bl2) {
        if (!this.a) {
            return null;
        }
        if (bl || bl2) {
            stringArray = new String[]{"check", "findrule <name>"};
            return stringArray;
        }
        return null;
    }

    @Override
    public String botChatCommandHelp(String string) {
        if (string.equalsIgnoreCase("check")) {
            return "Display a list of current channels with bad names (because this function don't see channel name changes, if bot was offline).";
        }
        if (string.equalsIgnoreCase("findrule")) {
            return "Check if the given name will be found by a bad name rule of this function and return the matching rules.";
        }
        return null;
    }

    @Override
    public boolean handleChatCommands(String string, HashMap hashMap, boolean bl, boolean bl2) {
        block20: {
            if (!this.a) {
                return false;
            }
            if (!string.equalsIgnoreCase("check")) break block20;
            if (bl || bl2) {
                StringBuffer stringBuffer = new StringBuffer("");
                bl2 = false;
                Object object = this.a.getChannelList();
                object = ((Vector)object).iterator();
                while (object.hasNext()) {
                    HashMap hashMap2 = (HashMap)object.next();
                    try {
                        int n = Integer.parseInt((String)hashMap2.get("cid"));
                        if (this.a.isIDListed(n, this.a)) continue;
                        for (Pattern pattern : this.c) {
                            Matcher matcher = pattern.matcher((CharSequence)hashMap2.get("channel_name"));
                            if (!matcher.matches()) continue;
                            stringBuffer.append("\n" + (String)hashMap2.get("channel_name") + " (id: " + (String)hashMap2.get("cid") + ")");
                            bl2 += 1;
                        }
                    }
                    catch (Exception exception) {}
                }
                if (!bl2) {
                    this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "No bad channel names found!");
                } else {
                    this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "Found " + Integer.toString(bl2 ? 1 : 0) + " channels with bad names!\nYou can use the following command to rename that channels: !setchannelname <channel id> <new channel name>");
                    this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, stringBuffer.toString());
                }
            } else {
                this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "You are not my master!");
            }
            return true;
        }
        try {
            if (string.startsWith("findrule ")) {
                if (bl || bl2) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    bl2 = false;
                    string = string.substring(9);
                    try {
                        for (Pattern pattern : this.c) {
                            Matcher matcher = pattern.matcher(string);
                            if (!matcher.matches()) continue;
                            stringBuffer.append("\n" + pattern.toString());
                            bl2 += 1;
                        }
                    }
                    catch (Exception exception) {}
                    if (!bl2) {
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "No rule found for \"" + string + "\"!");
                    } else {
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "The following " + (bl2 ? String.valueOf(Integer.toString(bl2 ? 1 : 0)) + " rule" : String.valueOf(Integer.toString(bl2 ? 1 : 0)) + " rules") + " matching your text \"" + string + "\":");
                        this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, stringBuffer.toString());
                    }
                } else {
                    this.a.sendTextMessage(Integer.parseInt((String)hashMap.get("invokerid")), 1, "You are not my master!");
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.a.addLogEntry(this.a, exception, false);
            return true;
        }
    }

    @Override
    public void handleTS3Events(String string, HashMap hashMap) {
        int n;
        if (!this.a) {
            return;
        }
        if ((string.equals("notifychannelcreated") || string.equals("notifychanneledited")) && hashMap.get("channel_name") != null && !this.a.isIDListed(n = Integer.parseInt((String)hashMap.get("cid")), this.a)) {
            for (Object object : this.c) {
                boolean bl;
                boolean bl2;
                String string2;
                block24: {
                    HashMap hashMap2;
                    String string3;
                    if (!((Matcher)(object = ((Pattern)object).matcher((CharSequence)hashMap.get("channel_name")))).matches()) continue;
                    int n2 = Integer.parseInt((String)hashMap.get("invokerid"));
                    int n3 = 0;
                    string2 = "";
                    String string4 = "";
                    Object object2 = this.a.getClientList();
                    object2 = ((Vector)object2).iterator();
                    while (object2.hasNext()) {
                        HashMap hashMap3 = (HashMap)object2.next();
                        if (!((String)hashMap3.get("clid")).equals(hashMap.get("invokerid"))) continue;
                        string2 = (String)hashMap3.get("client_database_id");
                        string4 = (String)hashMap3.get("client_servergroups");
                        try {
                            n3 = Integer.parseInt((String)hashMap3.get("client_type"));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    boolean bl3 = this.a.isGroupListed(string4, this.b);
                    if (!(this.d ? !bl3 : bl3)) continue;
                    bl2 = false;
                    bl = false;
                    if (this.a != 2 && string.equals("notifychanneledited") && (string3 = this.a.getChannelName(n)) != null && !string3.equalsIgnoreCase((String)hashMap.get("channel_name")) && ((String)(hashMap2 = this.a.doCommand("channeledit cid=" + Integer.toString(n) + " channel_name=" + this.a.encodeTS3String(string3))).get("id")).equals("0")) {
                        this.a.addLogEntry(this.a, (byte)1, "Channel created by \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ") was renamed back to last saved name \"" + string3 + "\", bad channel name: " + (String)hashMap.get("channel_name"), false);
                        bl2 = true;
                    }
                    if (this.a == 2 || !bl2 && this.a == 1) {
                        try {
                            this.a.deleteChannel(n, true);
                            bl = true;
                            this.a.removeChannelListEntry(n);
                            this.a.addLogEntry(this.a, (byte)1, "Channel created by \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ") was deleted, channel name: " + (String)hashMap.get("channel_name"), false);
                        }
                        catch (Exception exception) {
                            this.a.addLogEntry(this.a, (byte)3, "Can't delete channel \"" + (String)hashMap.get("channel_name") + "\" (id: " + Integer.toString(n) + ") created by \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ")!", false);
                            this.a.addLogEntry(this.a, exception, false);
                        }
                    }
                    if (this.c) {
                        try {
                            this.a.complainAdd(Integer.parseInt(string2), "Created channel with bad name: " + (String)hashMap.get("channel_name"));
                            this.a.addLogEntry(this.a, (byte)1, "Added complaint to client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + "), reason: Created a channel with the bad name: " + (String)hashMap.get("channel_name"), false);
                        }
                        catch (TS3ServerQueryException tS3ServerQueryException) {
                            TS3ServerQueryException tS3ServerQueryException2 = tS3ServerQueryException;
                            if (tS3ServerQueryException.getFailedPermissionID() >= 0) {
                                this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + "), reason: Created a channel with the bad name: " + (String)hashMap.get("channel_name"), false);
                                this.a.addLogEntry(this.a, tS3ServerQueryException2, false);
                            } else {
                                this.a.addLogEntry(this.a, (byte)2, "Error while adding complaint to client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + "), reason: Created a channel with the bad name: " + (String)hashMap.get("channel_name") + "! Maybe the client already got a complaint from the bot?", false);
                            }
                        }
                        catch (Exception exception) {
                            this.a.addLogEntry(this.a, (byte)3, "Error while adding complaint to client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + "), reason: Created a channel with the bad name: " + (String)hashMap.get("channel_name"), false);
                            this.a.addLogEntry(this.a, exception, false);
                        }
                    }
                    if (this.b) {
                        try {
                            this.a.kickClient(n2, false, this.a((String)hashMap.get("channel_name")));
                            this.a.removeClientListEntry(n2);
                            this.a.addLogEntry(this.a, (byte)1, "Client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ") was kicked, channel name \"" + (String)hashMap.get("channel_name") + "\" matched bad channel name rules!", false);
                        }
                        catch (TS3ServerQueryException tS3ServerQueryException) {
                            this.a.addLogEntry(this.a, (byte)2, "Can't kick client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ") for using the bad channel name: " + (String)hashMap.get("channel_name"), false);
                            if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                                this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                                break block24;
                            }
                            this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                        }
                        catch (Exception exception) {
                            this.a.addLogEntry(this.a, (byte)3, "Can't kick client \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + ") for using the bad channel name: " + (String)hashMap.get("channel_name"), false);
                            this.a.addLogEntry(this.a, exception, false);
                        }
                    } else if ((this.d.equals("poke") || this.d.equals("chat")) && n3 == 0) {
                        this.a.sendMessageToClient(this.a, this.d, n2, this.a((String)hashMap.get("channel_name")));
                    }
                }
                if (!(bl2 || this.a != 0 || this.c || this.b)) {
                    this.a.addLogEntry(this.a, (byte)2, "Channel created by \"" + (String)hashMap.get("invokername") + "\" (db id: " + string2 + "), channel name: " + (String)hashMap.get("channel_name"), false);
                }
                if (bl2 || bl) break;
            }
        }
    }

    private String a(String string) {
        return this.c.replace("%CHANNEL_NAME%", string);
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Bad Channel Name Check function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

