/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;

public class XDH
implements com.jcraft.jsch.XDH {
    byte[] Q_array;
    Object privateKey;
    int keylen;
    String name;

    @Override
    public void init(String name, int keylen) throws Exception {
        if (!name.equals("X25519") && !name.equals("X448")) {
            throw new NoSuchAlgorithmException("invalid curve " + name);
        }
        this.keylen = keylen;
        this.name = name;
        if (name.equals("X25519")) {
            X25519PrivateKeyParameters privateKey = new X25519PrivateKeyParameters(new SecureRandom());
            this.Q_array = privateKey.generatePublicKey().getEncoded();
            this.privateKey = privateKey;
        } else {
            X448PrivateKeyParameters privateKey = new X448PrivateKeyParameters(new SecureRandom());
            this.Q_array = privateKey.generatePublicKey().getEncoded();
            this.privateKey = privateKey;
        }
    }

    @Override
    public byte[] getQ() throws Exception {
        return this.Q_array;
    }

    @Override
    public byte[] getSecret(byte[] Q) throws Exception {
        byte[] secret = new byte[this.keylen];
        if (this.name.equals("X25519")) {
            X25519PublicKeyParameters publicKey = null;
            try {
                publicKey = new X25519PublicKeyParameters(Q, 0);
            }
            catch (Exception e2) {
                throw new InvalidKeyException(e2);
            }
            X25519PrivateKeyParameters privateKey = (X25519PrivateKeyParameters)this.privateKey;
            try {
                privateKey.generateSecret(publicKey, secret, 0);
            }
            catch (Exception e3) {
                throw new IllegalStateException(e3);
            }
        }
        X448PublicKeyParameters publicKey = null;
        try {
            publicKey = new X448PublicKeyParameters(Q, 0);
        }
        catch (Exception e4) {
            throw new InvalidKeyException(e4);
        }
        X448PrivateKeyParameters privateKey = (X448PrivateKeyParameters)this.privateKey;
        try {
            privateKey.generateSecret(publicKey, secret, 0);
        }
        catch (Exception e5) {
            throw new IllegalStateException(e5);
        }
        return secret;
    }

    @Override
    public boolean validate(byte[] u) throws Exception {
        return u.length == this.keylen;
    }
}

