/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.bc;

import com.jcraft.jsch.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class CAST128CBC
implements Cipher {
    private static final int ivsize = 8;
    private static final int bsize = 16;
    private BufferedBlockCipher cipher;

    @Override
    public int getIVSize() {
        return 8;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int getTagSize() {
        return 0;
    }

    @Override
    public void init(int mode, byte[] key, byte[] iv) throws Exception {
        byte[] tmp;
        if (iv.length > 8) {
            tmp = new byte[8];
            System.arraycopy(iv, 0, tmp, 0, tmp.length);
            iv = tmp;
        }
        if (key.length > 16) {
            tmp = new byte[16];
            System.arraycopy(key, 0, tmp, 0, tmp.length);
            key = tmp;
        }
        try {
            ParametersWithIV keyspec = new ParametersWithIV((CipherParameters)new KeyParameter(key, 0, key.length), iv, 0, iv.length);
            this.cipher = new BufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new CAST5Engine()));
            this.cipher.init(mode == 0, (CipherParameters)keyspec);
        }
        catch (Exception e2) {
            this.cipher = null;
            throw e2;
        }
    }

    @Override
    public void update(int foo) throws Exception {
    }

    @Override
    public void update(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
        this.cipher.processBytes(foo, s1, len, bar, s2);
    }

    @Override
    public void updateAAD(byte[] foo, int s1, int len) throws Exception {
    }

    @Override
    public void doFinal(byte[] foo, int s1, int len, byte[] bar, int s2) throws Exception {
    }

    @Override
    public boolean isCBC() {
        return true;
    }

    @Override
    public boolean isAEAD() {
        return false;
    }

    @Override
    public boolean isChaCha20() {
        return false;
    }
}

