/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JUnixSocketFactory;
import com.jcraft.jsch.USocketFactory;
import com.jcraft.jsch.UnixDomainSocketFactory;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SSHAgentConnector
implements AgentConnector {
    private static final int MAX_AGENT_REPLY_LEN = 262144;
    private USocketFactory factory;
    private Path usocketPath;

    public SSHAgentConnector() throws AgentProxyException {
        this(SSHAgentConnector.getUSocketFactory(), SSHAgentConnector.getSshAuthSocket());
    }

    public SSHAgentConnector(Path usocketPath) throws AgentProxyException {
        this(SSHAgentConnector.getUSocketFactory(), usocketPath);
    }

    public SSHAgentConnector(USocketFactory factory) throws AgentProxyException {
        this(factory, SSHAgentConnector.getSshAuthSocket());
    }

    public SSHAgentConnector(USocketFactory factory, Path usocketPath) {
        this.factory = factory;
        this.usocketPath = usocketPath;
    }

    @Override
    public String getName() {
        return "ssh-agent";
    }

    @Override
    public boolean isAvailable() {
        boolean bl;
        block8: {
            SocketChannel foo = this.open();
            try {
                bl = true;
                if (foo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (foo != null) {
                        try {
                            foo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return false;
                }
            }
            foo.close();
        }
        return bl;
    }

    private SocketChannel open() throws IOException {
        return this.factory.connect(this.usocketPath);
    }

    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        try (SocketChannel sock = this.open();){
            SSHAgentConnector.writeFull(sock, buffer, 0, buffer.getLength());
            buffer.rewind();
            int i2 = SSHAgentConnector.readFull(sock, buffer, 0, 4);
            i2 = buffer.getInt();
            if (i2 <= 0 || i2 > 262144) {
                throw new AgentProxyException("Illegal length: " + i2);
            }
            buffer.rewind();
            buffer.checkFreeSize(i2);
            int n = SSHAgentConnector.readFull(sock, buffer, 0, i2);
        }
        catch (IOException e2) {
            throw new AgentProxyException(e2.toString(), e2);
        }
    }

    private static USocketFactory getUSocketFactory() throws AgentProxyException {
        try {
            return new UnixDomainSocketFactory();
        }
        catch (AgentProxyException e2) {
            try {
                return new JUnixSocketFactory();
            }
            catch (NoClassDefFoundError ee) {
                AgentProxyException eee = new AgentProxyException("junixsocket library unavailable");
                eee.addSuppressed(e2);
                eee.addSuppressed(ee);
                throw eee;
            }
            catch (AgentProxyException ee) {
                ee.addSuppressed(e2);
                throw e2;
            }
        }
    }

    private static Path getSshAuthSocket() throws AgentProxyException {
        String ssh_auth_sock = Util.getSystemEnv("SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            throw new AgentProxyException("SSH_AUTH_SOCK is not defined.");
        }
        return Paths.get(ssh_auth_sock, new String[0]);
    }

    private static int readFull(SocketChannel sock, Buffer buffer, int s, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buffer.buffer, s, len);
        int _len = len;
        while (len > 0) {
            int j2 = sock.read(bb);
            if (j2 < 0) {
                return -1;
            }
            if (j2 <= 0) continue;
            len -= j2;
        }
        return _len;
    }

    private static int writeFull(SocketChannel sock, Buffer buffer, int s, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buffer.buffer, s, len);
        int _len = len;
        while (len > 0) {
            int j2 = sock.write(bb);
            if (j2 < 0) {
                return -1;
            }
            if (j2 <= 0) continue;
            len -= j2;
        }
        return _len;
    }
}

