/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.examplefunctions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.HandleTS3Events;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoKickTimer
implements HandleBotEvents,
LoadConfiguration,
HandleClientList,
HandleTS3Events {
    private String configPrefix = "";
    private JTS3ServerMod_Interface modClass = null;
    private JTS3ServerQuery queryLib = null;
    private boolean pluginEnabled = false;
    private int kickTime = -1;
    private String messageFile = null;
    private String message = null;
    private String customMessage = null;
    private Vector<Integer> groupList = new Vector();
    private boolean groupListIgnore = true;
    private TimerTask timerAutoKick;
    private boolean kickNow = false;
    private long timeLastKickNow = 0L;
    private boolean firstInit = true;
    private HashMap<Integer, Long> clientConnectedTime = new HashMap();
    private FunctionExceptionLog fel = new FunctionExceptionLog();

    public static void main(String[] args) {
    }

    public void initClass(JTS3ServerMod_Interface modClass, JTS3ServerQuery queryLib, String prefix) {
        this.modClass = modClass;
        this.queryLib = queryLib;
        this.configPrefix = prefix.trim();
    }

    public void handleOnBotConnect() {
        if (!this.pluginEnabled) {
            return;
        }
        String msg = "";
        StringBuffer sGroupList = new StringBuffer();
        for (int groupID : this.groupList) {
            if (sGroupList.length() != 0) {
                sGroupList.append(", ");
            }
            sGroupList.append(groupID);
        }
        msg = sGroupList.length() == 0 ? "After " + Integer.toString(this.kickTime) + " minutes online time all clients will be kicked!" : "After " + Integer.toString(this.kickTime) + " minutes all clients " + (this.groupListIgnore ? "except members " : "") + "of the following server groups will be kicked: " + sGroupList.toString();
        this.modClass.addLogEntry(this.configPrefix, (byte)1, msg, true);
    }

    public void handleAfterCacheUpdate() {
        if (!this.pluginEnabled) {
            return;
        }
    }

    public void activate() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timerAutoKick != null) {
            this.timerAutoKick.cancel();
        }
        this.timerAutoKick = null;
        this.timerAutoKick = new TimerTask(){

            public void run() {
                AutoKickTimer.this.kickNow = true;
            }
        };
        this.modClass.addBotTimer(this.timerAutoKick, 60000L, 60000L);
        this.timeLastKickNow = System.currentTimeMillis();
    }

    public void disable() {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.timerAutoKick != null) {
            this.timerAutoKick.cancel();
        }
        this.timerAutoKick = null;
        this.kickNow = false;
    }

    public void unload() {
        this.customMessage = null;
        this.message = null;
        this.messageFile = null;
        this.clientConnectedTime = null;
        this.groupList = null;
    }

    public boolean multipleInstances() {
        return false;
    }

    public int getAPIBuild() {
        return 4;
    }

    public String getCopyright() {
        return "Auto Kick Timer function v1.2 (30.04.2016) created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }

    public void initConfig(ArrangedPropertiesWriter config) {
        config.addKey(String.valueOf(this.configPrefix) + "_time", "After how many minutes all clients should be kicked?", "5");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        config.addKey(String.valueOf(this.configPrefix) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
        if (this.modClass.getMySQLConnection() == null) {
            config.addKey(String.valueOf(this.configPrefix) + "_file", "Path to file which contains the Auto Kick Timer message.", "%apphome%config/server1/autokicktimermessages.cfg");
        }
        config.addKey(String.valueOf(this.configPrefix) + "_message", "Auto Kick Timer message, the client get this message as kick message.\nYou can use the following keywords, which will be replaced:\n%AUTO_KICK_TIME% - This will be replaced with the auto kick time in minutes\nOnly 80 characters are possible for kick messages!", this.modClass.getMySQLConnection() != null);
    }

    public boolean loadConfig(ArrangedPropertiesWriter config, boolean slowMode) throws BotConfigurationException, NumberFormatException {
        String lastNumberValue = "";
        String temp = null;
        this.pluginEnabled = false;
        try {
            temp = null;
            this.groupList.clear();
            temp = config.getValue(String.valueOf(this.configPrefix) + "_group_list");
            lastNumberValue = String.valueOf(this.configPrefix) + "_group_list";
            if (temp != null && temp.length() > 0) {
                StringTokenizer st = new StringTokenizer(temp, ",", false);
                while (st.hasMoreTokens()) {
                    this.groupList.addElement(Integer.parseInt(st.nextToken().trim()));
                }
            }
            this.groupListIgnore = !config.getValue(String.valueOf(this.configPrefix) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            lastNumberValue = String.valueOf(this.configPrefix) + "_time";
            temp = config.getValue(String.valueOf(this.configPrefix) + "_time");
            if (temp == null) {
                throw new NumberFormatException();
            }
            this.kickTime = Integer.parseInt(temp.trim());
            if (this.kickTime < 1) {
                this.kickTime = 1;
            }
            this.messageFile = config.getValue(String.valueOf(this.configPrefix) + "_file");
            String[] configKeys = new String[]{String.valueOf(this.configPrefix) + "_message"};
            if (!this.modClass.loadMessages(this.configPrefix, "_file", configKeys)) {
                throw new BotConfigurationException("Auto Kick Timer message could not be loaded!");
            }
            this.message = config.getValue(configKeys[0]);
            if (this.message == null || this.message.length() == 0) {
                throw new BotConfigurationException("Auto Kick Timer message missing in config!");
            }
            this.createMessage();
            this.pluginEnabled = true;
        }
        catch (NumberFormatException e) {
            NumberFormatException nfe = new NumberFormatException("Config value of \"" + lastNumberValue + "\" is not a number! Current value: " + config.getValue(lastNumberValue, "not set"));
            nfe.setStackTrace(e.getStackTrace());
            throw nfe;
        }
        return this.pluginEnabled;
    }

    public void setListModes(BitSet listOptions) {
        listOptions.set(1);
        listOptions.set(3);
    }

    public void handleClientCheck(Vector<HashMap<String, String>> clientList) {
        if (!this.pluginEnabled) {
            return;
        }
        if (this.firstInit) {
            this.firstInit = false;
            for (HashMap<String, String> clientInfo : clientList) {
                int clientID;
                if (!clientInfo.get("client_type").equals("0") || this.clientConnectedTime.containsKey(clientID = Integer.parseInt(clientInfo.get("clid")))) continue;
                try {
                    HashMap fullClientInfo = this.queryLib.getInfo(13, clientID);
                    this.clientConnectedTime.put(clientID, System.currentTimeMillis() - Long.parseLong((String)fullClientInfo.get("connection_connected_time")));
                }
                catch (Exception e) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)1, "Error while requesting connection time from TS3 server for client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ")!", false);
                    this.modClass.addLogEntry(this.configPrefix, (Throwable)e, false);
                }
            }
        }
        if (this.kickNow) {
            this.kickNow = false;
            for (HashMap<String, String> clientInfo : clientList) {
                long diff;
                int clientID;
                if (!clientInfo.get("client_type").equals("0") || !this.clientConnectedTime.containsKey(clientID = Integer.parseInt(clientInfo.get("clid")))) continue;
                boolean result = this.modClass.isGroupListed(clientInfo.get("client_servergroups"), this.groupList);
                if (!(this.groupListIgnore ? !result : result) || (diff = System.currentTimeMillis() - this.clientConnectedTime.get(clientID)) <= (long)(this.kickTime * 60 * 1000)) continue;
                this.kickClient(clientInfo, this.customMessage, clientID);
            }
            this.timeLastKickNow = System.currentTimeMillis();
        }
    }

    private void kickClient(HashMap<String, String> clientInfo, String kickMSG, int clientID) {
        try {
            this.queryLib.kickClient(clientID, false, kickMSG);
            this.modClass.addLogEntry(this.configPrefix, (byte)1, "Client \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") was online to long, client was kicked!", false);
            this.fel.clearException(Integer.parseInt(clientInfo.get("client_database_id")));
        }
        catch (TS3ServerQueryException sqe) {
            if (!this.fel.existsException(sqe, Integer.parseInt(clientInfo.get("client_database_id")))) {
                this.fel.addException(sqe, Integer.parseInt(clientInfo.get("client_database_id")));
                this.modClass.addLogEntry(this.configPrefix, (byte)2, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is online to long, but an error occurred while kicking client!", false);
                if (sqe.getFailedPermissionID() < 0) {
                    this.modClass.addLogEntry(this.configPrefix, (byte)2, sqe.toString(), false);
                } else {
                    this.modClass.addLogEntry(this.configPrefix, (Throwable)sqe, false);
                }
            }
        }
        catch (Exception e) {
            this.modClass.addLogEntry(this.configPrefix, (byte)3, "Client status of \"" + clientInfo.get("client_nickname") + "\" (db id: " + clientInfo.get("client_database_id") + ") is online to long, but an error occurred while kicking client!", false);
            this.modClass.addLogEntry(this.configPrefix, (Throwable)e, false);
        }
    }

    private void createMessage() {
        this.customMessage = new String(this.message);
        this.customMessage = this.customMessage.replace("%AUTO_KICK_TIME%", Integer.toString(this.kickTime));
        if (!this.modClass.isMessageLengthValid("kick", this.customMessage)) {
            this.modClass.addLogEntry(this.configPrefix, (byte)2, "Auto Kick Timer message is to long! Make sure that kick messages are not longer than " + Short.toString(this.modClass.getMaxMessageLength("kick")) + " characters (including spaces and BBCode)" + (this.modClass.getMySQLConnection() == null ? ", check file: " + this.messageFile : ""), true);
        }
    }

    public String[] botChatCommandList(HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        if (!this.pluginEnabled) {
            return null;
        }
        String[] commands = new String[]{"time"};
        return commands;
    }

    public String botChatCommandHelp(String command) {
        if (command.equalsIgnoreCase("time") || command.equalsIgnoreCase("timeleft")) {
            return "Displays your current online time and how much time you have left.";
        }
        return null;
    }

    public boolean handleChatCommands(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin) {
        if (!this.pluginEnabled) {
            return false;
        }
        if (msg.equalsIgnoreCase("time") || msg.equalsIgnoreCase("timeleft")) {
            String message = null;
            Vector clientList = this.modClass.getClientList();
            for (HashMap clientInfo : clientList) {
                if (!((String)clientInfo.get("clid")).equals(eventInfo.get("invokerid")) || !((String)clientInfo.get("client_type")).equals("0")) continue;
                int clientID = Integer.parseInt(eventInfo.get("invokerid"));
                boolean result = this.modClass.isGroupListed((String)clientInfo.get("client_servergroups"), this.groupList);
                if (this.groupListIgnore ? !result : result) {
                    long diff = System.currentTimeMillis() - this.clientConnectedTime.get(clientID);
                    long kickTimeFromNow = (long)(this.kickTime * 60 * 1000) - diff;
                    long newKickTime = 0L;
                    if (kickTimeFromNow < 0L) {
                        newKickTime = this.timeLastKickNow + 60000L;
                    } else {
                        int minutes = (int)Math.ceil((double)kickTimeFromNow / 60000.0);
                        newKickTime = this.timeLastKickNow + (long)(minutes * 60000);
                        long diff2 = newKickTime - this.clientConnectedTime.get(clientID);
                        if (diff2 < (long)(this.kickTime * 60 * 1000)) {
                            newKickTime += 60000L;
                        }
                    }
                    message = "You are already connected since " + this.modClass.getDifferenceTime(this.clientConnectedTime.get(clientID).longValue(), System.currentTimeMillis()) + ". You will be kicked in " + this.modClass.getDifferenceTime(System.currentTimeMillis(), newKickTime) + ".";
                } else {
                    message = "You are already connected since " + this.modClass.getDifferenceTime(this.clientConnectedTime.get(clientID).longValue(), System.currentTimeMillis()) + ". You will not be kicked, because you are not in the affected server group!";
                }
                try {
                    this.queryLib.sendTextMessage(clientID, 1, message);
                    this.fel.clearException(Integer.parseInt((String)clientInfo.get("client_database_id")));
                }
                catch (TS3ServerQueryException sqe) {
                    if (this.fel.existsException(sqe, Integer.parseInt((String)clientInfo.get("client_database_id")))) break;
                    this.fel.addException(sqe, Integer.parseInt((String)clientInfo.get("client_database_id")));
                    this.modClass.addLogEntry(this.configPrefix, (byte)3, "Cannot send chat command answer to client \"" + (String)clientInfo.get("client_nickname") + "\" (db id: " + (String)clientInfo.get("client_database_id") + "), an error occurred while sending message to client!", false);
                    this.modClass.addLogEntry(this.configPrefix, (Throwable)sqe, false);
                }
                break;
            }
            return true;
        }
        return false;
    }

    public void handleTS3Events(String eventType, HashMap<String, String> eventInfo) {
        if (eventType.equalsIgnoreCase("notifycliententerview")) {
            try {
                if (eventInfo.get("client_type").equals("0")) {
                    this.clientConnectedTime.put(Integer.parseInt(eventInfo.get("clid")), System.currentTimeMillis());
                }
            }
            catch (Exception exception) {}
        } else if (eventType.equalsIgnoreCase("notifyclientleftview")) {
            this.clientConnectedTime.remove(Integer.parseInt(eventInfo.get("clid")));
        }
    }
}

