package de.stefan1200.jts3servermod.interfaces;

/**
 * Interface of the ServerInfoCache class, which allows you to access the ServerInfoCache methods.<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public interface ServerInfoCache_Interface
{
	/**
	 * Returns the current server name of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current server name.
	 */
	public abstract String getServerName();

	/**
	 * Returns the current Teamspeak 3 server version of the connected server!
	 * @return The current server version.
	 */
	public abstract String getServerVersion();

	/**
	 * Returns the current Teamspeak 3 server platform of the connected server!
	 * @return The current server platform (e.g. Linux, Windows, Mac).
	 */
	public abstract String getServerPlatform();

	/**
	 * Returns the current server uptime of the connected server!
	 * @return Time in milliseconds where the current server was started.
	 */
	public abstract long getServerUptime();

	/**
	 * Returns the server uptime timestamp of the connected server!
	 * @return Timestamp in milliseconds where the current server was started.
	 */
	public abstract long getServerUptimeTimestamp();

	/**
	 * Returns the server creation timestamp of the connected server!
	 * @return Timestamp in milliseconds where the current server was created.
	 */
	public abstract long getServerCreatedAt();

	/**
	 * Returns the current total bytes downloaded value of the connected server for the month!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current total bytes downloaded value for the month.
	 */
	public abstract long getServerMonthBytesDownloaded();

	/**
	 * Returns the current total bytes uploaded value of the connected server for the month!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current total bytes uploaded value for the month.
	 */
	public abstract long getServerMonthBytesUploaded();

	/**
	 * Returns the current total bytes downloaded value of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current total bytes downloaded value.
	 */
	public abstract long getServerTotalBytesDownloaded();

	/**
	 * Returns the current total bytes uploaded value of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current total bytes uploaded value.
	 */
	public abstract long getServerTotalBytesUploaded();

	/**
	 * Returns the current max clients count of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current max clients count.
	 */
	public abstract int getServerMaxClients();

	/**
	 * Returns the current reserved slots count of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current reserved slots count.
	 */
	public abstract int getServerReservedSlots();

	/**
	 * Returns the current channel count of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current channel count.
	 */
	public abstract int getServerChannelCount();

	/**
	 * Returns the current client count of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The current client count without query clients.
	 */
	public abstract int getServerClientCount();
	
	/**
	 * Returns the total client count from TS3 server database!
	 * @return Client count
	 * @since 5.5
	 */
	public abstract int getServerClientDBCount();

	/**
	 * Returns the client connection count of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return The client connection count.
	 */
	public abstract long getServerClientConnectionsCount();

	/**
	 * Returns the min client version timestamp of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return TS3 timestamp
	 * @since 5.3
	 */
	public abstract long getServerMinClientVersion();

	/**
	 * Returns the default guest server group id of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return Default guest server group id
	 * @since 5.3
	 */
	public abstract int getServerDefaultServerGroup();

	/**
	 * Returns the default channel admin group id of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return Default channel admin group id
	 * @since 5.3
	 */
	public abstract int getServerDefaultChannelAdminGroup();

	/**
	 * Returns the default guest channel group id of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return Default guest channel group id
	 * @since 5.3
	 */
	public abstract int getServerDefaultChannelGroup();
	
	/**
	 * Returns the max download total bandwidth value of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return max download total bandwidth value or -1 if set to unlimited or an invalid value was returned.
	 * @since 5.3
	 */
	public abstract long getServerMaxDownloadTotalBandwidth();

	/**
	 * Returns the max upload total bandwidth value of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return max upload total bandwidth value or -1 if set to unlimited or an invalid value was returned.
	 * @since 5.3
	 */
	public abstract long getServerMaxUploadTotalBandwidth();
	
	/**
	 * Returns the download quota of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return download quota value or -1 if set to unlimited or an invalid value was returned.
	 */
	public abstract long getServerDownloadQuota();

	/**
	 * Returns the upload quota of the connected server!<br>
	 * <br>
	 * <b>Notice:</b><br>
	 * This will be updated every 60 seconds only.
	 * @return upload quota value or -1 if set to unlimited or an invalid value was returned.
	 */
	public abstract long getServerUploadQuota();
}