package de.stefan1200.jts3servermod.interfaces;

import java.util.HashMap;

/**
 * If your plugin has chat commands or is registered for Teamspeak 3 server or channel events, your plugin has to implement this interface!<br><br>
 * 
 * The author of the JTS3ServerMod is not responsible for any damage or data loss!<br><br>
 * 
 * <b>E-Mail:</b><br><a href="mailto:info@stefan1200.de">info@stefan1200.de</a><br><br>
 * <b>Homepage:</b><br><a href="http://www.stefan1200.de" target="_blank">http://www.stefan1200.de</a>
 * @author Stefan Martens
 *
 */
public interface HandleTS3Events
{
	/**
	 * Return a list of chat commands as String array for this client or <code>null</code> if there are no chat commands.
	 * @param eventInfo Information about the client who asked for the chat command list.
	 * @param isFullAdmin <code>true</code> if client is a bot full admin.
	 * @param isAdmin <code>true</code> if client is a bot admin.
	 * @return A list of chat commands.
	 */
	public String[] botChatCommandList(HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin);
	
	/**
	 * Return the help text of the given chat command or <code>null</code> if the given chat command does not exist.
	 * @param command Chat command
	 * @return Help text of the given chat command.
	 */
	public String botChatCommandHelp(String command);
	
	/**
	 * This method will be called by the bot, if a chat command for this plugin was received.
	 * @param msg The received chat command
	 * @param eventInfo Information about the client sending that chat command
	 * @param isFullAdmin <code>true</code> if client is a bot full admin.
	 * @param isAdmin <code>true</code> if client is a client bot admin.
	 * @return <code>true</code> if the chat command was valid and the plugin was enabled, <code>false</code> if not.
	 */
	public boolean handleChatCommands(String msg, HashMap<String, String> eventInfo, boolean isFullAdmin, boolean isAdmin);
	
	/**
	 * If the plugin is registered for receiving Teamspeak 3 channel or server events, this function will be called after receiving an event.<br>
	 * <br>
	 * Following event types can occur:<br>
	 * <code>notifyserveredited</code> - Server properties was edited<br>
	 * <code>notifycliententerview</code> - Client join server<br>
	 * <code>notifyclientleftview</code> - Client left server<br>
	 * <code>notifyclientmoved</code> - Client was moved or switched channel<br>
	 * <code>notifychannelcreated</code> - Channel was created<br>
	 * <code>notifychanneledited</code> - Channel properties was edited<br>
	 * <code>notifychanneldeleted</code> - Channel was deleted
	 * @param eventType Event type, look description above.
	 * @param eventInfo HashMap with information about the event and who triggered it.
	 * @see JTS3ServerMod_Interface#addTS3ChannelEvent(Object)
	 * @see JTS3ServerMod_Interface#addTS3ServerEvent(Object)
	 */
	public void handleTS3Events(String eventType, HashMap<String, String> eventInfo);
}
