/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.util;

public class DatatypeConverter {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final char[] encodeMap = DatatypeConverter.initEncodeMap();
    private static final byte[] decodeMap = DatatypeConverter.initDecodeMap();
    private static final byte PADDING = 127;

    private static char[] initEncodeMap() {
        char[] cArray = new char[64];
        int n = 0;
        while (n < 26) {
            cArray[n] = (char)(n + 65);
            ++n;
        }
        n = 26;
        while (n < 52) {
            cArray[n] = (char)(97 + (n - 26));
            ++n;
        }
        n = 52;
        while (n < 62) {
            cArray[n] = (char)(48 + (n - 52));
            ++n;
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    private static byte[] initDecodeMap() {
        byte[] byArray = new byte[128];
        int n = 0;
        while (n < 128) {
            byArray[n] = -1;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            int n2 = n++;
            byArray[n2] = (byte)(n2 - 65);
        }
        n = 97;
        while (n <= 122) {
            int n3 = n++;
            byArray[n3] = (byte)(n3 - 97 + 26);
        }
        n = 48;
        while (n <= 57) {
            int n4 = n++;
            byArray[n4] = (byte)(n4 - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    public static char encode(int n) {
        return encodeMap[n & 0x3F];
    }

    private static int guessLength(String string) {
        int n;
        int n2 = string.length();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            n = decodeMap[string.charAt(n3)];
            if (n != 127) {
                if (n != -1) break;
                return string.length() / 4 * 3;
            }
            --n3;
        }
        if ((n = n2 - ++n3) > 2) {
            return string.length() / 4 * 3;
        }
        return string.length() / 4 * 3 - n;
    }

    public static String printHexBinary(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            stringBuilder.append(hexCode[by >> 4 & 0xF]);
            stringBuilder.append(hexCode[by & 0xF]);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String printBase64Binary(byte[] byArray) {
        return DatatypeConverter.printBase64Binary(byArray, 0, byArray.length);
    }

    public static String printBase64Binary(byte[] byArray, int n, int n2) {
        char[] cArray = new char[(n2 + 2) / 3 << 2];
        int n3 = DatatypeConverter.printBase64Binary(byArray, n, n2, cArray, 0);
        assert (n3 == cArray.length);
        return new String(cArray);
    }

    public static int printBase64Binary(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        while (n2 >= 3) {
            cArray[n3++] = DatatypeConverter.encode(byArray[n] >> 2);
            cArray[n3++] = DatatypeConverter.encode((byArray[n] & 3) << 4 | byArray[n + 1] >> 4 & 0xF);
            cArray[n3++] = DatatypeConverter.encode((byArray[n + 1] & 0xF) << 2 | byArray[n + 2] >> 6 & 3);
            cArray[n3++] = DatatypeConverter.encode(byArray[n + 2] & 0x3F);
            n2 -= 3;
            n += 3;
        }
        if (n2 == 1) {
            cArray[n3++] = DatatypeConverter.encode(byArray[n] >> 2);
            cArray[n3++] = DatatypeConverter.encode((byArray[n] & 3) << 4);
            cArray[n3++] = 61;
            cArray[n3++] = 61;
        }
        if (n2 == 2) {
            cArray[n3++] = DatatypeConverter.encode(byArray[n] >> 2);
            cArray[n3++] = DatatypeConverter.encode((byArray[n] & 3) << 4 | byArray[n + 1] >> 4 & 0xF);
            cArray[n3++] = DatatypeConverter.encode((byArray[n + 1] & 0xF) << 2);
            cArray[n3++] = 61;
        }
        return n3;
    }

    public static byte[] parseBase64Binary(String string) {
        int n = DatatypeConverter.guessLength(string);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = string.length();
        byte[] byArray2 = new byte[4];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c2 = string.charAt(n5);
            if ((c2 = decodeMap[c2]) != '\uffffffff') {
                byArray2[n4++] = c2;
            }
            if (n4 == 4) {
                byArray[n2++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                if (byArray2[2] != 127) {
                    byArray[n2++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                }
                if (byArray2[3] != 127) {
                    byArray[n2++] = (byte)(byArray2[2] << 6 | byArray2[3]);
                }
                n4 = 0;
            }
            ++n5;
        }
        if (n == n2) {
            return byArray;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }
}

