/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.util;

import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.util.MySQLConnect;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class ArrangedPropertiesWriter
implements Cloneable {
    private final String SEPARATOR = "***";
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private HashMap hmHelp = new HashMap();
    private HashMap hmValue = new HashMap();
    private HashMap hmSave = new HashMap();
    private Vector vKeys = new Vector();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private JTS3ServerMod_Interface mainClass = null;
    private boolean writeProtected = false;
    private MySQLConnect lastMysqlConnect = null;
    private int lastMysqlInstanceID = -1;
    private String lastConfigFileName = null;
    private String lastConfigFileHeader = null;

    public ArrangedPropertiesWriter(JTS3ServerMod_Interface jTS3ServerMod_Interface) {
        this.mainClass = jTS3ServerMod_Interface;
    }

    public ArrangedPropertiesWriter(JTS3ServerMod_Interface jTS3ServerMod_Interface, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, Vector vector) {
        this.mainClass = jTS3ServerMod_Interface;
        this.hmHelp = hashMap;
        this.hmValue = hashMap2;
        this.hmSave = hashMap3;
        this.vKeys = vector;
    }

    public ArrangedPropertiesWriter clone() {
        return new ArrangedPropertiesWriter(null, this.hmHelp, this.hmValue, this.hmSave, this.vKeys);
    }

    public void setNewMainClass(JTS3ServerMod_Interface jTS3ServerMod_Interface) {
        this.mainClass = jTS3ServerMod_Interface;
    }

    public void setWriteProtection(boolean bl) {
        this.writeProtected = bl;
    }

    public void setDefaultConfigFileHeader(String string) {
        this.lastConfigFileHeader = string;
    }

    public boolean addKey(String string, String string2) {
        return this.addKey(string, string2, null, true);
    }

    public boolean addKey(String string, String string2, String string3) {
        return this.addKey(string, string2, string3, true);
    }

    public boolean addKey(String string, String string2, boolean bl) {
        return this.addKey(string, string2, null, bl);
    }

    public boolean addKey(String string, String string2, String string3, boolean bl) {
        if (this.writeProtected) {
            return false;
        }
        if (!string.equals("***") && string.length() > 0 && this.vKeys.indexOf(string) == -1) {
            this.vKeys.addElement(string);
            this.hmValue.put(string, string3);
            this.hmHelp.put(string, string2);
            this.hmSave.put(string, bl);
            return true;
        }
        return false;
    }

    public boolean insertKey(String string, int n, String string2) {
        if (this.writeProtected) {
            return false;
        }
        if (!string.equals("***") && string.length() > 0 && this.vKeys.indexOf(string) == -1) {
            this.vKeys.insertElementAt(string, n);
            this.hmHelp.put(string, string2);
            return true;
        }
        return false;
    }

    public boolean canSaveToFile(String string) {
        return (Boolean)this.hmSave.get(string);
    }

    public Vector getKeys() {
        Vector vector = new Vector();
        vector.addAll(this.vKeys);
        while (vector.removeElement("***")) {
        }
        return vector;
    }

    public String getValue(String string) {
        return (String)this.hmValue.get(string);
    }

    public String getValue(String string, String string2) {
        if (this.hmValue.get(string) == null) {
            return string2;
        }
        return (String)this.hmValue.get(string);
    }

    public boolean setValue(String string, String string2) {
        if (this.writeProtected) {
            return false;
        }
        if (!string.equals("***") && string.length() > 0 && this.vKeys.indexOf(string) != -1) {
            this.hmValue.put(string, string2);
            return true;
        }
        return false;
    }

    public boolean setValue(String string, long l2) {
        return this.setValue(string, Long.toString(l2));
    }

    public boolean setValue(String string, double d2) {
        return this.setValue(string, Double.toString(d2));
    }

    public boolean setValue(String string, boolean bl) {
        return this.setValue(string, Boolean.toString(bl));
    }

    public void removeAllValues() {
        this.hmValue.clear();
    }

    public void addSeparator() {
        if (this.writeProtected) {
            return;
        }
        this.vKeys.addElement("***");
    }

    public void insertSeparator(int n) {
        if (this.writeProtected) {
            return;
        }
        this.vKeys.insertElementAt("***", n);
    }

    public void removeAllSeparators() {
        if (this.writeProtected) {
            return;
        }
        while (this.vKeys.removeElement("***")) {
        }
    }

    public int getKeyCount() {
        return this.vKeys.size();
    }

    public String getHelpText(String string) {
        return (String)this.hmHelp.get(string);
    }

    public boolean removeKey(String string) {
        if (this.writeProtected) {
            return false;
        }
        if (!string.equals("***") && string.length() > 0 && this.vKeys.indexOf(string) != -1) {
            this.vKeys.removeElement(string);
            this.hmHelp.remove(string);
            this.hmValue.remove(string);
            this.hmSave.remove(string);
            return true;
        }
        return false;
    }

    public boolean loadValues(File object) {
        if (this.writeProtected) {
            return false;
        }
        if (object == null || !((File)object).isFile()) {
            return false;
        }
        this.lastConfigFileName = ((File)object).getAbsolutePath();
        this.lastMysqlConnect = null;
        this.lastMysqlInstanceID = -1;
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream((File)object));
            for (String string : this.vKeys) {
                object = properties.getProperty(string);
                if (object == null) continue;
                this.hmValue.put(string, object);
            }
        }
        catch (Exception exception) {
            if (this.mainClass != null) {
                this.mainClass.addLogEntry(null, exception, false);
            }
            return false;
        }
        return true;
    }

    public boolean loadValues(String string) {
        if (string == null) {
            return false;
        }
        return this.loadValues(new File(string));
    }

    public boolean loadValues(MySQLConnect mySQLConnect, int n) {
        boolean bl;
        block28: {
            if (this.writeProtected) {
                return false;
            }
            this.lastMysqlConnect = mySQLConnect;
            this.lastMysqlInstanceID = n;
            this.lastConfigFileName = null;
            if (mySQLConnect == null || n <= 0) {
                return false;
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    mySQLConnect.connect();
                    statement = mySQLConnect.getStatement();
                    resultSet = statement.executeQuery("SELECT configkey, configvalue FROM jts3servermod_instanceconfig WHERE instance_id = " + Integer.toString(n));
                    block16: while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        for (String string2 : this.vKeys) {
                            if (!string2.equals(string)) continue;
                            string = resultSet.getString(2);
                            if (string == null) continue block16;
                            this.hmValue.put(string2, string);
                            continue block16;
                        }
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (this.mainClass != null) {
                        this.mainClass.addLogEntry(null, exception, false);
                    }
                    bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {}
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {}
                    mySQLConnect.close();
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                mySQLConnect.close();
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            mySQLConnect.close();
        }
        return bl;
    }

    public boolean save() {
        if (this.lastMysqlConnect != null && this.lastMysqlInstanceID >= 0) {
            ArrangedPropertiesWriter arrangedPropertiesWriter = this;
            return arrangedPropertiesWriter.save(arrangedPropertiesWriter.lastMysqlConnect, this.lastMysqlInstanceID);
        }
        if (this.lastConfigFileName != null) {
            ArrangedPropertiesWriter arrangedPropertiesWriter = this;
            return arrangedPropertiesWriter.save(arrangedPropertiesWriter.lastConfigFileName, this.lastConfigFileHeader);
        }
        return false;
    }

    public boolean save(MySQLConnect mySQLConnect, int n) {
        boolean bl;
        block25: {
            if (mySQLConnect == null || n <= 0) {
                return false;
            }
            Statement statement = null;
            Statement statement2 = null;
            try {
                try {
                    mySQLConnect.connect();
                    statement = mySQLConnect.getStatement();
                    statement.executeUpdate("DELETE FROM jts3servermod_instanceconfig WHERE instance_id = " + Integer.toString(n));
                    statement.close();
                    statement = null;
                    statement2 = mySQLConnect.getPreparedStatement("INSERT INTO jts3servermod_instanceconfig (instance_id, configkey, configvalue) VALUES (" + Integer.toString(n) + ", ?, ?)");
                    for (String string : this.vKeys) {
                        if (string.equals("***")) continue;
                        statement2.setString(1, string);
                        if (this.hmValue.get(string) != null) {
                            statement2.setString(2, (String)this.hmValue.get(string));
                        } else {
                            statement2.setNull(2, 12);
                        }
                        statement2.executeUpdate();
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (this.mainClass != null) {
                        this.mainClass.addLogEntry(null, exception, false);
                    }
                    bl = false;
                    try {
                        if (statement2 != null) {
                            statement2.close();
                        }
                    }
                    catch (Exception exception2) {}
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {}
                    mySQLConnect.close();
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                mySQLConnect.close();
                throw throwable;
            }
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (Exception exception) {}
            mySQLConnect.close();
        }
        return bl;
    }

    public boolean save(String object, String string2) {
        if (object == null) {
            return false;
        }
        try {
            object = new PrintStream((String)object, "ISO-8859-1");
        }
        catch (Exception exception) {
            if (this.mainClass != null) {
                this.mainClass.addLogEntry(null, exception, false);
            }
            return false;
        }
        if (string2 != null && string2.length() > 0) {
            ((PrintStream)object).println(this.convertString(string2));
        }
        ((PrintStream)object).println("# File created at " + this.sdf.format(new Date(System.currentTimeMillis())));
        ((PrintStream)object).println();
        for (String string2 : this.vKeys) {
            if (string2.equals("***")) {
                ((PrintStream)object).println();
                continue;
            }
            if (!((Boolean)this.hmSave.get(string2)).booleanValue()) continue;
            if (this.hmHelp.get(string2) != null) {
                ArrangedPropertiesWriter arrangedPropertiesWriter = this;
                ((PrintStream)object).println(arrangedPropertiesWriter.convertString((String)arrangedPropertiesWriter.hmHelp.get(string2)));
            }
            ((PrintStream)object).print(string2);
            ((PrintStream)object).print(" = ");
            ((PrintStream)object).println(this.hmValue.get(string2) == null ? "" : (String)this.hmValue.get(string2));
        }
        ((PrintStream)object).close();
        return true;
    }

    private String convertString(String string) {
        string = "# ".concat(String.valueOf(string));
        string = string.replace("\\", "$[mkbackslashsave]");
        string = string.replace("\n", String.valueOf(this.LINE_SEPARATOR) + "# ");
        string = string.replace("$[mkbackslashsave]", "\\");
        return string;
    }
}

