/*
 * Decompiled with CFR 0.152.
 */
package de.stefan1200.jts3servermod.functions;

import de.stefan1200.jts3servermod.BotConfigurationException;
import de.stefan1200.jts3servermod.FunctionExceptionLog;
import de.stefan1200.jts3servermod.interfaces.HandleBotEvents;
import de.stefan1200.jts3servermod.interfaces.HandleClientList;
import de.stefan1200.jts3servermod.interfaces.JTS3ServerMod_Interface;
import de.stefan1200.jts3servermod.interfaces.LoadConfiguration;
import de.stefan1200.jts3serverquery.JTS3ServerQuery;
import de.stefan1200.jts3serverquery.TS3ServerQueryException;
import de.stefan1200.util.ArrangedPropertiesWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AwayMover
implements HandleBotEvents,
HandleClientList,
LoadConfiguration {
    private String a;
    private JTS3ServerMod_Interface a;
    private JTS3ServerQuery a;
    private boolean a;
    private boolean b;
    private Vector a;
    private boolean c;
    private int a;
    private int b;
    private Vector b;
    private Vector c;
    private Vector d;
    private boolean d;
    private String b = null;
    private String c = null;
    private String d = null;
    private String e = null;
    private String f = null;
    private FunctionExceptionLog a = -1;

    public AwayMover() {
        this.b = new Vector();
        this.c = new Vector();
        this.d = new Vector();
        this.a = new FunctionExceptionLog();
    }

    @Override
    public void initClass(JTS3ServerMod_Interface jTS3ServerMod_Interface, JTS3ServerQuery jTS3ServerQuery, String string) {
        this.a = jTS3ServerMod_Interface;
        this.a = jTS3ServerQuery;
        this.a = string.trim();
    }

    @Override
    public void handleOnBotConnect() {
        if (!this.a) {
            return;
        }
        String string = "Clients with away status will be moved to Channel \"" + this.f + "\" (id: " + Integer.toString(this.a) + ") after " + this.b + " seconds" + (this.b ? " and moved back if not away anymore!" : "");
        this.a.addLogEntry(this.a, (byte)1, string, true);
    }

    @Override
    public void handleAfterCacheUpdate() {
        if (!this.a) {
            return;
        }
        this.f = this.a.getChannelName(this.a);
        if (this.f == null) {
            this.a.addLogEntry(this.a, (byte)3, "Critical: Channel ID " + this.a + " don't exists! Check value " + this.a + "_channel_id in your configuration!", true);
            this.a = false;
            return;
        }
        if (!this.b.equalsIgnoreCase("none")) {
            AwayMover awayMover = this;
            this.e = new String(awayMover.c);
            awayMover.e = awayMover.e.replace("%AWAY_CHANNEL_NAME%", awayMover.f);
            if (!awayMover.a.isMessageLengthValid(awayMover.b, awayMover.e)) {
                awayMover.a.addLogEntry(awayMover.a, (byte)2, "Away Mover message is to long! Make sure that " + awayMover.b + " messages are not longer than " + Short.toString(awayMover.a.getMaxMessageLength(awayMover.b)) + " characters (including spaces and BBCode)" + (awayMover.a.getMySQLConnection() == null ? ", check file: " + awayMover.d : ""), true);
            }
        }
    }

    @Override
    public void activate() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void unload() {
        this.a = null;
        this.b = null;
        this.c = null;
        this.d = null;
        this.a = null;
    }

    @Override
    public boolean multipleInstances() {
        return true;
    }

    @Override
    public void initConfig(ArrangedPropertiesWriter arrangedPropertiesWriter) {
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_moveback", "Move client back if not away anymore? Set yes or no here!", "yes");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_id", "Channel id to move away clients into it");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_delay", "Idle time in seconds after the client with away status will be moved to the channel.\nHas between 0 and 10000 seconds!", "5");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_list", "A comma separated list (without spaces) of channel ids.\nDepends on the given mode, this channels can be ignored or only this channels will be checked!\nIf no channels should be ignored, set no channels here and select the channel list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_channel_list_mode", "Select one of the two modes for the channel list.\nignore = The selected channels will be ignored.\nonly = Only the selected channels will be checked.", "ignore");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list", "A comma separated list (without spaces) of server group ids.\nDepends on the given mode, this server groups can be ignored or only this server groups will be checked!\nIf no server groups should be ignored, set no server groups here and select the group list mode ignore!");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_group_list_mode", "Select one of the two modes for the server group list.\nignore = The selected server groups will be ignored.\nonly = Only the selected server groups will be checked.", "ignore");
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message_mode", "Select the message mode, how the client should get the message.\npoke, chat or none are valid values!", "none");
        if (this.a.getMySQLConnection() == null) {
            arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_file", "Path to file which contains the away mover message", "%apphome%config/server1/awaymessages.cfg");
        }
        arrangedPropertiesWriter.addKey(String.valueOf(this.a) + "_message", "Away Mover message, the client get this message as chat message.\nYou can use the following keywords, which will be replaced:\n%AWAY_CHANNEL_NAME% - This will be replaced with the channel name of the away_move_channel_id\nTypical BBCode like in Teamspeak 3 Client possible. You can use \\n for a new line.", this.a.getMySQLConnection() != null);
    }

    @Override
    public boolean loadConfig(ArrangedPropertiesWriter object, boolean bl) {
        String string = "";
        this.a = false;
        try {
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_moveback", "yes").trim().equalsIgnoreCase("yes");
            string = String.valueOf(this.a) + "_channel_id";
            String[] stringArray = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_channel_id");
            if (stringArray == null) {
                throw new NumberFormatException();
            }
            this.a = Integer.parseInt(stringArray.trim());
            string = String.valueOf(this.a) + "_delay";
            this.b = Integer.parseInt(((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_delay", "5").trim());
            if (this.b < 0 || this.b > 10000) {
                this.b = 5;
            }
            this.a.clear();
            stringArray = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_channel_list");
            string = String.valueOf(this.a) + "_channel_list";
            if (stringArray != null && stringArray.length() > 0) {
                stringArray = new StringTokenizer((String)stringArray, ",", false);
                while (stringArray.hasMoreTokens()) {
                    this.a.addElement(Integer.parseInt(stringArray.nextToken().trim()));
                }
            }
            this.c = !((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_channel_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.d.clear();
            stringArray = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list");
            string = String.valueOf(this.a) + "_group_list";
            if (stringArray != null && stringArray.length() > 0) {
                stringArray = new StringTokenizer((String)stringArray, ",", false);
                while (stringArray.hasMoreTokens()) {
                    this.d.addElement(Integer.parseInt(stringArray.nextToken().trim()));
                }
            }
            this.d = !((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_group_list_mode", "ignore").trim().equalsIgnoreCase("only");
            this.b = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_message_mode", "none").trim();
            if (!this.b.equalsIgnoreCase("none")) {
                this.d = ((ArrangedPropertiesWriter)object).getValue(String.valueOf(this.a) + "_file");
                stringArray = new String[]{String.valueOf(this.a) + "_message"};
                if (!this.a.loadMessages(this.a, "_file", stringArray)) {
                    throw new BotConfigurationException("Away mover message could not be loaded!");
                }
                this.c = ((ArrangedPropertiesWriter)object).getValue(stringArray[0]);
                if (this.c == null || this.c.length() == 0) {
                    throw new BotConfigurationException("Away Mover message missing in config!");
                }
            }
            this.a = true;
        }
        catch (NumberFormatException numberFormatException) {
            object = new NumberFormatException("Config value of \"" + string + "\" is not a number! Current value: " + ((ArrangedPropertiesWriter)object).getValue(string, "not set"));
            ((Throwable)object).setStackTrace(numberFormatException.getStackTrace());
            throw object;
        }
        return this.a;
    }

    @Override
    public void setListModes(BitSet bitSet) {
        bitSet.set(0);
        bitSet.set(1);
        bitSet.set(3);
    }

    @Override
    public void handleClientCheck(Vector vector) {
        if (!this.a) {
            return;
        }
        for (HashMap hashMap : vector) {
            if (!((String)hashMap.get("client_type")).equals("0")) continue;
            int n = Integer.parseInt((String)hashMap.get("clid"));
            int n2 = -1;
            if (this.b) {
                n2 = this.b.indexOf(n);
            }
            if (((String)hashMap.get("client_away")).equals("1") && this.a.getIdleTime(hashMap, this.a) > (long)(this.b * 1000)) {
                n2 = Integer.parseInt((String)hashMap.get("cid"));
                boolean bl = this.a.isIDListed(n2, this.a);
                if (n2 == this.a || !(this.c ? !bl : bl)) continue;
                bl = this.a.isGroupListed((String)hashMap.get("client_servergroups"), this.d);
                if (!(this.d ? !bl : bl)) continue;
                try {
                    this.a.moveClient(n, this.a, null);
                    hashMap.put("cid", Integer.toString(this.a));
                    if (this.b) {
                        this.b.addElement(n);
                        this.c.addElement(n2);
                    }
                    this.a.addLogEntry(this.a, (byte)1, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is away, client was moved!", false);
                    this.a.sendMessageToClient(this.a, this.b, n, this.e);
                    this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
                }
                catch (TS3ServerQueryException tS3ServerQueryException) {
                    if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) continue;
                    this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                    this.a.addLogEntry(this.a, (byte)2, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is away, but an error occurred while moving client!", false);
                    if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                        this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                        continue;
                    }
                    this.a.addLogEntry(this.a, tS3ServerQueryException, false);
                }
                catch (Exception exception) {
                    this.a.addLogEntry(this.a, (byte)3, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is away, but an error occurred while moving client!", false);
                    this.a.addLogEntry(this.a, exception, false);
                }
                continue;
            }
            if (n2 == -1 || !((String)hashMap.get("client_away")).equals("0")) continue;
            if (Integer.parseInt((String)hashMap.get("cid")) != this.a) {
                this.b.removeElementAt(n2);
                this.c.removeElementAt(n2);
                continue;
            }
            try {
                this.a.moveClient(n, (Integer)this.c.elementAt(n2), null);
                hashMap.put("cid", Integer.toString((Integer)this.c.elementAt(n2)));
                this.b.removeElementAt(n2);
                this.c.removeElementAt(n2);
                this.a.addLogEntry(this.a, (byte)1, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is not away anymore, client was moved back!", false);
                this.a.clearException(Integer.parseInt((String)hashMap.get("client_database_id")));
            }
            catch (TS3ServerQueryException tS3ServerQueryException) {
                if (this.a.existsException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")))) continue;
                this.a.addException(tS3ServerQueryException, Integer.parseInt((String)hashMap.get("client_database_id")));
                this.a.addLogEntry(this.a, (byte)2, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is not away anymore, but an error occurred while moving back client!", false);
                if (tS3ServerQueryException.getFailedPermissionID() < 0) {
                    this.a.addLogEntry(this.a, (byte)2, tS3ServerQueryException.toString(), false);
                    continue;
                }
                this.a.addLogEntry(this.a, tS3ServerQueryException, false);
            }
            catch (Exception exception) {
                this.a.addLogEntry(this.a, (byte)3, "Client status of \"" + (String)hashMap.get("client_nickname") + "\" (db id: " + (String)hashMap.get("client_database_id") + ") is not away anymore, but an error occurred while moving back client!", false);
                this.a.addLogEntry(this.a, exception, false);
            }
        }
        if (this.b) {
            int n = 0;
            while (n < this.b.size()) {
                boolean bl = false;
                for (HashMap hashMap : vector) {
                    if (Integer.parseInt((String)hashMap.get("clid")) != (Integer)this.b.elementAt(n)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.b.removeElementAt(n);
                    this.c.removeElementAt(n);
                }
                ++n;
            }
        }
    }

    @Override
    public int getAPIBuild() {
        return 0;
    }

    @Override
    public String getCopyright() {
        return "Away Mover function created by Stefan \"Stefan1200\" Martens, [url]http://www.stefan1200.de[/url]";
    }
}

