/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jzlib;

import com.jcraft.jsch.jzlib.Deflate;
import java.nio.charset.StandardCharsets;

final class GZIPHeader
implements Cloneable {
    static final byte OS_MSDOS = 0;
    static final byte OS_AMIGA = 1;
    static final byte OS_VMS = 2;
    static final byte OS_UNIX = 3;
    static final byte OS_ATARI = 5;
    static final byte OS_OS2 = 6;
    static final byte OS_MACOS = 7;
    static final byte OS_TOPS20 = 10;
    static final byte OS_WIN32 = 11;
    static final byte OS_VMCMS = 4;
    static final byte OS_ZSYSTEM = 8;
    static final byte OS_CPM = 9;
    static final byte OS_QDOS = 12;
    static final byte OS_RISCOS = 13;
    static final byte OS_UNKNOWN = -1;
    boolean text = false;
    private boolean fhcrc = false;
    int xflags;
    int os = 255;
    byte[] extra;
    byte[] name;
    byte[] comment;
    int hcrc;
    long crc;
    boolean done = false;
    long mtime = 0L;

    GZIPHeader() {
    }

    void setModifiedTime(long mtime) {
        this.mtime = mtime;
    }

    long getModifiedTime() {
        return this.mtime;
    }

    void setOS(int os) {
        if ((0 > os || os > 13) && os != 255) {
            throw new IllegalArgumentException("os: " + os);
        }
        this.os = os;
    }

    int getOS() {
        return this.os;
    }

    void setName(String name) {
        this.name = name.getBytes(StandardCharsets.ISO_8859_1);
    }

    String getName() {
        if (this.name == null) {
            return "";
        }
        return new String(this.name, StandardCharsets.ISO_8859_1);
    }

    void setComment(String comment) {
        this.comment = comment.getBytes(StandardCharsets.ISO_8859_1);
    }

    String getComment() {
        if (this.comment == null) {
            return "";
        }
        return new String(this.comment, StandardCharsets.ISO_8859_1);
    }

    void setCRC(long crc) {
        this.crc = crc;
    }

    long getCRC() {
        return this.crc;
    }

    void put(Deflate d2) {
        int flag = 0;
        if (this.text) {
            flag |= 1;
        }
        if (this.fhcrc) {
            flag |= 2;
        }
        if (this.extra != null) {
            flag |= 4;
        }
        if (this.name != null) {
            flag |= 8;
        }
        if (this.comment != null) {
            flag |= 0x10;
        }
        int xfl = 0;
        if (d2.level == 1) {
            xfl |= 4;
        } else if (d2.level == 9) {
            xfl |= 2;
        }
        d2.put_short(-29921);
        d2.put_byte((byte)8);
        d2.put_byte((byte)flag);
        d2.put_byte((byte)this.mtime);
        d2.put_byte((byte)(this.mtime >> 8));
        d2.put_byte((byte)(this.mtime >> 16));
        d2.put_byte((byte)(this.mtime >> 24));
        d2.put_byte((byte)xfl);
        d2.put_byte((byte)this.os);
        if (this.extra != null) {
            d2.put_byte((byte)this.extra.length);
            d2.put_byte((byte)(this.extra.length >> 8));
            d2.put_byte(this.extra, 0, this.extra.length);
        }
        if (this.name != null) {
            d2.put_byte(this.name, 0, this.name.length);
            d2.put_byte((byte)0);
        }
        if (this.comment != null) {
            d2.put_byte(this.comment, 0, this.comment.length);
            d2.put_byte((byte)0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        byte[] tmp;
        GZIPHeader gheader = (GZIPHeader)super.clone();
        if (gheader.extra != null) {
            tmp = new byte[gheader.extra.length];
            System.arraycopy(gheader.extra, 0, tmp, 0, tmp.length);
            gheader.extra = tmp;
        }
        if (gheader.name != null) {
            tmp = new byte[gheader.name.length];
            System.arraycopy(gheader.name, 0, tmp, 0, tmp.length);
            gheader.name = tmp;
        }
        if (gheader.comment != null) {
            tmp = new byte[gheader.comment.length];
            System.arraycopy(gheader.comment, 0, tmp, 0, tmp.length);
            gheader.comment = tmp;
        }
        return gheader;
    }
}

