/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.MAC;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

abstract class HMAC
implements MAC {
    protected String name;
    protected int bsize;
    protected String algorithm;
    protected boolean etm;
    private Mac mac;
    private final byte[] tmp = new byte[4];

    HMAC() {
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (key.length > this.bsize) {
            byte[] tmp = new byte[this.bsize];
            System.arraycopy(key, 0, tmp, 0, this.bsize);
            key = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key, this.algorithm);
        this.mac = Mac.getInstance(this.algorithm);
        this.mac.init(skey);
    }

    @Override
    public void update(int i2) {
        this.tmp[0] = (byte)(i2 >>> 24);
        this.tmp[1] = (byte)(i2 >>> 16);
        this.tmp[2] = (byte)(i2 >>> 8);
        this.tmp[3] = (byte)i2;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] foo, int s, int l2) {
        this.mac.update(foo, s, l2);
    }

    @Override
    public void doFinal(byte[] buf, int offset) {
        try {
            this.mac.doFinal(buf, offset);
        }
        catch (ShortBufferException e2) {
            System.err.println(e2);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEtM() {
        return this.etm;
    }
}

