/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector<Identity> identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jsch) {
        this.jsch = jsch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector<Identity> getIdentities() {
        this.removeDupulicates();
        Vector<Identity> v = new Vector<Identity>();
        for (int i2 = 0; i2 < this.identities.size(); ++i2) {
            v.addElement(this.identities.elementAt(i2));
        }
        return v;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            byte[] blob1 = identity.getPublicKeyBlob();
            if (blob1 == null) {
                this.identities.addElement(identity);
                return;
            }
            for (int i2 = 0; i2 < this.identities.size(); ++i2) {
                byte[] blob2 = this.identities.elementAt(i2).getPublicKeyBlob();
                if (blob2 == null || !Util.array_equals(blob1, blob2)) continue;
                if (!identity.isEncrypted() && this.identities.elementAt(i2).isEncrypted()) {
                    this.remove(blob2);
                    continue;
                }
                return;
            }
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] identity) {
        try {
            IdentityFile _identity = IdentityFile.newInstance("from remote:", identity, null, this.jsch);
            this.add(_identity);
            return true;
        }
        catch (JSchException e2) {
            return false;
        }
    }

    synchronized void remove(Identity identity) {
        if (this.identities.contains(identity)) {
            this.identities.removeElement(identity);
            identity.clear();
        } else {
            this.remove(identity.getPublicKeyBlob());
        }
    }

    @Override
    public synchronized boolean remove(byte[] blob) {
        if (blob == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.identities.size(); ++i2) {
            Identity _identity = this.identities.elementAt(i2);
            byte[] _blob = _identity.getPublicKeyBlob();
            if (_blob == null || !Util.array_equals(blob, _blob)) continue;
            this.identities.removeElement(_identity);
            _identity.clear();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        for (int i2 = 0; i2 < this.identities.size(); ++i2) {
            Identity identity = this.identities.elementAt(i2);
            identity.clear();
        }
        this.identities.removeAllElements();
    }

    private void removeDupulicates() {
        int i2;
        Vector<byte[]> v = new Vector<byte[]>();
        int len = this.identities.size();
        if (len == 0) {
            return;
        }
        block0: for (i2 = 0; i2 < len; ++i2) {
            Identity foo = this.identities.elementAt(i2);
            byte[] foo_blob = foo.getPublicKeyBlob();
            if (foo_blob == null) continue;
            for (int j2 = i2 + 1; j2 < len; ++j2) {
                Identity bar = this.identities.elementAt(j2);
                byte[] bar_blob = bar.getPublicKeyBlob();
                if (bar_blob == null || !Util.array_equals(foo_blob, bar_blob) || foo.isEncrypted() != bar.isEncrypted()) continue;
                v.addElement(foo_blob);
                continue block0;
            }
        }
        for (i2 = 0; i2 < v.size(); ++i2) {
            this.remove((byte[])v.elementAt(i2));
        }
    }
}

