/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.USocketFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketChannel;

public class JUnixSocketFactory
implements USocketFactory {
    public JUnixSocketFactory() throws AgentProxyException {
        try {
            AFUNIXSocketChannel foo = AFUNIXSocketChannel.open();
            if (foo != null) {
                foo.close();
            }
        }
        catch (IOException | NoClassDefFoundError e2) {
            throw new AgentProxyException("junixsocket library unavailable", e2);
        }
    }

    @Override
    public SocketChannel connect(Path path) throws IOException {
        AFUNIXSocketAddress sockAddr = AFUNIXSocketAddress.of((Path)path);
        AFUNIXSocketChannel sock = AFUNIXSocketChannel.open();
        sock.configureBlocking(true);
        sock.connect((SocketAddress)sockAddr);
        return sock;
    }

    @Override
    public ServerSocketChannel bind(Path path) throws IOException {
        AFUNIXSocketAddress sockAddr = AFUNIXSocketAddress.of((Path)path);
        AFUNIXServerSocketChannel sock = AFUNIXServerSocketChannel.open();
        sock.configureBlocking(true);
        sock.bind((SocketAddress)sockAddr);
        return sock;
    }
}

