/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;

public abstract class DHGN
extends KeyExchange {
    private static final int SSH_MSG_KEXDH_INIT = 30;
    private static final int SSH_MSG_KEXDH_REPLY = 31;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    byte[] e;
    private Buffer buf;
    private Packet packet;

    abstract byte[] G();

    abstract byte[] P();

    abstract String sha_name();

    @Override
    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        Class<?> c2;
        this.session = session;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        try {
            c2 = Class.forName(session.getConfig(this.sha_name()));
            this.sha = (HASH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.sha.init();
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        c2 = Class.forName(session.getConfig("dh"));
        this.dh = (DH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.dh.init();
        this.dh.setP(this.P());
        this.dh.setG(this.G());
        this.e = this.dh.getE();
        this.packet.reset();
        this.buf.putByte((byte)30);
        this.buf.putMPInt(this.e);
        if (V_S == null) {
            return;
        }
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEXDH_INIT sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEXDH_REPLY");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                int j2 = _buf.getInt();
                j2 = _buf.getByte();
                j2 = _buf.getByte();
                if (j2 != 31) {
                    System.err.println("type: must be 31 " + j2);
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] f2 = _buf.getMPInt();
                byte[] sig_of_H = _buf.getString();
                this.dh.setF(f2);
                this.dh.checkRange();
                this.K = this.normalize(this.dh.getK());
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(f2);
                this.buf.putMPInt(this.K);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.H = this.sha.digest();
                int i2 = 0;
                j2 = 0;
                j2 = this.K_S[i2++] << 24 & 0xFF000000 | this.K_S[i2++] << 16 & 0xFF0000 | this.K_S[i2++] << 8 & 0xFF00 | this.K_S[i2++] & 0xFF;
                String alg = Util.byte2str(this.K_S, i2, j2);
                boolean result = this.verify(alg, this.K_S, i2 += j2, sig_of_H);
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }
}

