/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;

public class DHGEX
extends KeyExchange {
    private static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    private static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    private static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    private static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    int min;
    int preferred;
    int max;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    protected String hash = "sha-1";

    @Override
    public void init(Session session, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        Class<?> c2;
        this.session = session;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        try {
            c2 = Class.forName(session.getConfig(this.hash));
            this.sha = (HASH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.sha.init();
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        c2 = Class.forName(session.getConfig("dh"));
        this.min = Integer.parseInt(session.getConfig("dhgex_min"));
        this.max = Integer.parseInt(session.getConfig("dhgex_max"));
        this.preferred = Integer.parseInt(session.getConfig("dhgex_preferred"));
        if (DHGEX.checkInvalidSize(this.min) || DHGEX.checkInvalidSize(this.max) || DHGEX.checkInvalidSize(this.preferred) || this.preferred < this.min || this.max < this.preferred) {
            throw new JSchException("Invalid DHGEX sizes: min=" + this.min + " max=" + this.max + " preferred=" + this.preferred);
        }
        this.dh = (DH)c2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.dh.init();
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(this.min);
        this.buf.putInt(this.preferred);
        this.buf.putInt(this.max);
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_REQUEST(" + this.min + "<" + this.preferred + "<" + this.max + ") sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_GROUP");
        }
        this.state = 31;
    }

    @Override
    public boolean next(Buffer _buf) throws Exception {
        switch (this.state) {
            case 31: {
                _buf.getInt();
                _buf.getByte();
                int j2 = _buf.getByte();
                if (j2 != 31) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_GROUP " + j2);
                    return false;
                }
                this.p = _buf.getMPInt();
                this.g = _buf.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_INIT sent");
                    JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_REPLY");
                }
                this.state = 33;
                return true;
            }
            case 33: {
                int j3 = _buf.getInt();
                j3 = _buf.getByte();
                j3 = _buf.getByte();
                if (j3 != 33) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_REPLY " + j3);
                    return false;
                }
                this.K_S = _buf.getString();
                byte[] f2 = _buf.getMPInt();
                byte[] sig_of_H = _buf.getString();
                this.dh.setF(f2);
                this.dh.checkRange();
                this.K = this.normalize(this.dh.getK());
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(this.min);
                this.buf.putInt(this.preferred);
                this.buf.putInt(this.max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(f2);
                this.buf.putMPInt(this.K);
                byte[] foo = new byte[this.buf.getLength()];
                this.buf.getByte(foo);
                this.sha.update(foo, 0, foo.length);
                this.H = this.sha.digest();
                int i2 = 0;
                j3 = 0;
                j3 = this.K_S[i2++] << 24 & 0xFF000000 | this.K_S[i2++] << 16 & 0xFF0000 | this.K_S[i2++] << 8 & 0xFF00 | this.K_S[i2++] & 0xFF;
                String alg = Util.byte2str(this.K_S, i2, j3);
                boolean result = this.verify(alg, this.K_S, i2 += j3, sig_of_H);
                this.state = 0;
                return result;
            }
        }
        return false;
    }

    @Override
    public int getState() {
        return this.state;
    }

    static boolean checkInvalidSize(int size) {
        return size < 1024 || size > 8192 || size % 1024 != 0;
    }
}

