/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class JOneServer
implements Runnable,
ActionListener,
KeyListener {
    public static final int PORT = 5866;
    public static final String VERSION = "2.1.2 (19.06.2014)";
    public static final double BUILD_REQUIRED = 2.1;
    public static final double SERVER_BUILD = 2.1;
    public static final int TYPE_PLAYING = 1;
    public static final int TYPE_NOTPLAYING = 2;
    public static final int TYPE_ALL = 3;
    public static final int RULE_ALLCARDS = 1;
    public static final int RULE_CUMULATECARDS = 2;
    private static final String MASTERSERVER_DELIM = "\u00a7";
    private static final String MASTERSERVER = "http://www.stefan1200.de/masterserverlist/jone.php";
    private static final String DEFAULT_SERVERNAME = "JOne Server";
    private final String CONFIG_FILE = "JOneServer.ini";
    private final String HOSTSYSTEM = System.getProperty("os.name");
    private ServerSocket listen;
    private Vector connections;
    static boolean DEBUG = false;
    static boolean TEXT = false;
    private Thread connect;
    private boolean useMasterserver = true;
    private String servername = null;
    private String welcomeMessage = null;
    private String password = null;
    private String lastScores = null;
    private String lastGameStatus = null;
    private Vector history = new Vector();
    private String lastHistory = "";
    private int historyPosPointer = -2;
    private AppTranslation lang = this.loadLanguage();
    private Timer heartbeatTimer = new Timer(120000, this);
    private Timer checkConnTimer = new Timer(2000, this);
    private JFrame frame;
    private JPanel pRoot;
    private JPanel pTop;
    private JToolBar tbButtons;
    private JToolBar tbButtonsPrefs;
    private JButton bStart;
    private JButton bStop;
    private JButton bINetIP;
    private JButton bSetPassword;
    private JButton bSetServername;
    private JButton bSetWelcomeMessage;
    private JButton bShowUsers;
    private JCheckBox cbUseMasterserver;
    private JTextArea taLog;
    private JTextField tfInput;
    private InternetIP iIP = new InternetIP();
    private GameRulesOne gRO = new GameRulesOne(this);
    PrintWriter pw;
    private long gameRules = 0L;
    static /* synthetic */ Class class$0;

    public JOneServer(boolean debug, boolean text, boolean min) {
        DEBUG = debug;
        TEXT = text;
        this.connections = new Vector();
        this.loadConfig();
        if (!TEXT) {
            try {
                this.frame = new JFrame();
                this.frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        JOneServer.this.confirmExit();
                    }
                });
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("JOneServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ImageIcon iiTitle = new ImageIcon(clazz.getResource("title.png"));
                    this.frame.setIconImage(iiTitle.getImage());
                }
                catch (Exception iiTitle) {
                    // empty catch block
                }
                this.pRoot = (JPanel)this.frame.getContentPane();
                this.pTop = new JPanel(new BorderLayout());
                this.tbButtons = new JToolBar();
                this.tbButtonsPrefs = new JToolBar();
                this.bStart = new JButton(this.lang.getTranslationString("StartServer", "Start Server"));
                this.bStop = new JButton(this.lang.getTranslationString("StopServer", "Stop Server"));
                this.bINetIP = new JButton(this.lang.getTranslationString("ShowInternetIP", "Show Internet IP"));
                this.bSetPassword = new JButton(this.lang.getTranslationString("SetAdminPW", "Admin PW"));
                this.bSetServername = new JButton(this.lang.getTranslationString("SetServername", "Servername"));
                this.bSetWelcomeMessage = new JButton(this.lang.getTranslationString("SetWelcomeMessage", "Welcome Message"));
                this.bShowUsers = new JButton(this.lang.getTranslationString("ShowUsers", "Show Users"));
                this.cbUseMasterserver = new JCheckBox(this.lang.getTranslationString("UseMasterserver", "Use masterserver"), this.useMasterserver);
                this.taLog = new JTextArea(String.valueOf(this.lang.getTranslationString("WelcomeTo", "Welcome to")) + " JOneServer " + VERSION);
                this.tfInput = new JTextField();
                this.bStart.addActionListener(this);
                this.bStart.setCursor(new Cursor(12));
                this.bStop.addActionListener(this);
                this.bStop.setCursor(new Cursor(12));
                this.bINetIP.addActionListener(this);
                this.bINetIP.setCursor(new Cursor(12));
                this.bSetPassword.addActionListener(this);
                this.bSetPassword.setToolTipText(this.lang.getTranslationString("AdminPWToolTip", "Set a admin password to use admin commands from the JOne Client!"));
                this.bSetPassword.setCursor(new Cursor(12));
                this.bSetServername.addActionListener(this);
                this.bSetServername.setToolTipText(this.lang.getTranslationString("ServernameToolTip", "Set a servername for the masterserver list and serverinfo command!"));
                this.bSetServername.setCursor(new Cursor(12));
                this.bSetWelcomeMessage.addActionListener(this);
                this.bSetWelcomeMessage.setToolTipText(this.lang.getTranslationString("WelcomeMessageToolTip", "Set a welcome message! Every connecting player can read this."));
                this.bSetWelcomeMessage.setCursor(new Cursor(12));
                this.bShowUsers.addActionListener(this);
                this.bShowUsers.setCursor(new Cursor(12));
                this.cbUseMasterserver.addActionListener(this);
                this.cbUseMasterserver.setCursor(new Cursor(12));
                this.taLog.setEditable(false);
                this.taLog.setOpaque(false);
                this.taLog.setTabSize(10);
                this.taLog.setLineWrap(true);
                this.taLog.setWrapStyleWord(true);
                this.tfInput.addActionListener(this);
                this.tfInput.addKeyListener(this);
                this.tbButtons.add(this.bStart);
                this.tbButtons.add(this.bStop);
                this.tbButtons.addSeparator();
                this.tbButtons.add(this.bINetIP);
                this.tbButtons.add(this.bShowUsers);
                this.tbButtonsPrefs.add(this.bSetPassword);
                this.tbButtonsPrefs.add(this.bSetServername);
                this.tbButtonsPrefs.add(this.bSetWelcomeMessage);
                this.tbButtonsPrefs.add(this.cbUseMasterserver);
                this.pTop.add((Component)this.tbButtons, "North");
                this.pTop.add((Component)this.tbButtonsPrefs, "South");
                this.pRoot.setLayout(new BorderLayout());
                this.pRoot.add((Component)this.pTop, "North");
                this.pRoot.add((Component)new JScrollPane(this.taLog), "Center");
                this.pRoot.add((Component)this.tfInput, "South");
                if (DEBUG) {
                    this.addLogEntry("Debug Mode activated!");
                }
            }
            catch (InternalError e) {
                text = true;
                TEXT = true;
                this.showWelcomeMessage();
                System.out.println("Switching to text mode: " + e.toString());
            }
            catch (HeadlessException e2) {
                text = true;
                TEXT = true;
                this.showWelcomeMessage();
                System.out.println("Switching to text mode: " + e2.toString());
            }
        } else {
            this.showWelcomeMessage();
        }
        if (this.password == null && TEXT) {
            this.askPasswordTextMode();
            if (this.password == null) {
                if (this.pw != null) {
                    this.pw.close();
                }
                System.exit(0);
            }
        }
        if (this.servername == null && TEXT) {
            this.askServerNameTextMode();
        } else if (this.servername == null) {
            this.servername = DEFAULT_SERVERNAME;
        }
        this.heartbeatTimer.setRepeats(true);
        this.checkConnTimer.setRepeats(true);
        if (min) {
            this.bStart.doClick();
        } else if (TEXT) {
            this.startServer();
        }
        if (!TEXT) {
            this.frame.setSize(640, 400);
            this.frame.setTitle("JOneServer 2.1.2 (19.06.2014) by Smart Software Development");
            if (min) {
                this.frame.setVisible(true);
                this.frame.setState(1);
            } else if (!min) {
                this.frame.setVisible(true);
            }
        }
    }

    private void showWelcomeMessage() {
        this.addLogEntry(String.valueOf(this.lang.getTranslationString("WelcomeTo", "Welcome to")) + " JOneServer " + VERSION);
    }

    private void confirmExit() {
        int ret = 0;
        if (this.connections.size() > 0) {
            ret = JOptionPane.showConfirmDialog(this.frame, this.lang.getTranslationString("ReallyQuit", "Really quit?"), this.lang.getTranslationString("Notice", "Notice"), 0);
        }
        if (ret == 0) {
            System.exit(0);
        }
    }

    private void askPasswordTextMode() {
        block6: {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String tmp = null;
            while (true) {
                System.out.println(this.lang.getTranslationString("PleaseEnterNewPassword", "Please enter the new password!"));
                System.out.println(this.lang.getTranslationString("PasswordVisibleWhileTyping", "The password is visible while typing!"));
                System.out.println(this.lang.getTranslationString("NoPasswordToDisable", "Enter no password to disable the client admin mode!"));
                try {
                    System.out.print(String.valueOf(this.lang.getTranslationString("Input", "Input:")) + " ");
                    tmp = br.readLine();
                }
                catch (Exception e) {
                    this.printDebugLog(e);
                }
                if (tmp == null) {
                    this.addLogEntry(this.lang.getTranslationString("AbortedPasswordChange", "Aborted, password not changed!"));
                    break block6;
                }
                if (tmp.length() > 5) {
                    this.saveAdminPassword(tmp);
                    this.addLogEntry(this.lang.getTranslationString("PasswordSuccessfully", "Password successfully changed!"));
                    break block6;
                }
                if (tmp.length() > 0) {
                    this.addLogEntry(this.lang.getTranslationString("PasswordTooShort", "Password too short, password not changed!"));
                    this.addLogEntry("");
                    continue;
                }
                if (tmp.length() == 0) break;
            }
            this.saveAdminPassword(null);
            this.addLogEntry(this.lang.getTranslationString("NoPasswordEntered", "No password entered, client admin mode now disabled!"));
        }
    }

    private void askServerNameTextMode() {
        block8: {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String tmp = null;
            while (true) {
                System.out.println(this.lang.getTranslationString("PleaseEnterNewServername", "Please enter the new server name!"));
                System.out.println(this.lang.getTranslationString("NoServernameToUseDefault", "Enter no server name to use default server name!"));
                System.out.println("");
                try {
                    System.out.print(String.valueOf(this.lang.getTranslationString("Input", "Input:")) + " ");
                    tmp = br.readLine();
                }
                catch (Exception e) {
                    this.printDebugLog(e);
                }
                if (tmp == null) {
                    this.addLogEntry(this.lang.getTranslationString("AbortedServernameChange", "Aborted, server name not changed!"));
                    break block8;
                }
                if (tmp.indexOf(MASTERSERVER_DELIM) != -1) {
                    this.addLogEntry(String.valueOf(this.lang.getTranslationString("ServernameCharNotAllowed", "Char in server name not allowed:")) + " " + MASTERSERVER_DELIM);
                    this.addLogEntry("");
                    continue;
                }
                if (tmp.length() > 50) {
                    this.addLogEntry(this.lang.getTranslationString("ServernameTooLong", "Server name too long, server name not changed!"));
                    continue;
                }
                if (tmp.length() > 3) {
                    this.saveServername(tmp);
                    this.addLogEntry(this.lang.getTranslationString("ServernameSuccessfully", "Server name successfully changed!"));
                    break block8;
                }
                if (tmp.length() > 0) {
                    this.addLogEntry(this.lang.getTranslationString("ServernameTooShort", "Server name too short, server name not changed!"));
                    this.addLogEntry("");
                    continue;
                }
                if (tmp.length() == 0) break;
            }
            this.saveServername(DEFAULT_SERVERNAME);
            this.addLogEntry(String.valueOf(this.lang.getTranslationString("NoServernameEntered", "No server name entered, using default name:")) + " " + DEFAULT_SERVERNAME);
        }
    }

    private void initDebugLog() {
        try {
            this.pw = new PrintWriter(new FileWriter("JOneServer-Debug.log", true));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void printDebugLog(Exception e) {
        if (this.pw == null) {
            this.initDebugLog();
        }
        try {
            GregorianCalendar cal = new GregorianCalendar();
            this.pw.println(cal.getTime());
            this.pw.println(this.HOSTSYSTEM);
            this.pw.println("Start directory: " + System.getProperty("user.dir"));
            this.pw.println("JOneServer Version 2.1.2 (19.06.2014)");
            e.printStackTrace(this.pw);
            this.pw.println("");
            this.pw.flush();
        }
        catch (Exception ex) {
            e.printStackTrace();
        }
    }

    private AppTranslation loadLanguage() {
        AppTranslation tmp = new AppTranslation();
        tmp.setLanguageDirectory("Languages");
        tmp.setLanguageFilePrefix("JOne_");
        tmp.setLanguageFileSuffix(".lng");
        tmp.loadTranslation();
        return tmp;
    }

    String getServerName() {
        return this.servername;
    }

    String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    String setServerName(String newName) {
        if (newName == null) {
            return "Aborted, server name not changed!";
        }
        if (newName.indexOf(MASTERSERVER_DELIM) != -1) {
            return "Char in server name not allowed: \u00a7";
        }
        if (newName.length() > 3) {
            this.saveServername(newName);
            return "Server name successfully changed!";
        }
        if (newName.length() > 0) {
            return "Server name too short, server name not changed!";
        }
        if (newName.length() == 0) {
            this.saveServername(DEFAULT_SERVERNAME);
            return "No server name entered, using default name: JOne Server";
        }
        return "An error occurred!";
    }

    String setWelcomeMessage(String newWelcome) {
        if (newWelcome == null) {
            return "Aborted, welcome message not changed!";
        }
        if (newWelcome.length() > 0) {
            this.saveWelcomeMessage(newWelcome);
            return "Welcome message successfully changed!";
        }
        if (newWelcome.length() == 0) {
            this.saveWelcomeMessage(null);
            return "No welcome message entered, its now disabled!";
        }
        return "An error occurred!";
    }

    boolean setGameRule(String ruleName) {
        if (ruleName.equalsIgnoreCase("cumulate")) {
            this.gameRules |= 2L;
            this.saveConfig();
            return true;
        }
        return false;
    }

    boolean removeGameRule(String ruleName) {
        if (ruleName.equalsIgnoreCase("cumulate")) {
            this.gameRules &= 0xFFFFFFFFFFFFFFFDL;
            this.saveConfig();
            return true;
        }
        return false;
    }

    int getPlayerCount() {
        return this.getPlayerCount(1);
    }

    int getPlayerCount(int type) {
        return this.getNickNames(type).size();
    }

    Vector getConnections() {
        return this.connections;
    }

    void setScoreboard(String newScores) {
        if (DEBUG) {
            this.addLogEntry("Setting new lastScores: " + newScores);
        }
        this.lastScores = newScores;
    }

    String getScoreboard() {
        return this.lastScores;
    }

    void setGameStatus(String newStatus) {
        this.lastGameStatus = newStatus;
    }

    String getGameStatus() {
        return this.lastGameStatus;
    }

    void goOffline() {
        if (this.connect != null) {
            this.connect.interrupt();
        }
    }

    void addLogEntry(String msg) {
        if (TEXT) {
            System.out.println(msg);
        } else {
            this.taLog.setText(String.valueOf(this.taLog.getText()) + "\n" + msg);
            this.taLog.setCaretPosition(this.taLog.getText().length() - 1);
        }
    }

    void addLogEntry(String prefix, String msg) {
        if (TEXT) {
            System.out.println(String.valueOf(prefix) + "\t" + msg);
        } else {
            this.taLog.setText(String.valueOf(this.taLog.getText()) + "\n" + prefix + "\t" + msg);
            this.taLog.setCaretPosition(this.taLog.getText().length() - 1);
        }
    }

    boolean isNickAllowed(String nick) {
        Vector nickNames = this.getNickNames(3);
        if (nickNames.indexOf(nick) != -1) {
            return false;
        }
        if (nick.equals("Unknown")) {
            return false;
        }
        if (nick.indexOf("?") != -1) {
            return false;
        }
        if (nick.indexOf("+") != -1) {
            return false;
        }
        if (nick.length() < 3) {
            return false;
        }
        if (nick.length() > 20) {
            return false;
        }
        return !nick.startsWith(" ");
    }

    private void startServer() {
        if (TEXT) {
            System.out.println(String.valueOf(this.lang.getTranslationString("ServerStartedPort", "Server started at port")) + " " + Integer.toString(5866) + " " + this.lang.getTranslationString("On", "on") + "\n" + this.getLocalIPAddresses());
        } else {
            this.taLog.setText(String.valueOf(this.lang.getTranslationString("ServerStartedPort", "Server started at port")) + " " + Integer.toString(5866) + " " + this.lang.getTranslationString("On", "on") + "\n" + this.getLocalIPAddresses());
        }
        try {
            this.listen = new ServerSocket(5866);
            this.connect = new Thread(this);
            this.connect.start();
        }
        catch (IOException ex) {
            this.printDebugLog(ex);
            this.addLogEntry(String.valueOf(this.lang.getTranslationString("ErrorCreatingSocket", "Error while creating socket:")) + " " + ex);
        }
    }

    void showServerOldMessage() {
        this.addLogEntry(this.lang.getTranslationString("ServerOldMessage", "Client disconnected, Server Version to old."));
    }

    private void showHelp() {
        this.addLogEntry("/help\t" + this.lang.getTranslationString("ShowHelp", "Show this help."));
        this.addLogEntry("/listrules\t" + this.lang.getTranslationString("ListGameRules", "List all possible game rules!"));
        this.addLogEntry("/kick <nickname>\t" + this.lang.getTranslationString("KickPlayer", "Kick the player from the server."));
        this.addLogEntry("/ping\t" + this.lang.getTranslationString("PingToClients", "Send a ping to all connected clients."));
        this.addLogEntry("/reloadcfg\t" + this.lang.getTranslationString("ReloadConfig", "Reload the config file."));
        this.addLogEntry("/removerule <rulename>\t" + this.lang.getTranslationString("RemoveGameRule", "Removes a game rule, see /listrules"));
        this.addLogEntry("/setrule <rulename>\t" + this.lang.getTranslationString("SetGameRule", "Sets a new game rule, see /listrules"));
        this.addLogEntry("/showrules\t" + this.lang.getTranslationString("ShowGameRules", "Shows activated game rules!"));
        this.addLogEntry("/showusers\t" + this.lang.getTranslationString("ShowPlayerInfo", "Show informations about all connected players on this server."));
        this.addLogEntry("/servername\t" + this.lang.getTranslationString("ShowCurrentServername", "Shows current server name!"));
        this.addLogEntry("/welcomemsg\t" + this.lang.getTranslationString("ShowCurrentWelcomeMessage", "Shows current welcome message!"));
    }

    String getAdminPassword() {
        return this.password;
    }

    void loadConfig() {
        File checkConfig = new File("JOneServer.ini");
        if (checkConfig.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(checkConfig));
            }
            catch (Exception e) {
                this.printDebugLog(e);
            }
            String tmp = prop.getProperty("AuthKey");
            this.servername = prop.getProperty("ServerName");
            this.welcomeMessage = prop.getProperty("WelcomeMessage");
            this.useMasterserver = Boolean.parseBoolean(prop.getProperty("UseMasterserver", "true"));
            this.gameRules = Long.parseLong(prop.getProperty("GameRules", "0"));
            if (tmp != null) {
                this.password = this.cryptIt(tmp, 10);
            }
            prop.clear();
            Object var2_2 = null;
        }
    }

    private void saveAdminPassword(String password) {
        this.password = password;
        this.saveConfig();
    }

    private void saveServername(String servername) {
        this.servername = servername;
        this.saveConfig();
    }

    private void saveWelcomeMessage(String welcomeMessage) {
        this.welcomeMessage = welcomeMessage;
        this.saveConfig();
    }

    private void saveConfig() {
        Properties prop = new Properties();
        if (this.password != null) {
            prop.setProperty("AuthKey", this.cryptIt(this.password, 10));
        }
        if (this.servername != null) {
            prop.setProperty("ServerName", this.servername);
        }
        if (this.welcomeMessage != null) {
            prop.setProperty("WelcomeMessage", this.welcomeMessage);
        }
        prop.setProperty("UseMasterserver", Boolean.toString(this.useMasterserver));
        prop.setProperty("GameRules", Long.toString(this.gameRules));
        try {
            String lineBreak = System.getProperty("line.separator", "\n");
            prop.store(new FileOutputStream("JOneServer.ini", false), "JOneServer 2.1.2 (19.06.2014)" + lineBreak + lineBreak + "Configuration file information:" + lineBreak + lineBreak + "UseMasterserver=true" + lineBreak + " - Enable or disable the masterserver list entry! true means the server is globaly listed, false means not!" + lineBreak + "ServerName=MyJOneServer" + lineBreak + " - This sets the servername, used for masterserver list and the /serverinfo command!" + lineBreak + "WelcomeMessage=Hello\u00a7Have fun!" + lineBreak + " - Sets the welcome message for joining players. Use the char \u00a7 to create a line break!" + lineBreak + "GameRules=0" + lineBreak + " - Sets the game rules! You can disable all game rules by setting it to 0." + lineBreak + " - Do all other game rule changes only ingame with the RCon commands /setrule and /removerule!" + lineBreak + "AuthKey=???" + lineBreak + " - This is the encrypted server password to use RCon commands!" + lineBreak + " - Do not change the AuthKey! If you want to change the password, delete the line and start JOneServer!" + lineBreak);
        }
        catch (Exception e) {
            this.printDebugLog(e);
            this.addLogEntry(this.lang.getTranslationString("CantSaveConfig", "Can't save config, please check write access!"));
        }
        prop.clear();
        prop = null;
    }

    private String cryptIt(String msg, int key) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            int i = 0;
            while (i < msg.length()) {
                pw.print((char)(msg.charAt(i) ^ key));
                ++i;
            }
        }
        catch (Exception e) {
            this.printDebugLog(e);
        }
        msg = sw.toString();
        pw.close();
        return msg;
    }

    String kickUser(String name) {
        String retValue = null;
        Vector nickNames = this.getNickNames(3);
        if (nickNames.indexOf(name) != -1) {
            this.broadcast("601 kick" + name);
            int i = 0;
            while (i < this.connections.size()) {
                Connection you = (Connection)this.connections.elementAt(i);
                if (you.getNickName().equals(name)) {
                    you.send("600");
                    you.startDisconnectTimer();
                    retValue = "Kick user request for nick \"" + name + "\" sent!";
                    break;
                }
                ++i;
            }
            if (retValue == null) {
                retValue = "Unable to kick nick \"" + name + "\"!";
            }
        } else {
            retValue = "Nick \"" + name + "\" was not found on this server!";
        }
        return retValue;
    }

    String showUsers() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            sb.append(you.getNickName());
            sb.append("\t");
            sb.append(you.getIPAddress());
            sb.append("\t");
            sb.append(you.getVersionInfo());
            sb.append("\t");
            sb.append(String.valueOf(you.getRounds()) + " " + this.lang.getTranslationString("RoundsPlayed", "Rounds played"));
            sb.append("\n");
            ++i;
        }
        if (sb.length() < 1) {
            sb.append(this.lang.getTranslationString("NoUsersOnline", "No Users online..."));
        }
        return sb.toString();
    }

    long getGameRules() {
        return this.gameRules;
    }

    private String getOneUp() {
        String tmp = "";
        if (this.history.size() > 0 && this.historyPosPointer >= -2) {
            if (this.historyPosPointer == -2) {
                this.historyPosPointer = this.history.size() - 1;
                tmp = this.history.lastElement().toString();
            } else if (this.history.size() == 1) {
                tmp = this.history.lastElement().toString();
            } else if (this.historyPosPointer <= this.history.size() && this.historyPosPointer > 0) {
                try {
                    tmp = this.history.elementAt(--this.historyPosPointer).toString();
                }
                catch (Exception e) {
                    tmp = "";
                }
            } else if (this.historyPosPointer == 0) {
                --this.historyPosPointer;
            }
        }
        return tmp;
    }

    private String getOneDown() {
        String tmp = "";
        if (this.history.size() > 0 && this.historyPosPointer < this.history.size()) {
            if (this.history.size() == 1) {
                tmp = this.history.lastElement().toString();
            } else if (this.historyPosPointer != -2) {
                if (this.historyPosPointer >= -1 && this.historyPosPointer < this.history.size() - 1) {
                    try {
                        tmp = this.history.elementAt(++this.historyPosPointer).toString();
                    }
                    catch (Exception e) {
                        tmp = "";
                    }
                } else if (this.historyPosPointer < this.history.size()) {
                    if (!this.history.lastElement().toString().equals(this.lastHistory)) {
                        tmp = this.lastHistory;
                    }
                    ++this.historyPosPointer;
                }
            }
        }
        return tmp;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.historyPosPointer == -2 && this.tfInput.getText().length() > 0) {
                this.lastHistory = this.tfInput.getText();
            }
            this.tfInput.setText(this.getOneUp());
        } else if (e.getKeyCode() == 40) {
            if (this.historyPosPointer == -2) {
                this.lastHistory = this.tfInput.getText();
            }
            this.tfInput.setText(this.getOneDown());
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bStart)) {
            if (this.connect != null) {
                if (!this.connect.isAlive()) {
                    this.startServer();
                } else {
                    this.addLogEntry(this.lang.getTranslationString("ServerRunning", "Server already running!"));
                }
            } else {
                this.startServer();
            }
            this.tfInput.requestFocus();
        } else if (e.getSource().equals(this.bStop)) {
            if (this.connect != null) {
                this.connect.interrupt();
            }
            this.connect = null;
            this.tfInput.requestFocus();
        } else if (e.getSource().equals(this.bSetPassword)) {
            String tmp = JOptionPane.showInputDialog(this.frame, String.valueOf(this.lang.getTranslationString("PleaseEnterNewPassword", "Please enter the new password!")) + "\n" + this.lang.getTranslationString("PasswordVisibleWhileTyping", "The password is visible while typing!") + "\n" + this.lang.getTranslationString("NoPasswordToDisable", "Enter no password to disable the client admin mode!"), this.lang.getTranslationString("ClientAdminModePW", "Client Admin Mode Password"), 3);
            if (tmp == null) {
                this.addLogEntry(this.lang.getTranslationString("AbortedPasswordChange", "Aborted, password not changed!"));
            } else if (tmp.length() > 5) {
                this.saveAdminPassword(tmp);
                this.addLogEntry(this.lang.getTranslationString("PasswordSuccessfully", "Password successfully changed!"));
            } else if (tmp.length() > 0) {
                this.addLogEntry(this.lang.getTranslationString("PasswordTooShort", "Password too short, password not changed!"));
            } else if (tmp.length() == 0) {
                this.saveAdminPassword(null);
                this.addLogEntry(this.lang.getTranslationString("NoPasswordEntered", "No password entered, client admin mode now disabled!"));
            }
        } else if (e.getSource().equals(this.bSetServername)) {
            String tmp = JOptionPane.showInputDialog(this.frame, String.valueOf(this.lang.getTranslationString("PleaseEnterNewServername", "Please enter the new server name!")) + "\n" + this.lang.getTranslationString("NoServernameToUseDefault", "Enter no server name to use default server name!"), this.lang.getTranslationString("Servername", "Server name"), 3);
            if (tmp == null) {
                this.addLogEntry(this.lang.getTranslationString("AbortedServernameChange", "Aborted, server name not changed!"));
            } else if (tmp.indexOf(MASTERSERVER_DELIM) != -1) {
                this.addLogEntry(String.valueOf(this.lang.getTranslationString("ServernameCharNotAllowed", "Char in server name not allowed:")) + " " + MASTERSERVER_DELIM);
            } else if (tmp.length() > 50) {
                this.addLogEntry(this.lang.getTranslationString("ServernameTooLong", "Server name too long, server name not changed!"));
            } else if (tmp.length() > 3) {
                this.saveServername(tmp);
                this.addLogEntry(this.lang.getTranslationString("ServernameSuccessfully", "Server name successfully changed!"));
            } else if (tmp.length() > 0) {
                this.addLogEntry(this.lang.getTranslationString("ServernameTooShort", "Server name too short, server name not changed!"));
            } else if (tmp.length() == 0) {
                this.saveServername(DEFAULT_SERVERNAME);
                this.addLogEntry(String.valueOf(this.lang.getTranslationString("NoServernameEntered", "No server name entered, using default name:")) + " " + DEFAULT_SERVERNAME);
            }
        } else if (e.getSource().equals(this.bSetWelcomeMessage)) {
            String tmp = JOptionPane.showInputDialog(this.frame, String.valueOf(this.lang.getTranslationString("PleaseEnterNewWelcomeMessage", "Please enter the new welcome message!")) + "\n" + this.lang.getTranslationString("NoWelcomeMessageToUseDefault", "Enter no welcome message to disable it!"), this.lang.getTranslationString("WelcomeMessage", "Welcome Message"), 3);
            if (tmp == null) {
                this.addLogEntry(this.lang.getTranslationString("AbortedWelcomeMessageChange", "Aborted, welcome message not changed!"));
            } else if (tmp.length() > 0) {
                this.saveWelcomeMessage(tmp);
                this.addLogEntry(this.lang.getTranslationString("WelcomeMessageSuccessfully", "Welcome message successfully changed!"));
            } else if (tmp.length() == 0) {
                this.saveWelcomeMessage(null);
                this.addLogEntry(this.lang.getTranslationString("NoWelcomeMessageEntered", "No welcome message entered, its now disabled!"));
            }
        } else if (e.getSource().equals(this.cbUseMasterserver)) {
            this.useMasterserver = this.cbUseMasterserver.isSelected();
            this.saveConfig();
        } else if (e.getSource().equals(this.bINetIP)) {
            this.bINetIP.setCursor(new Cursor(3));
            String tmp = this.iIP.getInternetIP();
            this.bINetIP.setCursor(new Cursor(0));
            if (tmp != null) {
                this.addLogEntry(String.valueOf(this.lang.getTranslationString("YourIPIs", "Your Internet IP is:")) + "\n" + tmp);
            } else {
                this.addLogEntry(this.lang.getTranslationString("NoInternetIP", "Sorry, your Internet IP could not be determined!"));
            }
            this.tfInput.requestFocus();
        } else if (e.getSource().equals(this.bShowUsers)) {
            this.addLogEntry(this.showUsers());
        } else if (e.getSource().equals(this.heartbeatTimer)) {
            try {
                String result = this.sendHTTPReqest("http://www.stefan1200.de/masterserverlist/jone.php?mode=serverheartbeat&servername=" + URLEncoder.encode(this.servername, "UTF-8") + "&player=" + Integer.toString(this.getPlayerCount(3)) + "&gametype=" + Long.toString(this.gameRules) + "&version=" + Double.toString(2.1));
                this.addLogEntry(String.valueOf(this.lang.getTranslationString("SentHeartbeat", "Heartbeat sent to Masterserver, result:")) + " " + result);
            }
            catch (Exception result) {}
        } else if (e.getSource().equals(this.checkConnTimer)) {
            this.checkConnections();
        } else if (e.getSource().equals(this.tfInput)) {
            if (this.tfInput.getText().length() > 250) {
                this.addLogEntry(this.lang.getTranslationString("TextToLong", "Text line to long!"));
            } else if (this.tfInput.getText().length() > 0) {
                this.history.addElement(this.tfInput.getText());
                this.historyPosPointer = -2;
                if (this.tfInput.getText().toLowerCase().startsWith("/showusers")) {
                    this.addLogEntry(this.showUsers());
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/help")) {
                    this.showHelp();
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/servername")) {
                    this.addLogEntry(String.valueOf(this.lang.getTranslationString("CurrentServername", "Current servername:")) + " " + this.servername);
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/welcomemsg")) {
                    this.addLogEntry(this.lang.getTranslationString("CurrentWelcomeMessage", "Current welcome message:"));
                    if (this.welcomeMessage == null) {
                        this.addLogEntry(this.lang.getTranslationString("WelcomeDisabled", "Welcome Message disabled!"));
                    } else {
                        StringTokenizer stMSG = new StringTokenizer(this.welcomeMessage, MASTERSERVER_DELIM, false);
                        while (stMSG.hasMoreTokens()) {
                            this.addLogEntry(stMSG.nextToken());
                        }
                    }
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/?")) {
                    this.showHelp();
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/showrules")) {
                    this.tfInput.setText("");
                    this.addLogEntry(this.lang.getTranslationString("ShowCurrentGameRules", "Following rules are currently activated (maybe not for the current round):"));
                    if ((this.gameRules & 1L) == 1L) {
                        this.addLogEntry(this.lang.getTranslationString("AcceptAllCards", "Allow to cheat with wrong cards!"));
                    }
                    if ((this.gameRules & 2L) == 2L) {
                        this.addLogEntry(this.lang.getTranslationString("CumulateCards", "Allow to cumulate 2+ or 4+ cards!"));
                    }
                    if (this.gameRules == 0L) {
                        this.addLogEntry(this.lang.getTranslationString("NoRules", "No rules activated!"));
                    }
                } else if (this.tfInput.getText().toLowerCase().startsWith("/listrules")) {
                    this.tfInput.setText("");
                    this.addLogEntry(this.lang.getTranslationString("RuleListInfo", "The following game rules are possible for /setrule and /removerule commands:"));
                    this.addLogEntry("cumulate - " + this.lang.getTranslationString("CumulateCards", "Allow to cumulate 2+ or 4+ cards!"));
                } else if (this.tfInput.getText().toLowerCase().startsWith("/setrule")) {
                    String ruleName = this.tfInput.getText().substring("/setrule ".length());
                    if (this.setGameRule(ruleName)) {
                        this.addLogEntry(this.lang.getTranslationString("RulesChanged", "Game rules changed for next game round!"));
                    } else {
                        this.addLogEntry(this.lang.getTranslationString("RuleNotFound", "Game rule not found!"));
                    }
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/removerule")) {
                    String ruleName = this.tfInput.getText().substring("/removerule ".length());
                    if (this.removeGameRule(ruleName)) {
                        this.addLogEntry(this.lang.getTranslationString("RulesChanged", "Game rules changed for next game round!"));
                    } else {
                        this.addLogEntry(this.lang.getTranslationString("RuleNotFound", "Game rule not found!"));
                    }
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/ping")) {
                    this.addLogEntry(this.lang.getTranslationString("SendingPing", "Sending ping to all connected clients..."));
                    this.broadcast("107 ");
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/kick ")) {
                    this.addLogEntry(this.kickUser(this.tfInput.getText().substring(6)));
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/reloadcfg")) {
                    this.loadConfig();
                    this.addLogEntry(this.lang.getTranslationString("ConfigReloaded", "Config file reloaded!"));
                    this.tfInput.setText("");
                } else if (this.tfInput.getText().toLowerCase().startsWith("/")) {
                    this.addLogEntry(String.valueOf(this.lang.getTranslationString("UnknownCommand", "Unknown command! Try")) + " /help!");
                } else {
                    if (DEBUG) {
                        this.broadcast(this.tfInput.getText());
                        this.addLogEntry(this.tfInput.getText());
                    } else {
                        this.broadcast("101 JOneServer?" + this.tfInput.getText());
                        this.addLogEntry("JOneServer\t" + this.tfInput.getText());
                    }
                    this.tfInput.setText("");
                }
            }
            this.tfInput.requestFocus();
        }
    }

    public void run() {
        String result;
        boolean currentMasterserver;
        block14: {
            this.checkConnTimer.start();
            currentMasterserver = this.useMasterserver;
            if (currentMasterserver) {
                this.heartbeatTimer.start();
                try {
                    result = this.sendHTTPReqest("http://www.stefan1200.de/masterserverlist/jone.php?mode=addserver&servername=" + URLEncoder.encode(this.servername, "UTF-8") + "&player=" + Integer.toString(this.getPlayerCount(3)) + "&gametype=" + Long.toString(this.gameRules) + "&version=" + Double.toString(2.1));
                    this.addLogEntry(String.valueOf(this.lang.getTranslationString("SentToMasterserver", "Server sent to masterserver list, result:")) + " " + result);
                }
                catch (Exception result2) {
                    // empty catch block
                }
            }
            try {
                this.listen.setSoTimeout(1000);
                block8: while (true) {
                    try {
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                this.closeAllClients();
                                break block8;
                            }
                            Socket client = this.listen.accept();
                            if (this.connections.size() >= 10) {
                                new Connection(this, client, this.lang, true);
                                continue;
                            }
                            Connection c = new Connection(this, client, this.lang, false);
                            this.connections.addElement(c);
                        }
                    }
                    catch (SocketTimeoutException client) {
                        continue;
                    }
                    break;
                }
                this.listen.close();
            }
            catch (IOException e) {
                this.printDebugLog(e);
                if (!DEBUG) break block14;
                System.err.println("Fehler beim Warten auf Verbindungen: " + e);
            }
        }
        if (currentMasterserver) {
            this.heartbeatTimer.stop();
            try {
                result = this.sendHTTPReqest("http://www.stefan1200.de/masterserverlist/jone.php?mode=removeserver");
                this.addLogEntry(String.valueOf(this.lang.getTranslationString("RemovedFromMasterserver", "Server removed from masterserver list, result:")) + " " + result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addLogEntry(this.lang.getTranslationString("ServerStopped", "Server stopped..."));
        this.checkConnTimer.stop();
    }

    private String getLocalIPAddresses() {
        StringBuffer addresses;
        block4: {
            addresses = new StringBuffer();
            try {
                InetAddress[] ia = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                int i = 0;
                while (i < ia.length) {
                    if (i > 0) {
                        addresses.append(" / ");
                    }
                    String tmp = ia[i].toString();
                    addresses.append(tmp.substring(tmp.indexOf("/") + 1));
                    ++i;
                }
            }
            catch (Exception e) {
                this.printDebugLog(e);
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return addresses.toString();
    }

    private void closeAllClients() {
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            you.send("600");
            you.startDisconnectTimer();
            ++i;
        }
    }

    void refreshLists() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            if (!you.isPlaying()) {
                if (i > 0) {
                    sb.append("?");
                }
                sb.append(you.getNickName());
                sb.append("+");
                sb.append(you.isReady());
            }
            ++i;
        }
        this.broadcast("103 " + sb.toString());
    }

    String getPlayerList() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            if (i > 0) {
                sb.append("?");
            }
            sb.append(you.getNickName());
            sb.append("+");
            sb.append(you.isReady());
            ++i;
        }
        return sb.toString();
    }

    Vector getNickNames(int type) {
        Vector<String> nicktmp = new Vector<String>();
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            if (type == 3 || (!you.isPlaying() || type != 2) && (you.isPlaying() || type != 1)) {
                nicktmp.addElement(you.getNickName());
            }
            ++i;
        }
        return nicktmp;
    }

    void handlePlayerAction(Connection player, int card) {
        this.gRO.checkAction(player, card);
    }

    void checkReady() {
        this.gRO.checkReady();
    }

    private void checkConnections() {
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            if (!you.isAlive() || !you.isOnline()) {
                if (DEBUG) {
                    System.out.println("Remove dead connection from player " + you.getNickName());
                }
                this.handleLeavingPlayer(you);
                you.startDisconnectTimer();
                this.connections.removeElementAt(i);
                this.gRO.checkRunningGame();
                this.gRO.checkReady();
                --i;
            }
            ++i;
        }
    }

    Connection getConnectionFromNick(String nickname) {
        Connection retValue = null;
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            if (you.getNickName().equals(nickname)) {
                retValue = you;
                break;
            }
            ++i;
        }
        return retValue;
    }

    void delConnection(Connection frame) {
        this.handleLeavingPlayer(frame);
        this.connections.removeElement(frame);
        this.gRO.checkRunningGame();
        this.gRO.checkReady();
    }

    void handleLeavingPlayer(Connection you) {
        this.gRO.handleLeavingPlayer(you);
    }

    public void broadcast(String msg) {
        int i = 0;
        while (i < this.connections.size()) {
            Connection you = (Connection)this.connections.elementAt(i);
            you.send(msg);
            ++i;
        }
    }

    private String sendHTTPReqest(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setRequestMethod("GET");
            httpCon.setUseCaches(false);
            if (httpCon.getResponseCode() == 200) {
                String line;
                StringBuffer sb = new StringBuffer();
                BufferedReader br = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("<br")) break;
                    sb.append(line);
                }
                br.close();
                return sb.toString();
            }
            return "ERROR";
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    public static void main(String[] args) {
        boolean debugValue = false;
        boolean textValue = false;
        boolean minValue = false;
        if (args != null && args.length > 0) {
            if (args[0].equalsIgnoreCase("/debug") || args[0].equalsIgnoreCase("-debug") || args[0].equalsIgnoreCase("-d")) {
                debugValue = true;
            } else if (args[0].equalsIgnoreCase("/text") || args[0].equalsIgnoreCase("-text") || args[0].equalsIgnoreCase("-t")) {
                textValue = true;
            } else if (args[0].equalsIgnoreCase("/min") || args[0].equalsIgnoreCase("-min") || args[0].equalsIgnoreCase("-m")) {
                minValue = true;
            } else {
                if (args[0].equalsIgnoreCase("/help") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-h")) {
                    System.out.println("JOneServer Version 2.1.2 (19.06.2014)");
                    System.out.println(JOneServer.showArgsHelp());
                    return;
                }
                System.out.println("JOneServer Version 2.1.2 (19.06.2014)");
                System.out.println(JOneServer.showArgsHelp());
                return;
            }
        }
        new JOneServer(debugValue, textValue, minValue);
    }

    private static String showArgsHelp() {
        return "/help\tShows this help text.\n/text\tEnables the text mode without gui.\n/min\tStarts the server and minimizes the gui on start.";
    }
}

