/*
 * Decompiled with CFR 0.152.
 */
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Vector;

class GameRulesOne {
    static final short RED_0 = 0;
    static final short RED_1 = 1;
    static final short RED_2 = 2;
    static final short RED_3 = 3;
    static final short RED_4 = 4;
    static final short RED_5 = 5;
    static final short RED_6 = 6;
    static final short RED_7 = 7;
    static final short RED_8 = 8;
    static final short RED_9 = 9;
    static final short RED_DRAWTWO = 10;
    static final short RED_LEFTRIGHT = 11;
    static final short RED_SKIP = 12;
    static final short RED_BLANK = 13;
    static final short YELLOW_0 = 14;
    static final short YELLOW_1 = 15;
    static final short YELLOW_2 = 16;
    static final short YELLOW_3 = 17;
    static final short YELLOW_4 = 18;
    static final short YELLOW_5 = 19;
    static final short YELLOW_6 = 20;
    static final short YELLOW_7 = 21;
    static final short YELLOW_8 = 22;
    static final short YELLOW_9 = 23;
    static final short YELLOW_DRAWTWO = 24;
    static final short YELLOW_LEFTRIGHT = 25;
    static final short YELLOW_SKIP = 26;
    static final short YELLOW_BLANK = 27;
    static final short BLUE_0 = 28;
    static final short BLUE_1 = 29;
    static final short BLUE_2 = 30;
    static final short BLUE_3 = 31;
    static final short BLUE_4 = 32;
    static final short BLUE_5 = 33;
    static final short BLUE_6 = 34;
    static final short BLUE_7 = 35;
    static final short BLUE_8 = 36;
    static final short BLUE_9 = 37;
    static final short BLUE_DRAWTWO = 38;
    static final short BLUE_LEFTRIGHT = 39;
    static final short BLUE_SKIP = 40;
    static final short BLUE_BLANK = 41;
    static final short GREEN_0 = 42;
    static final short GREEN_1 = 43;
    static final short GREEN_2 = 44;
    static final short GREEN_3 = 45;
    static final short GREEN_4 = 46;
    static final short GREEN_5 = 47;
    static final short GREEN_6 = 48;
    static final short GREEN_7 = 49;
    static final short GREEN_8 = 50;
    static final short GREEN_9 = 51;
    static final short GREEN_DRAWTWO = 52;
    static final short GREEN_LEFTRIGHT = 53;
    static final short GREEN_SKIP = 54;
    static final short GREEN_BLANK = 55;
    static final short CHOOSECOLOR = 56;
    static final short DRAWFOUR = 57;
    static final short SELECT = 58;
    static final short BACK = 59;
    private final short PLAYER_CARDS = (short)7;
    private String lastStartPlayer = "Unknown";
    private String playerNowPlaying = "Unknown";
    private int cardsToDraw = 0;
    private int lastPlayedCard = -1;
    private boolean playerDirectionRight = true;
    private boolean isPlaying = false;
    private Vector cardsPlayed = new Vector();
    private Vector cardsUnused = new Vector();
    private int[] cardPoints = new int[60];
    private boolean lastMoveAllowed = true;
    private long gameRules = 0L;
    private JOneServer mainClass = null;
    private SecureRandom sr = new SecureRandom();

    GameRulesOne(JOneServer mainClass) {
        this.mainClass = mainClass;
        this.fillCardPoints();
    }

    void handleLeavingPlayer(Connection you) {
        if (you.isPlaying()) {
            this.addUnusedCards(you.getCards());
            if (this.playerNowPlaying.equals(you.getNickName())) {
                this.playerNowPlaying = this.getNextPlayer(false);
                you.stopPlaying();
                this.sendGameStatus(this.cardsToDraw);
                if (JOneServer.DEBUG) {
                    this.mainClass.addLogEntry("HandleLeavingPlayer: " + you.getNickName() + " - Playing (was on turn) connection");
                }
            } else if (JOneServer.DEBUG) {
                this.mainClass.addLogEntry("HandleLeavingPlayer: " + you.getNickName() + " (Current: " + this.playerNowPlaying + ") - Playing connection");
            }
        } else {
            this.mainClass.refreshLists();
            if (JOneServer.DEBUG) {
                this.mainClass.addLogEntry("HandleLeavingPlayer: " + you.getNickName() + " (Current: " + this.playerNowPlaying + ") - Non playing connection");
            }
        }
    }

    private void addUnusedCards(Vector cardList) {
        if (this.isPlaying) {
            this.cardsUnused.addAll(cardList);
            if (JOneServer.DEBUG) {
                this.mainClass.addLogEntry(String.valueOf(Integer.toString(cardList.size())) + " cards added to cardsUnused list!");
            }
            this.checkRunningGame();
        }
    }

    void startNewGame() {
        this.isPlaying = true;
        this.gameRules = this.mainClass.getGameRules();
        this.cardsUnused = this.getFullCardSet();
        int firstCard = Integer.parseInt(this.cardsUnused.elementAt(0).toString());
        this.cardsUnused.removeElementAt(0);
        this.lastPlayedCard = firstCard;
        this.cardsPlayed.addElement(Integer.toString(firstCard));
        this.setPlayerCards(firstCard);
        Vector playerNames = this.mainClass.getNickNames(1);
        int tmp = -1;
        while (playerNames.elementAt(tmp = this.randomInt(0, playerNames.size())).toString().equals(this.lastStartPlayer)) {
        }
        this.lastStartPlayer = playerNames.elementAt(tmp).toString();
        this.setActivePlayer(this.lastStartPlayer, 0);
    }

    private void setPlayerCards(int firstCard) {
        Vector players = this.mainClass.getConnections();
        int p = 0;
        while (p < players.size()) {
            Connection you = (Connection)players.elementAt(p);
            you.doLastRoundReset();
            int i = 0;
            while (i < 7) {
                int card = Integer.parseInt(this.cardsUnused.elementAt(0).toString());
                you.addCard(card);
                this.cardsUnused.removeElementAt(0);
                ++i;
            }
            you.sendGameStart(firstCard);
            ++p;
        }
    }

    void checkReady() {
        if (!this.isPlaying) {
            boolean startGame = true;
            Vector players = this.mainClass.getConnections();
            int p = 0;
            while (p < players.size()) {
                Connection you = (Connection)players.elementAt(p);
                if (!you.isReady()) {
                    startGame = false;
                    break;
                }
                ++p;
            }
            if (players.size() <= 1) {
                startGame = false;
            }
            if (startGame) {
                this.startNewGame();
            } else {
                this.mainClass.refreshLists();
            }
        }
    }

    void checkRunningGame() {
        if (this.isPlaying) {
            Vector players = this.mainClass.getNickNames(1);
            if (players.size() == 1) {
                Connection you = this.mainClass.getConnectionFromNick(players.firstElement().toString());
                String tmpnick = you.getNickName();
                if (tmpnick != null) {
                    this.sendGameWon(tmpnick, false);
                } else {
                    this.gameEnd();
                }
            } else if (players.size() == 0) {
                this.gameEnd();
            }
            this.mainClass.refreshLists();
        }
    }

    private void gameEnd() {
        this.lastStartPlayer = "Unknown";
        this.playerNowPlaying = "Unknown";
        this.cardsToDraw = 0;
        this.lastPlayedCard = -1;
        this.playerDirectionRight = true;
        this.isPlaying = false;
        this.mainClass.setGameStatus(null);
        this.cardsPlayed.clear();
        this.cardsUnused.clear();
    }

    void checkAction(Connection player, int card) {
        if (JOneServer.DEBUG) {
            this.mainClass.addLogEntry("Checking player action from player " + player.getNickName() + "!");
            this.mainClass.addLogEntry("Player now playing: " + this.playerNowPlaying);
            this.mainClass.addLogEntry("Card action: " + Integer.toString(card));
        }
        if (player.getNickName().equals(this.playerNowPlaying)) {
            this.handlePlayerAction(player.getNickName(), card);
        }
    }

    void sendGameStatus(int drawCardCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("206 ");
        sb.append(this.playerNowPlaying);
        sb.append("?");
        sb.append(drawCardCount);
        sb.append("?");
        sb.append(this.playerDirectionRight);
        sb.append("?");
        sb.append(this.cardsUnused.size());
        Vector players = this.mainClass.getConnections();
        int p = 0;
        while (p < players.size()) {
            Connection you = (Connection)players.elementAt(p);
            if (you.isPlaying()) {
                sb.append("?");
                sb.append(you.getNickName());
                sb.append("?");
                sb.append(you.getCardCount());
            }
            ++p;
        }
        this.mainClass.broadcast(sb.toString());
        this.mainClass.setGameStatus(sb.toString());
    }

    private void sendGameWon(String playerwon, boolean countPoints) {
        StringBuffer sb = new StringBuffer();
        int pointstmp = 0;
        Vector players = this.mainClass.getConnections();
        int p = 0;
        while (p < players.size()) {
            Connection you = (Connection)players.elementAt(p);
            if (you.isPlaying()) {
                if (p > 0) {
                    sb.append("?");
                }
                if (playerwon.equals(you.getNickName()) && countPoints) {
                    you.incrementPlayerWon();
                }
                pointstmp = 0;
                if (countPoints) {
                    pointstmp = this.getPlayerPoints(you.getCards());
                    if (JOneServer.DEBUG) {
                        this.mainClass.addLogEntry(String.valueOf(you.getNickName()) + " Round Card Points: " + Integer.toString(pointstmp));
                    }
                }
                you.setCardPointsLastRound(pointstmp);
                you.incrementCardPointsTotal(pointstmp);
                sb.append(you.getNickName());
                sb.append("+");
                sb.append(you.getCardCount());
                sb.append("+");
                sb.append(you.getCardPointsLastRound());
                sb.append("+");
                sb.append(you.getCardPointsTotal());
                sb.append("+");
                sb.append(you.getRounds());
                sb.append("+");
                sb.append(you.getPlayerWon());
            }
            ++p;
        }
        if (countPoints) {
            this.mainClass.setScoreboard(sb.toString());
        }
        this.mainClass.broadcast("205 " + playerwon + "?" + sb.toString());
        this.gameEnd();
    }

    private void sendPlayedCard(String playername, int card, int realcard) {
        Connection you = this.mainClass.getConnectionFromNick(playername);
        if (you != null) {
            if (you.removeCard(realcard)) {
                this.lastPlayedCard = card;
                this.cardsPlayed.addElement(Integer.toString(realcard));
                this.mainClass.broadcast("201 " + playername + "?" + "2000" + "?" + Integer.toString(card));
            } else if (JOneServer.DEBUG) {
                this.mainClass.addLogEntry("Can not remove card from player " + playername + "!");
            }
        } else if (JOneServer.DEBUG) {
            this.mainClass.addLogEntry("Unable to get Connection!");
        }
    }

    private boolean sendTakeUpCard(String playername) {
        if (this.cardsUnused.size() == 0) {
            this.swapCards();
        }
        Connection you = this.mainClass.getConnectionFromNick(playername);
        if (this.cardsUnused.size() == 0) {
            you.send("202 ");
            return false;
        }
        int tmpcard = Integer.parseInt(this.cardsUnused.firstElement().toString());
        you.addCard(tmpcard);
        this.cardsUnused.removeElementAt(0);
        you.send("201 " + playername + "?" + "2001" + "?" + Integer.toString(tmpcard));
        this.mainClass.broadcast("104 " + playername + "?" + "2001");
        if (this.cardsUnused.size() <= 1) {
            this.swapCards();
        }
        return true;
    }

    private void swapCards() {
        if (this.cardsPlayed.size() > 1) {
            while (this.cardsPlayed.size() > 1) {
                this.cardsUnused.addElement(this.cardsPlayed.elementAt(0));
                this.cardsPlayed.removeElementAt(0);
            }
            if (JOneServer.DEBUG) {
                System.out.println("Last card of cardsPlayed Vector: " + this.cardsPlayed.elementAt(0).toString());
                System.out.println("Last card of lastPlayedCard Integer: " + Integer.toString(this.lastPlayedCard));
            }
            Collections.shuffle(this.cardsUnused);
            this.mainClass.broadcast("201 Server?2002?" + Integer.toString(this.lastPlayedCard));
        }
    }

    private void handlePlayerAction(String playername, int card) {
        try {
            int addition = 0;
            int drawValue = 0;
            boolean nextMove = false;
            if (card == 59) {
                nextMove = this.sendTakeUpCard(playername);
            } else if (card > 59) {
                if (card - 13 == 56) {
                    addition = 13;
                } else if (card - 41 == 56) {
                    addition = 41;
                } else if (card - 27 == 56) {
                    addition = 27;
                } else if (card - 55 == 56) {
                    addition = 55;
                } else if (card - 13 == 57) {
                    addition = 13;
                } else if (card - 41 == 57) {
                    addition = 41;
                } else if (card - 27 == 57) {
                    addition = 27;
                } else if (card - 55 == 57) {
                    addition = 55;
                }
                int realcard = card - addition;
                drawValue = this.getDrawValue(realcard);
                if (this.cardsToDraw > 0) {
                    if (this.isCumulatedAllowed(realcard)) {
                        nextMove = true;
                        this.lastMoveAllowed = true;
                        this.sendPlayedCard(playername, card, realcard);
                    }
                } else if (!this.hasCard(playername, realcard)) {
                    this.mainClass.addLogEntry("Player " + playername + " played a not owned card!");
                } else if (this.isCardAllowed(realcard)) {
                    nextMove = true;
                    this.lastMoveAllowed = true;
                    this.sendPlayedCard(playername, card, realcard);
                } else if ((this.gameRules & 1L) == 1L) {
                    nextMove = true;
                    this.lastMoveAllowed = false;
                    this.sendPlayedCard(playername, card, realcard);
                } else if (JOneServer.DEBUG) {
                    this.mainClass.addLogEntry("Player " + playername + " played not allowed card " + Integer.toString(card));
                }
            } else {
                if (this.isGameDirection(card)) {
                    this.playerDirectionRight = !this.playerDirectionRight;
                } else {
                    drawValue = this.getDrawValue(card);
                }
                if (this.cardsToDraw > 0) {
                    if (this.isCumulatedAllowed(card)) {
                        nextMove = true;
                        this.lastMoveAllowed = true;
                        this.sendPlayedCard(playername, card, card);
                    }
                } else if (!this.hasCard(playername, card)) {
                    this.mainClass.addLogEntry("Player " + playername + " played a not owned card!");
                } else if (this.isCardAllowed(card)) {
                    nextMove = true;
                    this.lastMoveAllowed = true;
                    this.sendPlayedCard(playername, card, card);
                } else if ((this.gameRules & 1L) == 1L) {
                    nextMove = true;
                    this.lastMoveAllowed = false;
                    this.sendPlayedCard(playername, card, card);
                } else if (JOneServer.DEBUG) {
                    this.mainClass.addLogEntry("Player " + playername + " played not allowed card " + Integer.toString(card));
                }
            }
            if (nextMove) {
                String playerWon = this.getPlayerWon();
                if (JOneServer.DEBUG) {
                    this.mainClass.addLogEntry("PlayerWon: " + playerWon + " - drawValue: " + drawValue + " - cardsToDraw: " + this.cardsToDraw);
                }
                if (playerWon != null && drawValue == 0 && this.cardsToDraw == 0) {
                    this.sendGameWon(playerWon, true);
                } else if (card == 59) {
                    if (this.cardsToDraw > 0) {
                        if (JOneServer.DEBUG) {
                            this.mainClass.addLogEntry("Same player has to draw " + Integer.toString(this.cardsToDraw - 1) + " more!");
                        }
                        this.sendGameStatus(--this.cardsToDraw);
                    }
                    if (playerWon == null && this.cardsToDraw == 0) {
                        this.setActivePlayer(this.getNextPlayer(card), drawValue);
                    } else if (playerWon != null && this.cardsToDraw == 0) {
                        this.sendGameWon(playerWon, true);
                    }
                } else {
                    this.setActivePlayer(this.getNextPlayer(card), drawValue);
                }
            }
        }
        catch (Exception e) {
            this.mainClass.printDebugLog(e);
        }
    }

    private boolean hasCard(String playername, int card) {
        Connection you = this.mainClass.getConnectionFromNick(playername);
        Vector cards = you.getCards();
        return cards.indexOf(Integer.toString(card)) != -1;
    }

    private String getPlayerWon() {
        String retValue = null;
        Vector players = this.mainClass.getConnections();
        int p = 0;
        while (p < players.size()) {
            Connection you = (Connection)players.elementAt(p);
            if (you.isPlaying() && you.getCardCount() == 0) {
                retValue = you.getNickName();
            }
            ++p;
        }
        return retValue;
    }

    private void setActivePlayer(String playerName, int drawcount) {
        this.playerNowPlaying = playerName;
        this.cardsToDraw += drawcount;
        if (JOneServer.DEBUG) {
            this.mainClass.addLogEntry(String.valueOf(playerName) + " is next player with drawcount " + Integer.toString(this.cardsToDraw) + "!");
        }
        this.sendGameStatus(this.cardsToDraw);
    }

    private boolean isCumulatedAllowed(int card) {
        if ((this.gameRules & 2L) == 2L) {
            int lastDrawValue;
            int newDrawValue = this.getDrawValue(card);
            return newDrawValue == (lastDrawValue = this.getDrawValue(this.lastPlayedCard - this.getColorWish(this.lastPlayedCard)));
        }
        return false;
    }

    private boolean isCardAllowed(int card) {
        int tmp2;
        int tmp1;
        boolean retValue = false;
        int cardTarget = this.lastPlayedCard;
        if (JOneServer.DEBUG) {
            this.mainClass.addLogEntry("Last card: " + Integer.toString(cardTarget));
            this.mainClass.addLogEntry("New card: " + Integer.toString(card));
        }
        if (cardTarget > 59 && card == 56) {
            retValue = false;
        } else if (card == 56) {
            retValue = true;
        } else if (this.isColorSelectionCard(cardTarget)) {
            retValue = true;
        } else if (cardTarget > 59) {
            if (cardTarget - 13 == 56) {
                if (card >= 0 && card <= 12) {
                    retValue = true;
                }
            } else if (cardTarget - 41 == 56) {
                if (card >= 28 && card <= 40) {
                    retValue = true;
                }
            } else if (cardTarget - 27 == 56) {
                if (card >= 14 && card <= 26) {
                    retValue = true;
                }
            } else if (cardTarget - 55 == 56) {
                if (card >= 42 && card <= 54) {
                    retValue = true;
                }
            } else if (cardTarget - 13 == 57) {
                if (card >= 0 && card <= 12) {
                    retValue = true;
                }
            } else if (cardTarget - 41 == 57) {
                if (card >= 28 && card <= 40) {
                    retValue = true;
                }
            } else if (cardTarget - 27 == 57) {
                if (card >= 14 && card <= 26) {
                    retValue = true;
                }
            } else if (cardTarget - 55 == 57 && card >= 42 && card <= 54) {
                retValue = true;
            }
        }
        if (card == 57) {
            retValue = true;
        }
        if (cardTarget >= 0 && cardTarget <= 12 && card >= 0 && card <= 12) {
            retValue = true;
        }
        if (cardTarget >= 28 && cardTarget <= 40 && card >= 28 && card <= 40) {
            retValue = true;
        }
        if (cardTarget >= 14 && cardTarget <= 26 && card >= 14 && card <= 26) {
            retValue = true;
        }
        if (cardTarget >= 42 && cardTarget <= 54 && card >= 42 && card <= 54) {
            retValue = true;
        }
        if (!retValue && cardTarget < 56 && (tmp1 = card % 14) == (tmp2 = cardTarget % 14)) {
            retValue = true;
        }
        return retValue;
    }

    private boolean isColorSelectionCard(int card) {
        if (card == 56) {
            return true;
        }
        return card == 57;
    }

    private int getDrawValue(int card) {
        int retValue = 0;
        switch (card) {
            case 10: 
            case 24: 
            case 38: 
            case 52: {
                retValue = 2;
                break;
            }
            case 57: {
                retValue = 4;
                break;
            }
            default: {
                retValue = 0;
            }
        }
        return retValue;
    }

    private boolean isGameDirection(int card) {
        boolean retValue = false;
        switch (card) {
            case 11: 
            case 25: 
            case 39: 
            case 53: {
                retValue = true;
                break;
            }
            default: {
                retValue = false;
            }
        }
        return retValue;
    }

    private int getColorWish(int card) {
        int addition = 0;
        if (card > 59) {
            if (card - 13 == 56) {
                addition = 13;
            } else if (card - 41 == 56) {
                addition = 41;
            } else if (card - 27 == 56) {
                addition = 27;
            } else if (card - 55 == 56) {
                addition = 55;
            } else if (card - 13 == 57) {
                addition = 13;
            } else if (card - 41 == 57) {
                addition = 41;
            } else if (card - 27 == 57) {
                addition = 27;
            } else if (card - 55 == 57) {
                addition = 55;
            }
            return addition;
        }
        return addition;
    }

    int getPlayerPoints(Vector cardsGambler) {
        int result = 0;
        if (cardsGambler != null) {
            int i = 0;
            while (i < cardsGambler.size()) {
                result += this.cardPoints[Integer.parseInt(cardsGambler.elementAt(i).toString())];
                ++i;
            }
        }
        return result;
    }

    private String getNextPlayer(boolean skip) {
        Vector playerNames = this.mainClass.getNickNames(1);
        int pos = playerNames.indexOf(this.playerNowPlaying);
        if (this.playerDirectionRight) {
            pos = skip ? (pos + 2) % playerNames.size() : (pos + 1) % playerNames.size();
            return playerNames.elementAt(pos).toString();
        }
        pos = skip ? (pos -= 2) : --pos;
        if (pos == -1) {
            return playerNames.lastElement().toString();
        }
        if (pos == -2) {
            return playerNames.elementAt(playerNames.size() - 2).toString();
        }
        return playerNames.elementAt(pos).toString();
    }

    private String getNextPlayer(int card) {
        boolean skip = false;
        switch (card) {
            case 12: 
            case 26: 
            case 40: 
            case 54: {
                skip = true;
                break;
            }
            default: {
                skip = false;
            }
        }
        if (this.mainClass.getPlayerCount() == 2) {
            switch (card) {
                case 11: 
                case 25: 
                case 39: 
                case 53: {
                    skip = true;
                    break;
                }
            }
        }
        return this.getNextPlayer(skip);
    }

    private int randomInt(int minInt, int maxInt) {
        return minInt + Math.abs(this.sr.nextInt()) % maxInt;
    }

    private Vector getFullCardSet() {
        Vector<String> tmp = new Vector<String>();
        tmp.addElement(Integer.toString(0));
        tmp.addElement(Integer.toString(1));
        tmp.addElement(Integer.toString(2));
        tmp.addElement(Integer.toString(3));
        tmp.addElement(Integer.toString(4));
        tmp.addElement(Integer.toString(5));
        tmp.addElement(Integer.toString(6));
        tmp.addElement(Integer.toString(7));
        tmp.addElement(Integer.toString(8));
        tmp.addElement(Integer.toString(9));
        tmp.addElement(Integer.toString(10));
        tmp.addElement(Integer.toString(11));
        tmp.addElement(Integer.toString(12));
        tmp.addElement(Integer.toString(1));
        tmp.addElement(Integer.toString(2));
        tmp.addElement(Integer.toString(3));
        tmp.addElement(Integer.toString(4));
        tmp.addElement(Integer.toString(5));
        tmp.addElement(Integer.toString(6));
        tmp.addElement(Integer.toString(7));
        tmp.addElement(Integer.toString(8));
        tmp.addElement(Integer.toString(9));
        tmp.addElement(Integer.toString(10));
        tmp.addElement(Integer.toString(11));
        tmp.addElement(Integer.toString(12));
        tmp.addElement(Integer.toString(14));
        tmp.addElement(Integer.toString(15));
        tmp.addElement(Integer.toString(16));
        tmp.addElement(Integer.toString(17));
        tmp.addElement(Integer.toString(18));
        tmp.addElement(Integer.toString(19));
        tmp.addElement(Integer.toString(20));
        tmp.addElement(Integer.toString(21));
        tmp.addElement(Integer.toString(22));
        tmp.addElement(Integer.toString(23));
        tmp.addElement(Integer.toString(24));
        tmp.addElement(Integer.toString(25));
        tmp.addElement(Integer.toString(26));
        tmp.addElement(Integer.toString(15));
        tmp.addElement(Integer.toString(16));
        tmp.addElement(Integer.toString(17));
        tmp.addElement(Integer.toString(18));
        tmp.addElement(Integer.toString(19));
        tmp.addElement(Integer.toString(20));
        tmp.addElement(Integer.toString(21));
        tmp.addElement(Integer.toString(22));
        tmp.addElement(Integer.toString(23));
        tmp.addElement(Integer.toString(24));
        tmp.addElement(Integer.toString(25));
        tmp.addElement(Integer.toString(26));
        tmp.addElement(Integer.toString(28));
        tmp.addElement(Integer.toString(29));
        tmp.addElement(Integer.toString(30));
        tmp.addElement(Integer.toString(31));
        tmp.addElement(Integer.toString(32));
        tmp.addElement(Integer.toString(33));
        tmp.addElement(Integer.toString(34));
        tmp.addElement(Integer.toString(35));
        tmp.addElement(Integer.toString(36));
        tmp.addElement(Integer.toString(37));
        tmp.addElement(Integer.toString(38));
        tmp.addElement(Integer.toString(39));
        tmp.addElement(Integer.toString(40));
        tmp.addElement(Integer.toString(29));
        tmp.addElement(Integer.toString(30));
        tmp.addElement(Integer.toString(31));
        tmp.addElement(Integer.toString(32));
        tmp.addElement(Integer.toString(33));
        tmp.addElement(Integer.toString(34));
        tmp.addElement(Integer.toString(35));
        tmp.addElement(Integer.toString(36));
        tmp.addElement(Integer.toString(37));
        tmp.addElement(Integer.toString(38));
        tmp.addElement(Integer.toString(39));
        tmp.addElement(Integer.toString(40));
        tmp.addElement(Integer.toString(42));
        tmp.addElement(Integer.toString(43));
        tmp.addElement(Integer.toString(44));
        tmp.addElement(Integer.toString(45));
        tmp.addElement(Integer.toString(46));
        tmp.addElement(Integer.toString(47));
        tmp.addElement(Integer.toString(48));
        tmp.addElement(Integer.toString(49));
        tmp.addElement(Integer.toString(50));
        tmp.addElement(Integer.toString(51));
        tmp.addElement(Integer.toString(52));
        tmp.addElement(Integer.toString(53));
        tmp.addElement(Integer.toString(54));
        tmp.addElement(Integer.toString(43));
        tmp.addElement(Integer.toString(44));
        tmp.addElement(Integer.toString(45));
        tmp.addElement(Integer.toString(46));
        tmp.addElement(Integer.toString(47));
        tmp.addElement(Integer.toString(48));
        tmp.addElement(Integer.toString(49));
        tmp.addElement(Integer.toString(50));
        tmp.addElement(Integer.toString(51));
        tmp.addElement(Integer.toString(52));
        tmp.addElement(Integer.toString(53));
        tmp.addElement(Integer.toString(54));
        tmp.addElement(Integer.toString(56));
        tmp.addElement(Integer.toString(57));
        tmp.addElement(Integer.toString(56));
        tmp.addElement(Integer.toString(57));
        tmp.addElement(Integer.toString(56));
        tmp.addElement(Integer.toString(57));
        tmp.addElement(Integer.toString(56));
        tmp.addElement(Integer.toString(57));
        Collections.shuffle(tmp);
        return tmp;
    }

    private void fillCardPoints() {
        this.cardPoints[0] = 0;
        this.cardPoints[1] = 1;
        this.cardPoints[2] = 2;
        this.cardPoints[3] = 3;
        this.cardPoints[4] = 4;
        this.cardPoints[5] = 5;
        this.cardPoints[6] = 6;
        this.cardPoints[7] = 7;
        this.cardPoints[8] = 8;
        this.cardPoints[9] = 9;
        this.cardPoints[10] = 20;
        this.cardPoints[11] = 20;
        this.cardPoints[12] = 20;
        this.cardPoints[13] = 0;
        this.cardPoints[14] = 0;
        this.cardPoints[15] = 1;
        this.cardPoints[16] = 2;
        this.cardPoints[17] = 3;
        this.cardPoints[18] = 4;
        this.cardPoints[19] = 5;
        this.cardPoints[20] = 6;
        this.cardPoints[21] = 7;
        this.cardPoints[22] = 8;
        this.cardPoints[23] = 9;
        this.cardPoints[24] = 20;
        this.cardPoints[25] = 20;
        this.cardPoints[26] = 20;
        this.cardPoints[27] = 0;
        this.cardPoints[28] = 0;
        this.cardPoints[29] = 1;
        this.cardPoints[30] = 2;
        this.cardPoints[31] = 3;
        this.cardPoints[32] = 4;
        this.cardPoints[33] = 5;
        this.cardPoints[34] = 6;
        this.cardPoints[35] = 7;
        this.cardPoints[36] = 8;
        this.cardPoints[37] = 9;
        this.cardPoints[38] = 20;
        this.cardPoints[39] = 20;
        this.cardPoints[40] = 20;
        this.cardPoints[41] = 0;
        this.cardPoints[42] = 0;
        this.cardPoints[43] = 1;
        this.cardPoints[44] = 2;
        this.cardPoints[45] = 3;
        this.cardPoints[46] = 4;
        this.cardPoints[47] = 5;
        this.cardPoints[48] = 6;
        this.cardPoints[49] = 7;
        this.cardPoints[50] = 8;
        this.cardPoints[51] = 9;
        this.cardPoints[52] = 20;
        this.cardPoints[53] = 20;
        this.cardPoints[54] = 20;
        this.cardPoints[55] = 0;
        this.cardPoints[56] = 50;
        this.cardPoints[57] = 70;
        this.cardPoints[58] = 0;
        this.cardPoints[59] = 0;
    }
}

