/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Timer;

class Connection
extends Thread
implements ActionListener {
    static final String SERVER_MSG = "100 ";
    static final String CHAT_MSG = "101 ";
    static final String CLIENT_NICK = "102 ";
    static final String NICK_LIST = "103 ";
    static final String CHAT_MOVE = "104 ";
    static final String PING = "105 ";
    static final String CLIENT_VERSION = "106 ";
    static final String PONG = "107 ";
    static final String CHAT_ME = "108 ";
    static final String JOIN = "109 ";
    static final String SERVER_VERSION = "110 ";
    static final String SERVER_OLD_MSG = "111 ";
    static final String SERVER_CLIENT_OLD = "112 ";
    static final String SERVER_ILLEGALNICK = "113 ";
    static final String SERVER_FULL = "114 ";
    static final String SERVER_WELCOMEMSG = "115 ";
    static final String SPECTATOR_MODE = "120 ";
    static final String AUTOPING = "121 ";
    static final String GAME_START = "200 ";
    static final String GAME_MOVE = "201 ";
    static final String GAME_NOCARDS = "202 ";
    static final String GAME_POINTS_RESET = "203 ";
    static final String GAME_POINTS = "204 ";
    static final String GAME_WON = "205 ";
    static final String GAME_STATUS = "206 ";
    static final String GAME_READY = "207 ";
    static final String GAME_CARD_BACK = "208 ";
    static final String EXIT_GAME = "600";
    static final String CLOSED_CONNECTION = "601 ";
    static final String DELIM = "?";
    protected Socket client;
    protected BufferedReader in;
    protected PrintStream out;
    protected JOneServer server;
    private String nick = "Unknown";
    private String versionInfo = "Unknown";
    private boolean isLoggedIn = false;
    private boolean nowPlaying = false;
    private boolean isReady = false;
    private boolean auth = false;
    private boolean dropConnection = false;
    private Vector currentCards = new Vector();
    private int playedRounds = 0;
    private int cardPointsTotal = 0;
    private int cardPointsLastRound = 0;
    private int playerWon = 0;
    private long lastAutoPing = 0L;
    private Timer disTimer = new Timer(10000, this);
    private long timeTmp;
    private AppTranslation lang;

    public Connection(JOneServer server, Socket client, AppTranslation prop, boolean dropConnection) {
        this.lastAutoPing = System.currentTimeMillis();
        this.server = server;
        this.client = client;
        this.lang = prop;
        this.dropConnection = dropConnection;
        this.disTimer.setRepeats(false);
        try {
            this.in = new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8"));
            this.out = new PrintStream(client.getOutputStream(), true, "UTF-8");
        }
        catch (IOException e) {
            try {
                client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.err.println("Fehler beim Erzeugen der Streams: " + e);
            server.printDebugLog(e);
            return;
        }
        this.start();
    }

    Vector getCards() {
        return this.currentCards;
    }

    int getCardCount() {
        return this.currentCards.size();
    }

    boolean isPlaying() {
        return this.nowPlaying;
    }

    void stopPlaying() {
        this.nowPlaying = false;
    }

    boolean isReady() {
        return this.isReady;
    }

    int getCardPointsTotal() {
        return this.cardPointsTotal;
    }

    void incrementCardPointsTotal(int addpoints) {
        this.cardPointsTotal += addpoints;
    }

    int getCardPointsLastRound() {
        return this.cardPointsLastRound;
    }

    void setCardPointsLastRound(int points) {
        this.cardPointsLastRound = points;
    }

    int getPlayerWon() {
        return this.playerWon;
    }

    void incrementPlayerWon() {
        ++this.playerWon;
    }

    String getIPAddress() {
        String tmp = this.client.getRemoteSocketAddress().toString();
        if (tmp.startsWith("/")) {
            return tmp.substring(1);
        }
        return tmp;
    }

    String getNickName() {
        return this.nick;
    }

    String getVersionInfo() {
        return this.versionInfo;
    }

    String getRounds() {
        return Integer.toString(this.playedRounds);
    }

    void doGamePointsReset() {
        this.playedRounds = this.isPlaying() ? 1 : 0;
        this.cardPointsTotal = 0;
        this.playerWon = 0;
    }

    void doLastRoundReset() {
        this.currentCards.clear();
    }

    boolean removeCard(int card) {
        boolean retValue = false;
        int i = 0;
        while (i < this.currentCards.size()) {
            int tmp = Integer.parseInt(this.currentCards.elementAt(i).toString());
            if (tmp == card) {
                this.currentCards.removeElementAt(i);
                retValue = true;
                break;
            }
            ++i;
        }
        return retValue;
    }

    void addCard(int card) {
        this.currentCards.addElement(Integer.toString(card));
    }

    void sendGameStart(int firstCard) {
        StringBuffer sb = new StringBuffer();
        this.isReady = false;
        sb.append(this.nick);
        sb.append(DELIM);
        sb.append(firstCard);
        sb.append(DELIM);
        sb.append(this.server.getGameRules());
        int i = 0;
        while (i < this.currentCards.size()) {
            sb.append(DELIM);
            sb.append(this.currentCards.elementAt(i).toString());
            ++i;
        }
        this.send(GAME_START + sb.toString());
    }

    void send(String msg) {
        if (this.canISend(msg)) {
            if (msg.startsWith(PONG)) {
                this.timeTmp = System.currentTimeMillis();
            } else if (msg.startsWith(GAME_START)) {
                this.nowPlaying = true;
                ++this.playedRounds;
            } else if (msg.startsWith(GAME_POINTS_RESET)) {
                this.doGamePointsReset();
            } else if (msg.startsWith(GAME_WON)) {
                this.nowPlaying = false;
                this.isReady = false;
            }
            this.out.println(msg);
        }
    }

    private boolean canISend(String msg) {
        if (!this.isLoggedIn) {
            if (msg.startsWith(GAME_START)) {
                return false;
            }
            if (msg.startsWith(GAME_STATUS)) {
                return false;
            }
            if (msg.startsWith(GAME_WON)) {
                return false;
            }
            if (msg.startsWith(NICK_LIST)) {
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        this.closeConnection();
    }

    void closeConnection() {
        block5: {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                this.interrupt();
            }
            catch (Exception e) {
                this.server.printDebugLog(e);
                if (!JOneServer.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private String[] getHelp() {
        String[] help = new String[]{"/auth <password>\tIdentifies you as the server admin!", "/help\tShow this help.", "/listrules\tShows possible game rules.", "/kick <nickname>\tKick the user from the server.", "/me <message>\tLike IRC.", "/ping\tSee how much ms it takes that the server answers.", "/reloadcfg\tReload the config file.", "/removerule <rulename>\tRemoves a game rule, see /listrules", "/serverinfo\tServer version.", "/servername <servername>\tSets a new servername! Returns current without argument!", "/setrule <rulename>\tSets a new game rule, see /listrules", "/showcurrentrules\tShows activated game rules for current game round.", "/showrules\tShows activated game rules on server.", "/showusers\tShow all users with ip addresses on this server.", "/shutdown\tServer go offline.", "/welcomemsg <welcomemsg>\tSets a new welcome message! Returns current without argument!"};
        return help;
    }

    public void run() {
        block81: {
            this.server.addLogEntry(String.valueOf(this.lang.getTranslationString("ConnectionFrom", "Connection from")) + " " + this.getIPAddress());
            try {
                String line;
                while ((line = this.in.readLine()) != null && !this.isInterrupted()) {
                    StringTokenizer st;
                    String msg;
                    String[] help;
                    String tmp;
                    if (line == null) continue;
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/serverinfo")) {
                        tmp = "100 Servername: " + this.server.getServerName() + DELIM + "JOneServer Version " + "2.1.2 (19.06.2014)" + DELIM + "(c) 2004-2008 by Smart Software Development / Stefan1200";
                        if (JOneServer.DEBUG) {
                            tmp = String.valueOf(tmp) + "?Notice: Debug Mode activated!";
                        }
                        this.send(tmp);
                        this.server.addLogEntry("Server Version requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/auth ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/auth ".length());
                        if (this.server.getAdminPassword() == null) {
                            this.send("100 Client Admin Mode disabled, auth not possible!");
                            this.server.addLogEntry("Auth requested by " + this.nick + ", but Client Admin Mode is disabled.");
                            this.auth = false;
                            continue;
                        }
                        if (this.server.getAdminPassword().equals(tmp)) {
                            this.auth = true;
                            this.send("100 Auth successfully!");
                            this.server.addLogEntry("Successful auth request by " + this.nick);
                            continue;
                        }
                        this.auth = false;
                        this.send("100 Password wrong!");
                        this.server.addLogEntry("Wrong password for auth request by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/kick ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/kick ".length());
                        if (this.auth) {
                            this.send(SERVER_MSG + this.server.kickUser(tmp));
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Kick of " + tmp + " requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/showrules")) {
                        this.send("100 Following rules are currently activated (maybe not for the current round):");
                        if ((this.server.getGameRules() & 1L) == 1L) {
                            this.send("100 Allow to cheat with wrong cards!");
                        }
                        if ((this.server.getGameRules() & 2L) == 2L) {
                            this.send("100 Allow to cumulate 2+ or 4+ cards!");
                        }
                        if (this.server.getGameRules() != 0L) continue;
                        this.send("100 No rules activated!");
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/listrules")) {
                        this.send("100 The following game rules are possible for /setrule and /removerule commands:");
                        this.send("100 cumulate - Allow to cumulate 2+ or 4+ cards!");
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/setrule ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/setrule ".length());
                        if (this.auth) {
                            if (this.server.setGameRule(tmp)) {
                                this.send("100 Game rules changed for next game round!");
                            } else {
                                this.send("100 Game rule not found!");
                            }
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Setting game rule " + tmp + " requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/removerule ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/removerule ".length());
                        if (this.auth) {
                            if (this.server.removeGameRule(tmp)) {
                                this.send("100 Game rules changed for next game round!");
                            } else {
                                this.send("100 Game rule not found!");
                            }
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Removing game rule " + tmp + " requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/reloadcfg")) {
                        if (this.auth) {
                            this.server.loadConfig();
                            this.send("100 Config file reloaded!");
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Config reload requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/showusers")) {
                        if (this.auth) {
                            StringBuffer sbUsers = new StringBuffer();
                            String[] users = this.server.showUsers().split("\n");
                            int i = 0;
                            while (i < users.length) {
                                if (i > 0) {
                                    sbUsers.append(DELIM);
                                }
                                sbUsers.append(users[i]);
                                ++i;
                            }
                            this.send(SERVER_MSG + sbUsers.toString());
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("ShowUsers requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/servername")) {
                        this.send("100 Current Servername: " + this.server.getServerName());
                        this.server.addLogEntry("Servername requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/servername ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/servername ".length());
                        if (this.auth) {
                            this.send(SERVER_MSG + this.server.setServerName(tmp));
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Servername change requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/welcomemsg")) {
                        if (this.server.getWelcomeMessage() != null) {
                            this.send("100 Current Welcome Message:");
                            this.send(SERVER_WELCOMEMSG + this.server.getWelcomeMessage());
                        } else {
                            this.send("100 Welcome Message disabled!");
                        }
                        this.server.addLogEntry("Welcome Message requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/welcomemsg ")) {
                        tmp = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/welcomemsg ".length());
                        if (this.auth) {
                            this.send(SERVER_MSG + this.server.setWelcomeMessage(tmp));
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Welcome Message change requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/shutdown")) {
                        if (this.auth) {
                            this.server.broadcast("100 Server now shutdown, requested by " + this.nick);
                            this.server.goOffline();
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Shutdown requested by " + this.nick);
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/help")) {
                        help = this.getHelp();
                        StringBuffer sbHelp = new StringBuffer();
                        int i = 0;
                        while (i < help.length) {
                            if (i > 0) {
                                sbHelp.append(DELIM);
                            }
                            sbHelp.append(help[i]);
                            ++i;
                        }
                        this.send(SERVER_MSG + sbHelp.toString());
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAT_MSG + this.nick + DELIM + "/?")) {
                        help = this.getHelp();
                        StringBuffer sbHelp = new StringBuffer();
                        int i = 0;
                        while (i < help.length) {
                            if (i > 0) {
                                sbHelp.append(DELIM);
                            }
                            sbHelp.append(help[i]);
                            ++i;
                        }
                        this.send(SERVER_MSG + sbHelp.toString());
                        continue;
                    }
                    if (line.toLowerCase().startsWith(String.valueOf(CHAT_MSG.toLowerCase()) + this.nick.toLowerCase() + DELIM.toLowerCase() + "/me ")) {
                        msg = line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length() + "/me ".length());
                        this.server.broadcast(CHAT_ME + this.nick + DELIM + msg);
                        this.server.addLogEntry(" * " + this.nick + " " + msg);
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG + this.nick + DELIM + "/")) {
                        this.send("100 Unknown command " + line.substring(CHAT_MSG.length() + this.nick.length() + DELIM.length()) + ". Try /help!");
                        continue;
                    }
                    if (line.equalsIgnoreCase(GAME_POINTS_RESET + this.nick)) {
                        if (this.auth) {
                            this.server.broadcast(line);
                        } else {
                            this.send("100 You must use the /auth command before!");
                        }
                        this.server.addLogEntry("Game points reset requested by " + this.nick);
                        continue;
                    }
                    if (line.startsWith(CLIENT_NICK)) {
                        if (this.versionInfo.equals("Unknown")) {
                            this.send("100 Your JOne client is older than " + Double.toString(2.1) + "!");
                            this.send(EXIT_GAME);
                            break;
                        }
                        if (this.server.isNickAllowed(line.substring(4))) {
                            this.nick = line.substring(4);
                            if (this.server.getWelcomeMessage() != null) {
                                this.send(SERVER_WELCOMEMSG + this.server.getWelcomeMessage());
                            }
                            this.server.broadcast(JOIN + this.nick);
                            this.lastAutoPing = System.currentTimeMillis();
                            this.isLoggedIn = true;
                            if (this.server.getGameStatus() != null) {
                                this.send(SPECTATOR_MODE);
                                this.send(this.server.getGameStatus());
                            }
                            this.server.refreshLists();
                            String scoreboard = this.server.getScoreboard();
                            if (scoreboard == null) continue;
                            this.send(GAME_POINTS + scoreboard);
                            continue;
                        }
                        this.send(SERVER_ILLEGALNICK);
                        this.send(EXIT_GAME);
                        break;
                    }
                    if (line.equals(SERVER_OLD_MSG)) {
                        this.server.showServerOldMessage();
                        continue;
                    }
                    if (line.equals(PONG)) {
                        this.server.addLogEntry("Ping from " + this.nick + " back after " + Long.toString(System.currentTimeMillis() - this.timeTmp) + "ms");
                        continue;
                    }
                    if (line.equals(PING)) {
                        this.send(PING);
                        this.server.addLogEntry("Ping request from " + this.nick);
                        continue;
                    }
                    if (line.equals(EXIT_GAME)) {
                        this.send(EXIT_GAME);
                        break;
                    }
                    if (line.equals(AUTOPING)) {
                        this.lastAutoPing = System.currentTimeMillis();
                        this.send(AUTOPING);
                        continue;
                    }
                    if (line.startsWith(CLIENT_VERSION)) {
                        if (this.dropConnection) {
                            this.send(SERVER_FULL);
                            this.send(EXIT_GAME);
                            break;
                        }
                        st = new StringTokenizer(line.substring(4), DELIM, false);
                        boolean isAllowed = false;
                        try {
                            double checkIt = Double.parseDouble(st.nextToken());
                            isAllowed = checkIt >= 2.1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (isAllowed) {
                            this.versionInfo = st.nextToken();
                            this.send(SERVER_VERSION + Double.toString(2.1));
                            continue;
                        }
                        this.send(SERVER_CLIENT_OLD + Double.toString(2.1));
                        this.send(EXIT_GAME);
                        break;
                    }
                    if (line.startsWith(GAME_MOVE)) {
                        st = new StringTokenizer(line.substring(4), DELIM, false);
                        st.nextToken();
                        this.server.handlePlayerAction(this, Integer.parseInt(st.nextToken()));
                        continue;
                    }
                    if (line.equals(GAME_READY)) {
                        boolean bl = this.isReady = !this.isReady;
                        if (this.isReady) {
                            this.server.checkReady();
                            continue;
                        }
                        this.server.refreshLists();
                        continue;
                    }
                    if (line.startsWith(CHAT_MSG)) {
                        this.server.broadcast(line);
                        msg = line.substring(4);
                        int pos = msg.indexOf(DELIM);
                        if (pos != -1) {
                            this.server.addLogEntry(msg.substring(0, pos), msg.substring(pos + 1));
                            continue;
                        }
                        this.server.addLogEntry("Unknown", msg);
                        continue;
                    }
                    if (!JOneServer.DEBUG) continue;
                    this.server.addLogEntry(line);
                }
                if (!this.nick.equals("Unknown")) {
                    this.server.addLogEntry(this.lang.getTranslationString("ClosedConnectionFrom", "Connection from %1 closed...", this.nick));
                    this.server.broadcast(CLOSED_CONNECTION + this.nick);
                }
                this.server.delConnection(this);
                this.startDisconnectTimer();
            }
            catch (SocketException se) {
                if (!this.nick.equals("Unknown")) {
                    this.server.addLogEntry(this.lang.getTranslationString("ClosedConnectionFrom", "Connection from %1 closed...", this.nick));
                    this.server.broadcast(CLOSED_CONNECTION + this.nick);
                }
                this.server.delConnection(this);
                this.startDisconnectTimer();
            }
            catch (Exception e) {
                this.server.printDebugLog(e);
                if (!this.nick.equals("Unknown")) {
                    this.server.addLogEntry(this.lang.getTranslationString("ClosedConnectionFrom", "Connection from %1 closed...", this.nick));
                    this.server.broadcast(CLOSED_CONNECTION + this.nick);
                }
                this.server.delConnection(this);
                this.startDisconnectTimer();
                if (!JOneServer.DEBUG) break block81;
                e.printStackTrace();
            }
        }
    }

    boolean isOnline() {
        if (this.client == null) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastAutoPing > 60000L) {
            return false;
        }
        return this.client.isConnected();
    }

    void startDisconnectTimer() {
        this.disTimer.start();
    }
}

