/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class Credits
extends JFrame {
    private String[] creditsNames = new String[]{"-=GF=-BioWolf", "-=GF=-Carsten", "-=GF=-Grakvaloth", "-=GF=-Mr.Mister", "-=GF=-Nehl", "EagleEye"};
    private Vector vecScrollText = new Vector();
    static final int x = 800;
    static final int y = 600;
    private BufferedImage bi = new BufferedImage(800, 600, 1);
    private Graphics2D g2D = (Graphics2D)this.bi.getGraphics();
    private Font font = new Font("serif", 0, 26);
    private Font fontCustom = null;
    private DrawPanel paintOn = new DrawPanel();
    private FontMetrics fm = this.paintOn.getFontMetrics(this.font);
    private FontMetrics fmCustom = null;
    private int fontHeight = this.fm.getAscent() + this.fm.getDescent();
    private int fontCustomHeight = 0;
    private ImageIcon iiSSD = new ImageIcon(this.getClass().getResource("ssd-logo-gr.gif"));
    private GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private GraphicsDevice gd = this.ge.getDefaultScreenDevice();
    private DisplayMode[] dm = this.gd.getDisplayModes();
    private Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(""), new Point(0, 0), "invisible");
    private Dimension dim = new Dimension(Toolkit.getDefaultToolkit().getScreenSize());
    private AppTranslation lang;
    private int counter = 0;
    private float alphaCounter = 0.0f;
    private boolean abort = false;

    public Credits(AppTranslation lang) {
        this.lang = lang;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Credits.this.abort = true;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    Credits.this.abort = true;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Credits.this.abort = true;
            }
        });
        this.setUndecorated(true);
        this.openFullScreen(null);
        this.setCursor(this.invisibleCursor);
        this.fillScrollText();
        this.paintOn.setSize((int)this.dim.getWidth(), (int)this.dim.getHeight());
        this.getContentPane().add(this.paintOn);
        this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void showBlendingLogo(Image logo) {
        long tmpResult;
        long tmp1;
        long sleepTime = 40L;
        int i22 = 0;
        while (i22 < 50) {
            tmp1 = System.currentTimeMillis();
            this.paintLogo(logo, true);
            this.paintOn.repaint();
            tmpResult = sleepTime - (System.currentTimeMillis() - tmp1);
            if (tmpResult < 2L) {
                tmpResult = 2L;
            }
            try {
                Thread.sleep(tmpResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.abort) {
                return;
            }
            ++i22;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception i22) {
            // empty catch block
        }
        if (this.abort) {
            return;
        }
        int i = 0;
        while (i < 50) {
            tmp1 = System.currentTimeMillis();
            this.paintLogo(logo, false);
            this.paintOn.repaint();
            tmpResult = sleepTime - (System.currentTimeMillis() - tmp1);
            if (tmpResult < 2L) {
                tmpResult = 2L;
            }
            try {
                Thread.sleep(tmpResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.abort) {
                return;
            }
            ++i;
        }
    }

    private void showBlendingText(String text, Color color) {
        this.showBlendingText(text, color, 90);
    }

    private void showBlendingText(String text, Color color, int fontSize) {
        long tmpResult;
        long tmp1;
        this.fontCustom = new Font("serif", 0, fontSize);
        this.fmCustom = this.paintOn.getFontMetrics(this.fontCustom);
        this.fontCustomHeight = this.fmCustom.getAscent() + this.fmCustom.getDescent();
        long sleepTime = 40L;
        int i22 = 0;
        while (i22 < 50) {
            tmp1 = System.currentTimeMillis();
            this.paintText(text, color, true);
            this.paintOn.repaint();
            tmpResult = sleepTime - (System.currentTimeMillis() - tmp1);
            if (tmpResult < 2L) {
                tmpResult = 2L;
            }
            try {
                Thread.sleep(tmpResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.abort) {
                return;
            }
            ++i22;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception i22) {
            // empty catch block
        }
        if (this.abort) {
            return;
        }
        int i = 0;
        while (i < 50) {
            tmp1 = System.currentTimeMillis();
            this.paintText(text, color, false);
            this.paintOn.repaint();
            tmpResult = sleepTime - (System.currentTimeMillis() - tmp1);
            if (tmpResult < 2L) {
                tmpResult = 2L;
            }
            try {
                Thread.sleep(tmpResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.abort) {
                return;
            }
            ++i;
        }
        this.alphaCounter = 0.0f;
    }

    private void showScrolltext(Vector scrollText) {
        long sleepTime = 20L;
        boolean bContinue = true;
        do {
            long tmp1 = System.currentTimeMillis();
            bContinue = this.paintScrolltext(scrollText);
            this.paintOn.repaint();
            long tmpResult = sleepTime - (System.currentTimeMillis() - tmp1);
            if (tmpResult < 2L) {
                tmpResult = 2L;
            }
            try {
                Thread.sleep(tmpResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.abort) continue;
            return;
        } while (bContinue);
    }

    void startIntro() {
        this.showBlendingText("JOne", Color.red, 120);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("presented by", Color.blue);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingLogo(this.iiSSD.getImage());
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("Programmer & GFX", Color.red, 80);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("Stefan1200", Color.blue);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showScrolltext(this.vecScrollText);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("Homepage", Color.red);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("www.stefan1200.de", Color.blue, 60);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.showBlendingText("The end...", Color.blue);
        if (this.abort) {
            this.stopCreditAnim();
            return;
        }
        this.stopCreditAnim();
    }

    private void stopCreditAnim() {
        this.closeFullScreen();
        this.dispose();
    }

    private void fillScrollText() {
        this.vecScrollText.addElement(this.lang.getTranslationString("ThanksAndGreetings", "Thanks and greetings"));
        this.vecScrollText.addElement(this.lang.getTranslationString("ThanksFor", "for testing, bug reports and feature requests going to..."));
        this.vecScrollText.addElement(" ");
        Arrays.sort(this.creditsNames, new IgnoreCaseComparatorAsc());
        int i = 0;
        while (i < this.creditsNames.length) {
            this.vecScrollText.addElement(this.creditsNames[i]);
            ++i;
        }
        this.vecScrollText.addElement(this.lang.getTranslationString("AndAllIForgot", "...and all I forgot."));
        this.vecScrollText.addElement(" ");
        this.vecScrollText.addElement(" ");
        this.vecScrollText.addElement(this.lang.getTranslationString("SpecialThanks", "A special thanks go to"));
        this.vecScrollText.addElement("http://www.java-forum.net");
    }

    private boolean paintScrolltext(Vector scrollText) {
        this.g2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.g2D.setFont(this.font);
        this.g2D.setBackground(Color.BLACK);
        this.g2D.clearRect(0, 0, 800, 600);
        this.g2D.setColor(Color.white);
        int pos = 0;
        int i = 0;
        while (i < scrollText.size()) {
            pos = 600 - this.counter * 1 + i * (this.fontHeight + 10);
            if (pos <= 150) {
                this.g2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, 150.0f, Color.white));
            } else if (pos >= 450) {
                this.g2D.setPaint(new GradientPaint(0.0f, 450.0f, Color.WHITE, 0.0f, 600.0f, Color.BLACK));
            }
            this.g2D.drawString(scrollText.elementAt(i).toString(), 400 - this.fm.stringWidth(scrollText.elementAt(i).toString()) / 2, pos);
            ++i;
        }
        ++this.counter;
        return pos > 0;
    }

    private void paintLogo(Image logo, boolean alphaPlus) {
        this.g2D.setBackground(Color.BLACK);
        this.g2D.clearRect(0, 0, 800, 600);
        this.g2D.setColor(Color.white);
        this.g2D.setComposite(AlphaComposite.getInstance(3, this.alphaCounter));
        int logoY = 300 - logo.getHeight(null) / 2;
        int logoX = 400 - logo.getWidth(null) / 2;
        this.g2D.drawImage(logo, logoX, logoY, null);
        this.alphaCounter = alphaPlus ? (float)((double)this.alphaCounter + 0.02) : (float)((double)this.alphaCounter - 0.02);
    }

    private void paintText(String text, Color color, boolean alphaPlus) {
        this.g2D.setFont(this.fontCustom);
        this.g2D.setBackground(Color.BLACK);
        this.g2D.clearRect(0, 0, 800, 600);
        this.g2D.setColor(Color.white);
        this.g2D.setComposite(AlphaComposite.getInstance(3, this.alphaCounter));
        int textY = 300 - this.fontCustomHeight / 2 + this.fontCustom.getSize();
        int textX = 400 - this.fmCustom.stringWidth(text) / 2;
        this.g2D.setPaint(new GradientPaint(0.0f, 200.0f, color, 0.0f, 200 + (int)((double)this.fontCustom.getSize() * 1.8), Color.white));
        this.g2D.drawString(text, textX, textY);
        this.alphaCounter = alphaPlus ? (float)((double)this.alphaCounter + 0.02) : (float)((double)this.alphaCounter - 0.02);
    }

    DisplayMode getDisplayMode(int width, int height, int depth) {
        Vector<DisplayMode> dmModes = new Vector<DisplayMode>();
        Vector<String> chooseDMMode = new Vector<String>();
        int i = this.dm.length - 1;
        while (i >= 0) {
            if (this.dm[i].getWidth() == width && this.dm[i].getHeight() == height && this.dm[i].getBitDepth() >= depth) {
                dmModes.addElement(this.dm[i]);
                chooseDMMode.addElement(String.valueOf(Integer.toString(this.dm[i].getBitDepth())) + " Bit - " + Integer.toString(this.dm[i].getRefreshRate()) + " Hz");
            }
            --i;
        }
        if (chooseDMMode.size() == 0) {
            return null;
        }
        Object ret = JOptionPane.showInputDialog(this, this.lang.getTranslationString("SelectScreenMode", "Select Screen Depth and Refresh Rate"), this.lang.getTranslationString("SelectMode", "Select Mode"), 3, null, chooseDMMode.toArray(), chooseDMMode.elementAt(0).toString());
        if (ret == null) {
            return null;
        }
        return (DisplayMode)dmModes.elementAt(chooseDMMode.indexOf(ret));
    }

    private void openFullScreen(DisplayMode dmtmp) {
        if (dmtmp == null) {
            this.setSize((int)this.dim.getWidth(), (int)this.dim.getHeight());
            this.setLocation(0, 0);
        } else {
            this.setSize(dmtmp.getWidth(), dmtmp.getHeight());
            this.gd.setFullScreenWindow(this);
            this.gd.setDisplayMode(dmtmp);
        }
        this.setVisible(true);
    }

    private void closeFullScreen() {
        this.gd.setFullScreenWindow(null);
        this.setVisible(false);
    }

    class DrawPanel
    extends JPanel {
        DrawPanel() {
        }

        public void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, (int)Credits.this.dim.getWidth(), (int)Credits.this.dim.getHeight());
            g.drawImage(Credits.this.bi, (int)Credits.this.dim.getWidth() / 2 - 400, (int)Credits.this.dim.getHeight() / 2 - 300, null);
        }
    }
}

