/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringTokenizer;
import java.util.Vector;

class Connection
extends Thread {
    static final int PORT = 5866;
    public static final double BUILD_REQUIRED = 2.1;
    static final String SERVER_MSG = "100 ";
    static final String CHAT_MSG = "101 ";
    static final String CLIENT_NICK = "102 ";
    static final String NICK_LIST = "103 ";
    static final String CHAT_MOVE = "104 ";
    static final String PING = "105 ";
    static final String CLIENT_VERSION = "106 ";
    static final String PONG = "107 ";
    static final String CHAT_ME = "108 ";
    static final String JOIN = "109 ";
    static final String SERVER_VERSION = "110 ";
    static final String SERVER_OLD_MSG = "111 ";
    static final String SERVER_CLIENT_OLD = "112 ";
    static final String SERVER_ILLEGALNICK = "113 ";
    static final String SERVER_FULL = "114";
    static final String SERVER_WELCOMEMSG = "115 ";
    static final String SPECTATOR_MODE = "120 ";
    static final String AUTOPING = "121 ";
    static final String GAME_START = "200 ";
    static final String GAME_MOVE = "201 ";
    static final String GAME_NOCARDS = "202 ";
    static final String GAME_POINTS_RESET = "203 ";
    static final String GAME_POINTS = "204 ";
    static final String GAME_WON = "205 ";
    static final String GAME_STATUS = "206 ";
    static final String GAME_READY = "207 ";
    static final String GAME_CARD_BACK = "208 ";
    static final String EXIT_GAME = "600";
    static final String CLOSED_CONNECTION = "601 ";
    private JOne mainClass;
    private Socket client;
    private BufferedReader in;
    private PrintStream out;
    AppTranslation lang;
    private String host;
    private long timePing = 0L;
    private long lastAutoPing = System.currentTimeMillis();

    Connection(JOne mainClass, String host, AppTranslation lang) {
        this.mainClass = mainClass;
        this.host = host;
        this.lang = lang;
        mainClass.addLogMessage(lang.getTranslationString("ConnectingTo", "Connecting to %1", String.valueOf(host) + ":" + Integer.toString(5866)), mainClass.STYLE_CLIENTMSG);
    }

    void sendPing() {
        this.timePing = System.currentTimeMillis();
        this.send(PING, "");
    }

    boolean isOnline() {
        if (this.client == null) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastAutoPing > 60000L) {
            return false;
        }
        return this.client.isConnected();
    }

    public void run() {
        this.createClient();
    }

    private void createClient() {
        block4: {
            try {
                this.client = new Socket(this.host, 5866);
                if (this.client.isConnected()) {
                    this.clientConnection();
                } else {
                    this.mainClass.closeGame();
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("CouldNotConnectTo", "Could not connect to %1", String.valueOf(this.host) + ":" + Integer.toString(5866)), this.mainClass.STYLE_ERRORMSG, false);
                }
            }
            catch (Exception e) {
                this.mainClass.closeGame();
                this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("CouldNotConnectTo", "Could not connect to %1", String.valueOf(this.host) + ":" + Integer.toString(5866)), this.mainClass.STYLE_ERRORMSG, false);
                if (!JOne.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    private void clientConnection() {
        block5: {
            try {
                this.mainClass.saveIPHistory();
                this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream(), "UTF-8"));
                this.out = new PrintStream(this.client.getOutputStream(), true, "UTF-8");
                this.send(CLIENT_VERSION, "2.112?JOne 2.11.2 (19.06.2014)");
                this.receive();
            }
            catch (Exception e) {
                if (JOne.DEBUG) {
                    e.printStackTrace();
                }
                try {
                    this.client.close();
                }
                catch (Exception e2) {
                    if (!JOne.DEBUG) break block5;
                    e2.printStackTrace();
                }
            }
        }
    }

    void send(String type, String msg) {
        block3: {
            try {
                if (this.isOnline()) {
                    this.out.println(String.valueOf(type) + msg);
                }
            }
            catch (Exception e) {
                if (!JOne.DEBUG) break block3;
                e.printStackTrace();
                this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, e.toString(), this.mainClass.STYLE_ERRORMSG, false);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void receive() {
        try {
            block6: while (true) {
                line = this.in.readLine();
                if (this.isInterrupted() || line == null) break;
                if (line.startsWith("101 /clientinfo")) {
                    this.send("100 ", "JOne 2.11.2 (19.06.2014)");
                    continue;
                }
                if (line.startsWith("108 ")) {
                    pos = line.substring(4).indexOf("?");
                    if (pos == -1) continue;
                    nickTMP = line.substring(4).substring(0, pos);
                    if (nickTMP.equals(this.mainClass.getLocalNickname())) {
                        this.mainClass.addLogMessage(String.valueOf(nickTMP) + " " + line.substring(4).substring(pos + 1), this.mainClass.STYLE_CHATOWNNAME);
                        continue;
                    }
                    this.mainClass.addLogMessage(String.valueOf(nickTMP) + " " + line.substring(4).substring(pos + 1), this.mainClass.STYLE_CHATNAME);
                    continue;
                }
                if (line.startsWith("103 ")) {
                    if (JOne.DEBUG) {
                        this.mainClass.addLogMessage("Nick list from Server", this.mainClass.STYLE_SERVERMSG, line.substring(4), this.mainClass.STYLE_SERVERMSG, false);
                    }
                    specNickList = new Vector<String>();
                    if (line.length() > 5) {
                        st = new StringTokenizer(line.substring(4), "?", false);
                        while (st.hasMoreTokens()) {
                            specNickList.addElement(st.nextToken());
                        }
                    }
                    this.mainClass.setSpectatorNickList(specNickList);
                    continue;
                }
                if (line.startsWith("110 ")) {
                    isAllowed = false;
                    try {
                        checkIt = Double.parseDouble(line.substring(4));
                        isAllowed = checkIt >= 2.1;
                    }
                    catch (Exception checkIt) {
                        // empty catch block
                    }
                    if (isAllowed) {
                        this.send("102 ", this.mainClass.getLocalNickname());
                        continue;
                    }
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("JOneServerOldMessage", "The JOneServer is older than %1!", Double.toString(2.1)), this.mainClass.STYLE_ERRORMSG, false);
                    this.send("111 ", "");
                    this.send("600", "");
                    continue;
                }
                if (line.startsWith("200 ")) {
                    st = new StringTokenizer(line.substring(4), "?", false);
                    if (!this.mainClass.getLocalNickname().equals(st.nextToken())) continue;
                    this.mainClass.setFirstCard(Integer.parseInt(st.nextToken()));
                    this.mainClass.setGameRules(Long.parseLong(st.nextToken()));
                    while (st.hasMoreTokens()) {
                        this.mainClass.setStartCards(Integer.parseInt(st.nextToken()));
                    }
                    newGame = new Thread(this.mainClass);
                    newGame.start();
                    continue;
                }
                if (line.startsWith("206 ")) {
                    if (JOne.DEBUG) {
                        this.mainClass.addLogMessage("Game status from Server", this.mainClass.STYLE_SERVERMSG, line.substring(4), this.mainClass.STYLE_SERVERMSG, false);
                    }
                    st = new StringTokenizer(line.substring(4), "?", false);
                    currentPlayer = st.nextToken();
                    drawCount = Integer.parseInt(st.nextToken());
                    playerDirectionRight = Boolean.parseBoolean(st.nextToken());
                    cardsDeckCount = Integer.parseInt(st.nextToken());
                    playerNamesList = new Vector<String>();
                    playerCardsCountList = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        playerNamesList.addElement(st.nextToken());
                        playerCardsCountList.addElement(st.nextToken());
                    }
                    this.mainClass.updateGameStatus(currentPlayer, drawCount, playerDirectionRight, cardsDeckCount, playerNamesList, playerCardsCountList);
                    continue;
                }
                if (line.startsWith("201 ")) {
                    st = new StringTokenizer(line.substring(4), "?", false);
                    this.mainClass.handlePlayerAction(st.nextToken(), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                    continue;
                }
                if (line.startsWith("205 ")) {
                    st = new StringTokenizer(line.substring(4), "?", false);
                    player = st.nextToken();
                    scoreData = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        scoreData.addElement(st.nextToken());
                    }
                    this.mainClass.setPlayerWon(player, scoreData);
                    this.mainClass.refreshScoreboard(scoreData);
                    continue;
                }
                if (line.startsWith("202 ")) {
                    this.mainClass.addLogMessage(this.lang.getTranslationString("SorryNoMoreCardsAvailable", "Sorry, no more cards available!"), this.mainClass.STYLE_ERRORMSG);
                    this.mainClass.enableDrawCard();
                    continue;
                }
                if (line.equals("120 ")) {
                    this.mainClass.setSpecMode();
                    continue;
                }
                if (line.equals("107 ")) {
                    this.send("107 ", "");
                    continue;
                }
                if (line.equals("105 ")) {
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Server", "Server"), String.valueOf(this.lang.getTranslationString("PingBackAfter", "Ping back after")) + " " + Long.toString(System.currentTimeMillis() - this.timePing) + this.lang.getTranslationString("ms", "ms"), false);
                    this.timePing = 0L;
                    continue;
                }
                if (line.equals("121 ")) {
                    this.lastAutoPing = System.currentTimeMillis();
                    continue;
                }
                if (line.equals("600")) break;
                if (line.startsWith("109 ")) {
                    joinnick = line.substring(4);
                    if (joinnick.equals(this.mainClass.getLocalNickname())) {
                        this.mainClass.createGameGUI();
                        this.mainClass.startPingTimer();
                        this.lastAutoPing = System.currentTimeMillis();
                    }
                    this.mainClass.playConnectionSound();
                    this.mainClass.addLogMessage(">>> " + this.lang.getTranslationString("PlayerJoinTheGame", "Player %1 join the game...", joinnick), this.mainClass.STYLE_PLAYERJOINLEFT);
                    continue;
                }
                if (line.startsWith("601 ")) {
                    if (line.substring(4).startsWith("kick")) {
                        this.mainClass.addLogMessage("<<< " + this.lang.getTranslationString("KickedAdmin", "%1 was kicked by JOneServer Admin!", line.substring(8)), this.mainClass.STYLE_PLAYERJOINLEFT);
                    } else {
                        this.mainClass.addLogMessage("<<< " + this.lang.getTranslationString("ClosedConnectionFrom", "Connection from %1 closed...", line.substring(4)), this.mainClass.STYLE_PLAYERJOINLEFT);
                    }
                    this.mainClass.updatePlayerList();
                    continue;
                }
                if (line.startsWith("203 ")) {
                    this.mainClass.resetScoreboard(line.substring(4));
                    continue;
                }
                if (line.startsWith("204 ")) {
                    if (JOne.DEBUG) {
                        this.mainClass.addLogMessage("Scores from Server", this.mainClass.STYLE_SERVERMSG, line.substring(4), this.mainClass.STYLE_SERVERMSG, false);
                    }
                    st = new StringTokenizer(line.substring(4), "?", false);
                    scoreData = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        scoreData.addElement(st.nextToken());
                    }
                    this.mainClass.refreshScoreboard(scoreData);
                    continue;
                }
                if (line.startsWith("101 ")) {
                    this.mainClass.addLogMessage(line.substring(4), true);
                    continue;
                }
                if (line.startsWith("104 ")) {
                    this.mainClass.addGameMoveLogMessage(line.substring(4));
                    continue;
                }
                if (line.equals("113 ")) {
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("IllegalNick", "Your nickname is already in use or not allowed!"), this.mainClass.STYLE_ERRORMSG, false);
                    this.mainClass.setFocusToNickname();
                    continue;
                }
                if (line.equals("114")) {
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("ServerFull", "Server is full!"), this.mainClass.STYLE_ERRORMSG, false);
                    continue;
                }
                if (line.startsWith("112 ")) {
                    this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("ClientToOld", "Your JOne client is to old!"), this.mainClass.STYLE_ERRORMSG, false);
                    continue;
                }
                if (line.startsWith("115 ")) {
                    stMSG = new StringTokenizer(line.substring(4), "\u00a7", false);
                    while (true) {
                        if (!stMSG.hasMoreTokens()) continue block6;
                        this.mainClass.addLogMessage(stMSG.nextToken(), this.mainClass.STYLE_SERVERMSG);
                    }
                }
                if (!line.startsWith("100 ")) continue;
                stMSG = new StringTokenizer(line.substring(4), "?", false);
                this.mainClass.addLogMessage(this.lang.getTranslationString("Server", "Server"), this.mainClass.STYLE_SERVERMSG);
                while (true) {
                    if (stMSG.hasMoreTokens()) ** break;
                    continue block6;
                    this.mainClass.addLogMessage(stMSG.nextToken(), this.mainClass.STYLE_SERVERMSG);
                }
                break;
            }
            this.mainClass.closeGame();
            this.mainClass.addLogMessage(this.lang.getTranslationString("ConnectionServerClosed", "Connection to server closed!"), this.mainClass.STYLE_CLIENTMSG);
            this.closeConnection();
        }
        catch (SocketException e) {
            if (JOne.DEBUG) {
                e.printStackTrace();
            }
            this.mainClass.closeGame();
            this.closeConnection();
            this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("ConnectionServer", "Connection to server lost!"), this.mainClass.STYLE_ERRORMSG, false);
        }
        catch (IOException e2) {
            if (JOne.DEBUG) {
                e2.printStackTrace();
            }
            this.mainClass.closeGame();
            this.closeConnection();
            this.mainClass.addLogMessage(this.lang.getTranslationString("Error", "Error"), this.mainClass.STYLE_ERRORMSG, this.lang.getTranslationString("ConnectionServer", "Connection to server lost!"), this.mainClass.STYLE_ERRORMSG, false);
        }
        catch (Exception eAll) {
            eAll.printStackTrace();
        }
    }

    void closeAndInterrupt() {
        block4: {
            try {
                if (this.isAlive()) {
                    this.interrupt();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!JOne.DEBUG) break block4;
                e.printStackTrace();
            }
        }
    }

    void closeConnection() {
        block5: {
            this.mainClass.stopPingTimer();
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
            }
            catch (Exception e) {
                if (!JOne.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    String getIPAddress() {
        String tmp = this.client.getRemoteSocketAddress().toString();
        if (tmp.startsWith("/")) {
            return tmp.substring(1);
        }
        return tmp;
    }
}

